/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Utilitys;

import com.github.Viduality.VSkyblock.SQLConnector;
import com.github.Viduality.VSkyblock.VSkyblock;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DatabaseWriter {
    private final VSkyblock plugin;
    private final SQLConnector connector;

    public DatabaseWriter(VSkyblock plugin, SQLConnector connector) {
        this.plugin = plugin;
        this.connector = connector;
    }

    public void addPlayer(UUID uuid, String name) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO VSkyblock_Player(uuid, playername) VALUES(?, ?)");
                preparedStatement.setString(1, uuid.toString());
                preparedStatement.setString(2, name);
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void addIsland(String island, UUID uuid, String difficutly) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO VSkyblock_Island(island, difficulty) VALUES(?, ?)");
                preparedStatement.setString(1, island);
                preparedStatement.setString(2, difficutly);
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            int[] newislandidarray = new int[]{0};
            this.connector.getReader().getislandid(island, result -> {
                newislandidarray[0] = result;
                this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    int islandid = newislandidarray[0];
                    try (Connection connection = this.connector.getConnection();){
                        PreparedStatement preparedStatement = connection.prepareStatement("UPDATE VSkyblock_Player SET islandid = ?, islandowner = true WHERE uuid = ?");
                        preparedStatement.setInt(1, islandid);
                        preparedStatement.setString(2, uuid.toString());
                        preparedStatement.executeUpdate();
                        preparedStatement.close();
                        PreparedStatement preparedStatement1 = connection.prepareStatement("INSERT INTO VSkyblock_IslandLocations(islandid) VALUES (?)");
                        preparedStatement1.setInt(1, islandid);
                        preparedStatement1.executeUpdate();
                        preparedStatement1.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                });
            });
        });
    }

    public void kickPlayerfromIsland(final UUID uuid) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                try (Connection connection = DatabaseWriter.this.connector.getConnection();){
                    PreparedStatement preparedStatement = connection.prepareStatement("UPDATE VSkyblock_Player SET islandid = NULL, owneruuid = NULL, kicked = 1 WHERE uuid = ?");
                    preparedStatement.setString(1, uuid.toString());
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void removeKicked(UUID uuid) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE VSkyblock_Player SET kicked = 0 WHERE uuid = ?");
                preparedStatement.setString(1, uuid.toString());
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void updateOwner(UUID oldOwner, UUID newOwner) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE VSkyblock_Player SET islandowner = 0 WHERE uuid = ?");
                preparedStatement.setString(1, oldOwner.toString());
                preparedStatement.executeUpdate();
                preparedStatement.close();
                PreparedStatement preparedStatement1 = connection.prepareStatement("UPDATE VSkyblock_Player SET islandowner = 1 WHERE uuid = ?");
                preparedStatement1.setString(1, newOwner.toString());
                preparedStatement1.executeUpdate();
                preparedStatement1.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void leavefromIsland(UUID uuid) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE VSkyblock_Player SET islandid = NULL, owneruuid = NULL, islandowner = 0 WHERE uuid = ?");
                preparedStatement.setString(1, uuid.toString());
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void updatePlayersIsland(UUID uuid, int islandid, boolean islandowner) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Integer islandownerInt = islandowner ? Integer.valueOf(1) : Integer.valueOf(0);
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE VSkyblock_Player SET islandid = ?, islandowner = ? WHERE uuid = ?");
                preparedStatement.setInt(1, islandid);
                preparedStatement.setString(2, String.valueOf(islandownerInt));
                preparedStatement.setString(3, uuid.toString());
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void deleteIsland(String island) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                int islandid = 0;
                PreparedStatement getid = connection.prepareStatement("SELECT * FROM VSkyblock_Island WHERE island = ?");
                getid.setString(1, island);
                ResultSet r = getid.executeQuery();
                while (r.next()) {
                    islandid = r.getInt("islandid");
                }
                getid.close();
                PreparedStatement deleteIsland = connection.prepareStatement("DELETE FROM VSkyblock_Island WHERE island = ?");
                deleteIsland.setString(1, island);
                deleteIsland.executeUpdate();
                deleteIsland.close();
                if (islandid != 0) {
                    PreparedStatement deleteFromLocations = connection.prepareStatement("DELETE FROM VSkyblock_IslandLocations WHERE islandid = ?");
                    deleteFromLocations.setInt(1, islandid);
                    deleteFromLocations.executeUpdate();
                    deleteIsland.close();
                    PreparedStatement deleteFromChallenges = connection.prepareStatement("DELETE FROM VSkyblock_Challenges WHERE islandid = ?");
                    deleteFromChallenges.setInt(1, islandid);
                    deleteFromChallenges.executeUpdate();
                    deleteFromChallenges.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void updateChallengeCount(int islandid, String mySQLKey, int count) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                String statement = "INSERT INTO VSkyblock_Challenges(islandid, count, challenge) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE count = VALUES(count)";
                PreparedStatement updateCount = connection.prepareStatement(statement);
                updateCount.setInt(1, islandid);
                updateCount.setInt(2, count);
                updateCount.setString(3, mySQLKey);
                updateCount.executeUpdate();
                updateCount.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void updateChallengeTracked(int islandid, String mySQLKey, boolean tracked) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                String statement = "INSERT INTO VSkyblock_Challenges(islandid, tracked, challenge) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE tracked = VALUES(tracked)";
                PreparedStatement updateCount = connection.prepareStatement(statement);
                updateCount.setInt(1, islandid);
                updateCount.setBoolean(2, tracked);
                updateCount.setString(3, mySQLKey);
                updateCount.executeUpdate();
                updateCount.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void updateIslandLevel(int islandid, Integer level, Integer totalblocks, UUID uuid) {
        this.connector.getReader().getIslandMembers(islandid, result -> this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement updateChallengeCount = connection.prepareStatement("UPDATE VSkyblock_Island SET islandlevel = ?, totalblocks = ? WHERE islandid = ?");
                updateChallengeCount.setInt(1, level);
                updateChallengeCount.setInt(2, totalblocks);
                updateChallengeCount.setInt(3, islandid);
                updateChallengeCount.executeUpdate();
                updateChallengeCount.close();
                PreparedStatement updatehighestreachedlevel = connection.prepareStatement("UPDATE VSkyblock_Player SET highestreachedlevel = ? WHERE uuid = ? AND highestreachedlevel < ?");
                updatehighestreachedlevel.setInt(1, level);
                updatehighestreachedlevel.setString(2, uuid.toString());
                updatehighestreachedlevel.setInt(3, level);
                updatehighestreachedlevel.executeUpdate();
                updatehighestreachedlevel.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }));
    }

    public void updateIslandOptions(Player player, boolean visit, boolean needsRequest, String difficulty, Callback callback) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                int islandid = 0;
                String islandname = null;
                PreparedStatement preparedStatementREAD = connection.prepareStatement("SELECT islandid FROM VSkyblock_Player WHERE uuid = ?");
                preparedStatementREAD.setString(1, player.getUniqueId().toString());
                ResultSet resultSet = preparedStatementREAD.executeQuery();
                while (resultSet.next()) {
                    islandid = resultSet.getInt("islandid");
                }
                preparedStatementREAD.close();
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE VSkyblock_Island SET visit = ?, visitneedsrequest = ?, difficulty = ? WHERE islandid = ?");
                preparedStatement.setBoolean(1, visit);
                preparedStatement.setBoolean(2, needsRequest);
                preparedStatement.setString(3, difficulty);
                preparedStatement.setInt(4, islandid);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                PreparedStatement preparedStatementGetIslandName = connection.prepareStatement("SELECT island FROM VSkyblock_Island WHERE islandid = ?");
                preparedStatementGetIslandName.setInt(1, islandid);
                ResultSet resultSet1 = preparedStatementGetIslandName.executeQuery();
                while (resultSet1.next()) {
                    islandname = resultSet1.getString("island");
                }
                preparedStatementGetIslandName.close();
                this.plugin.getWorldManager().setOption(islandname, "difficulty", difficulty);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(true));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void updateCobblestoneGeneratorLevel(String islandname, Integer level) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement updateGeneratorLevel = connection.prepareStatement("UPDATE VSkyblock_Island SET cobblestonelevel = ? WHERE island = ?");
                updateGeneratorLevel.setInt(1, level);
                updateGeneratorLevel.setString(2, islandname);
                updateGeneratorLevel.executeUpdate();
                updateGeneratorLevel.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void updateDeathCount(UUID uuid, int count) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE VSkyblock_Player SET deaths = ? WHERE uuid = ?");
                preparedStatement.setInt(1, count);
                preparedStatement.setString(2, uuid.toString());
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void updatePlayerName(UUID uuid, String name) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("UPDATE VSkyblock_Player SET playername = ? WHERE uuid = ?");
                preparedStatement.setString(1, name);
                preparedStatement.setString(2, uuid.toString());
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void savelastLocation(UUID uuid, Location loc) {
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        double pitch = loc.getPitch();
        double yaw = loc.getYaw();
        String world = loc.getWorld().getName();
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement savelastLoc = connection.prepareStatement("UPDATE VSkyblock_Player SET lastX = ?, lastY = ?, lastZ = ?, lastPitch = ?, lastYaw = ?, lastWorld = ? WHERE uuid = ?");
                savelastLoc.setDouble(1, x);
                savelastLoc.setDouble(2, y);
                savelastLoc.setDouble(3, z);
                savelastLoc.setDouble(4, pitch);
                savelastLoc.setDouble(5, yaw);
                savelastLoc.setString(6, world);
                savelastLoc.setString(7, uuid.toString());
                savelastLoc.executeUpdate();
                savelastLoc.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void saveNetherHome(int islandid, Location loc) {
        int i;
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        float yaw = loc.getYaw();
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        boolean northsouth = false;
        if (yaw > 135.0f && yaw <= 225.0f) {
            loc.setYaw(180.0f);
            northsouth = true;
        } else if (yaw > 315.0f && yaw <= 360.0f) {
            loc.setYaw(0.0f);
            northsouth = true;
        } else if (yaw > 0.0f && yaw <= 45.0f) {
            loc.setYaw(0.0f);
            northsouth = true;
        } else if (yaw > 45.0f && yaw <= 135.0f) {
            loc.setYaw(90.0f);
        } else {
            loc.setYaw(270.0f);
        }
        World world = loc.getWorld();
        boolean facingPortal = false;
        if (northsouth) {
            for (i = -3; i < 4; ++i) {
                double currentZ;
                Location l;
                if (i == 0 || !world.getBlockAt(l = new Location(world, x, y, currentZ = z + (double)i)).getType().equals((Object)Material.OBSIDIAN)) continue;
                facingPortal = true;
                break;
            }
        } else {
            for (i = -3; i < 4; ++i) {
                double currentX;
                Location l;
                if (i == 0 || !world.getBlockAt(l = new Location(world, currentX = x + (double)i, y, z)).getType().equals((Object)Material.OBSIDIAN)) continue;
                facingPortal = true;
                break;
            }
        }
        double rotation = loc.getYaw();
        if (facingPortal) {
            rotation += 90.0;
        }
        loc.setYaw((float)rotation);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement savelastLoc = connection.prepareStatement("UPDATE VSkyblock_IslandLocations SET netherX = ?, netherY = ?, netherZ = ?, netherYaw = ?, netherWorld = ? WHERE islandid = ?");
                savelastLoc.setDouble(1, x);
                savelastLoc.setDouble(2, y);
                savelastLoc.setDouble(3, z);
                savelastLoc.setFloat(4, loc.getYaw());
                savelastLoc.setString(5, world.getName());
                savelastLoc.setString(6, String.valueOf(islandid));
                savelastLoc.executeUpdate();
                savelastLoc.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void setIslandSpawn(int islandid, Location loc) {
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        float yaw = loc.getYaw();
        float pitch = loc.getPitch();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement savelastLoc = connection.prepareStatement("UPDATE VSkyblock_IslandLocations SET spawnX = ?, spawnY = ?, spawnZ = ?, spawnYaw = ?, spawnPitch = ? WHERE islandid = ?");
                savelastLoc.setDouble(1, x);
                savelastLoc.setDouble(2, y);
                savelastLoc.setDouble(3, z);
                savelastLoc.setFloat(4, yaw);
                savelastLoc.setFloat(5, pitch);
                savelastLoc.setString(6, String.valueOf(islandid));
                savelastLoc.executeUpdate();
                savelastLoc.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public static interface Callback {
        public void onQueryDone(boolean var1);
    }
}

