/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Utilitys;

import com.github.Viduality.VSkyblock.Challenges.Challenge;
import com.github.Viduality.VSkyblock.Challenges.ChallengesManager;
import com.github.Viduality.VSkyblock.Utilitys.ChallengesCache;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.VSkyblock;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class Scoreboardmanager {
    private final VSkyblock plugin;
    private ScoreboardManager sm;

    public Scoreboardmanager(VSkyblock plugin) {
        this.plugin = plugin;
        this.sm = plugin.getServer().getScoreboardManager();
    }

    public boolean doesobjectiveexist(String objective) {
        return this.plugin.getServer().getScoreboardManager().getMainScoreboard().getObjective(objective) != null;
    }

    public boolean updatePlayerScore(String playername, String objective, int score) {
        if (this.doesobjectiveexist(objective)) {
            Objective obj = this.sm.getMainScoreboard().getObjective(objective);
            obj.getScore(playername).setScore(score);
            return true;
        }
        return false;
    }

    public boolean addPlayerToObjective(Player player, String objective) {
        if (this.doesobjectiveexist(objective)) {
            Objective obj = this.plugin.getServer().getScoreboardManager().getMainScoreboard().getObjective("deaths");
            player.setScoreboard(obj.getScoreboard());
            return true;
        }
        return false;
    }

    public boolean hasPlayerScore(String playername, String objective) {
        if (this.doesobjectiveexist(objective)) {
            Objective obj = this.sm.getMainScoreboard().getObjective(objective);
            return obj.getScore(playername) != null;
        }
        return false;
    }

    public int getPlayerScore(String playername, String objective) {
        Objective obj;
        if (this.doesobjectiveexist(objective) && (obj = this.sm.getMainScoreboard().getObjective(objective)) != null) {
            return obj.getScore(playername).getScore();
        }
        return 0;
    }

    public void updateTracked(int islandId, ChallengesCache challenges) {
        this.plugin.getDb().getReader().getIslandMembers(islandId, members -> {
            for (String member : members) {
                Player player = this.plugin.getServer().getPlayer(member);
                if (player == null) continue;
                this.updateTracked(player, challenges);
            }
        });
    }

    public void updateTracked(Player player, ChallengesCache challenges) {
        if (challenges.getTrackedChallenges().isEmpty()) {
            player.setScoreboard(this.sm.getMainScoreboard());
        } else {
            int i;
            Objective sidebar;
            if (player.getScoreboard() == this.sm.getMainScoreboard()) {
                player.setScoreboard(this.sm.getNewScoreboard());
            }
            if ((sidebar = player.getScoreboard().getObjective("tracked")) == null) {
                sidebar = player.getScoreboard().registerNewObjective("tracked", "dummy", ConfigShorts.getMessageConfig().getString("SideBarTrackedChallenges"));
            }
            if (sidebar.getDisplaySlot() != DisplaySlot.SIDEBAR) {
                sidebar.setDisplaySlot(DisplaySlot.SIDEBAR);
            }
            LinkedHashMap<Challenge, Integer> challengeCounts = new LinkedHashMap<Challenge, Integer>();
            for (String challengeId : challenges.getTrackedChallenges()) {
                Challenge challenge = ChallengesManager.challenges.get(challengeId);
                if (challenge == null) continue;
                challengeCounts.put(challenge, challenges.getChallengeCount(challengeId));
            }
            ArrayList lines = new ArrayList(challengeCounts.entrySet());
            for (i = 0; i < lines.size(); ++i) {
                String line;
                sidebar.getScore(ChatColor.values()[i].toString()).setScore(((Integer)((Map.Entry)lines.get(i)).getValue()).intValue());
                Team team = player.getScoreboard().getTeam("vskyblock_ct" + i);
                if (team == null) {
                    team = player.getScoreboard().registerNewTeam("vskyblock_ct" + i);
                    team.addEntry(ChatColor.values()[i].toString());
                }
                if ((line = ((Challenge)((Map.Entry)lines.get(i)).getKey()).getNeededText()).length() <= 32) {
                    team.setPrefix(ChatColor.YELLOW + line);
                    continue;
                }
                team.setPrefix(ChatColor.YELLOW + line.substring(0, 32) + "...");
            }
            for (i = lines.size(); i < 10; ++i) {
                player.getScoreboard().resetScores(ChatColor.values()[i].toString());
            }
        }
    }
}

