/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Utilitys;

import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.VSkyblock;
import com.github.Viduality.shaded.apachecommons.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class WorldManager {
    private VSkyblock plugin;

    public WorldManager(VSkyblock plugin) {
        this.plugin = plugin;
    }

    public boolean createIsland(String island) {
        if (!this.getAllWorlds().contains(island)) {
            File dir = new File(this.plugin.getServer().getWorldContainer().getAbsolutePath(), island);
            if (!dir.exists()) {
                File[] files;
                dir.mkdirs();
                File source = new File(this.plugin.getServer().getWorldContainer().getAbsolutePath(), "VSkyblockMasterIsland");
                try {
                    FileUtils.copyDirectory(source, dir);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (File file : files = dir.listFiles()) {
                    if (!file.getName().equalsIgnoreCase("uid.dat") && !file.getName().equalsIgnoreCase("session.lock")) continue;
                    file.delete();
                }
                WorldCreator wc = new WorldCreator(island);
                wc.generator("VSkyblock");
                wc.environment(World.Environment.NORMAL);
                wc.type(WorldType.FLAT);
                wc.generateStructures(false);
                World newIsland = wc.createWorld();
                this.plugin.getServer().getWorlds().add(newIsland);
                this.plugin.getServer().getWorld(island).setSpawnLocation(0, 67, 0);
                newIsland.setDifficulty(this.getDifficulty(newIsland.getName()));
                newIsland.setKeepSpawnInMemory(false);
                if (this.addWorld(island, "VSkyblock", "NORMAL")) {
                    return true;
                }
                this.plugin.getLogger().severe("Could not add world to config!");
                return false;
            }
            this.plugin.getLogger().severe("Folder already exists!");
        } else {
            this.plugin.getLogger().warning("Tried to create a world but VSkyblock already knows about it!");
        }
        return false;
    }

    public boolean unloadWorld(String world) {
        if (this.plugin.getServer().getWorlds().contains(this.plugin.getServer().getWorld(world))) {
            if (!ConfigShorts.getDefConfig().getString("SpawnWorld").equals(world)) {
                if (this.plugin.getServer().getWorld(world) != null) {
                    World spawnWorld = this.plugin.getServer().getWorld(ConfigShorts.getDefConfig().getString("SpawnWorld"));
                    if (spawnWorld == null) {
                        spawnWorld = (World)this.plugin.getServer().getWorlds().get(0);
                    }
                    for (Player player : this.plugin.getServer().getWorld(world).getPlayers()) {
                        player.teleportAsync(spawnWorld.getSpawnLocation());
                    }
                }
                return this.plugin.getServer().unloadWorld(world, true);
            }
            return false;
        }
        this.plugin.getLogger().warning("Tried to unload a world VSkyblock does not know about or which is already unloaded.");
        return false;
    }

    public boolean loadWorld(String world) {
        if (this.getAllWorlds().contains(world)) {
            if (this.getUnloadedWorlds().contains(world)) {
                WorldCreator wc = new WorldCreator(world);
                wc.generator(this.getGenerator(world));
                wc.environment(this.getEnvironment(world));
                wc.type(WorldType.FLAT);
                wc.generateStructures(this.generateStructures(world));
                World loadedworld = wc.createWorld();
                if (loadedworld != null) {
                    loadedworld.setDifficulty(this.getDifficulty(loadedworld.getName()));
                    loadedworld.setKeepSpawnInMemory(this.keepSpawnInMemory(world));
                    return true;
                }
                this.plugin.getLogger().severe("Failed to load world " + world);
                return false;
            }
            return this.getLoadedWorlds().contains(world);
        }
        this.plugin.getLogger().severe("Unknown world " + world);
        return false;
    }

    private String getGenerator(String world) {
        String option = ConfigShorts.getWorldConfig().getString("Worlds." + world + ".generator");
        if (option != null && option.equals("default")) {
            return null;
        }
        return option;
    }

    private World.Environment getEnvironment(String world) {
        try {
            return World.Environment.valueOf((String)ConfigShorts.getWorldConfig().getString("Worlds." + world + ".environment", "NORMAL").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return World.Environment.NORMAL;
        }
    }

    public boolean deleteWorld(String world) {
        if (this.getAllWorlds().contains(world)) {
            if (this.loadWorld(world)) {
                World delete = this.plugin.getServer().getWorld(world);
                File deleteFolder = delete.getWorldFolder();
                if (this.unloadWorld(world)) {
                    if (deleteFolder.exists()) {
                        File[] files;
                        for (File file : files = deleteFolder.listFiles()) {
                            if (file.isDirectory()) {
                                for (File file2 : file.listFiles()) {
                                    file2.delete();
                                }
                            }
                            file.delete();
                        }
                    }
                    this.deleteWorldfromConfig(world);
                    return deleteFolder.delete();
                }
                this.plugin.getLogger().severe("Could not delete world " + world);
                return false;
            }
            this.plugin.getLogger().severe("Could not delete world " + world);
            return false;
        }
        this.plugin.getLogger().severe("Unknown world: " + world);
        return false;
    }

    public Location getSpawnLocation(String world) {
        return this.getSpawnLocation(world, true);
    }

    public Location getSpawnLocation(String world, boolean load) {
        Set<String> worlds = this.getAllWorlds();
        if (worlds.contains(world)) {
            if (load && this.getUnloadedWorlds().contains(world)) {
                this.loadWorld(world);
            }
            World world1 = this.plugin.getServer().getWorld(world);
            double x = ConfigShorts.getWorldConfig().getDouble("Worlds." + world + ".spawnLocation.x");
            double y = ConfigShorts.getWorldConfig().getDouble("Worlds." + world + ".spawnLocation.y");
            double z = ConfigShorts.getWorldConfig().getDouble("Worlds." + world + ".spawnLocation.z");
            float yaw = (float)ConfigShorts.getWorldConfig().getDouble("Worlds." + world + ".spawnLocation.yaw");
            float pitch = (float)ConfigShorts.getWorldConfig().getDouble("Worlds." + world + ".spawnLocation.pitch");
            return new Location(world1, x, y, z, yaw, pitch);
        }
        this.plugin.getLogger().severe("Could not find a spawn location for world " + world + "!");
        return null;
    }

    public Set<String> getUnloadedWorlds() {
        List loadedWorlds = this.plugin.getServer().getWorlds();
        ArrayList<String> worlds = new ArrayList<String>();
        for (World world : loadedWorlds) {
            worlds.add(world.getName());
        }
        Set<String> allWorlds = this.getAllWorlds();
        HashSet<String> unloadedworlds = new HashSet<String>();
        for (String currentworld : allWorlds) {
            if (worlds.contains(currentworld)) continue;
            unloadedworlds.add(currentworld);
        }
        return unloadedworlds;
    }

    public List<String> getLoadedWorlds() {
        List loadedWorlds = this.plugin.getServer().getWorlds();
        ArrayList<String> worlds = new ArrayList<String>();
        for (World world : loadedWorlds) {
            worlds.add(world.getName());
        }
        return worlds;
    }

    public Set<String> getAllWorlds() {
        if (ConfigShorts.getWorldConfig().isConfigurationSection("Worlds")) {
            return ConfigShorts.getWorldConfig().getConfigurationSection("Worlds").getKeys(false);
        }
        return Collections.emptySet();
    }

    public boolean addWorld(String world, String generator, String environment) {
        ConfigurationSection worldConfig = ConfigShorts.getWorldConfig().createSection("Worlds." + world);
        worldConfig.set("generator", (Object)generator);
        worldConfig.set("environment", (Object)environment);
        try {
            ConfigShorts.getWorldConfig().save();
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Problem storing world " + world);
            e.printStackTrace();
            return false;
        }
    }

    public void deleteWorldfromConfig(String world) {
        ConfigShorts.getWorldConfig().set("Worlds." + world, null);
        try {
            ConfigShorts.getWorldConfig().save();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Problem deleting world " + world);
            e.printStackTrace();
        }
    }

    public void setOption(String world, String option, String value) {
        ConfigurationSection worldConfig = ConfigShorts.getWorldConfig().getConfigurationSection("Worlds." + world);
        if (worldConfig == null) {
            this.plugin.getLogger().severe("World " + world + " is not known?");
            return;
        }
        worldConfig.set(option, (Object)value);
        try {
            ConfigShorts.getWorldConfig().save();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Problem storing option " + option + ": " + value + " for world " + world);
            e.printStackTrace();
        }
    }

    public boolean setSpawnLocation(Location loc) {
        ConfigurationSection worldConfig = ConfigShorts.getWorldConfig().getConfigurationSection("Worlds." + loc.getWorld().getName());
        if (worldConfig == null) {
            this.plugin.getLogger().severe("World " + loc.getWorld().getName() + " is not known?");
            return false;
        }
        ConfigurationSection spawnSection = worldConfig.createSection("spawnLocation");
        spawnSection.set("x", (Object)loc.getX());
        spawnSection.set("y", (Object)loc.getY());
        spawnSection.set("z", (Object)loc.getZ());
        spawnSection.set("yaw", (Object)Float.valueOf(loc.getYaw()));
        spawnSection.set("pitch", (Object)Float.valueOf(loc.getPitch()));
        try {
            ConfigShorts.getWorldConfig().save();
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Problem storing spawn location of world " + loc.getWorld().getName());
            e.printStackTrace();
            return false;
        }
    }

    public boolean getAutoLoad(String world) {
        return ConfigShorts.getWorldConfig().getBoolean("Worlds." + world + ".autoLoad", false);
    }

    public Difficulty getDifficulty(String world) {
        try {
            return Difficulty.valueOf((String)ConfigShorts.getWorldConfig().getString("Worlds." + world + ".difficulty", "NORMAL"));
        }
        catch (IllegalArgumentException e) {
            return Difficulty.NORMAL;
        }
    }

    public boolean keepSpawnInMemory(String world) {
        return ConfigShorts.getWorldConfig().getBoolean("Worlds." + world + ".keepSpawnInMemory", false);
    }

    public boolean generateStructures(String world) {
        return ConfigShorts.getWorldConfig().getBoolean("Worlds." + world + ".generateStructures", false);
    }

    public String getWorldInformation(String world) {
        if (this.getAllWorlds().contains(world)) {
            String difficulty = this.getDifficulty(world).name();
            String generator = this.getGenerator(world);
            boolean autoLoad = this.getAutoLoad(world);
            String environment = this.getEnvironment(world).name();
            boolean keepSpawnInMemory = this.keepSpawnInMemory(world);
            boolean generateStructures = this.generateStructures(world);
            Location spawnloc = this.getSpawnLocation(world, false);
            double spawnlocX = spawnloc.getX();
            double spawnlocY = spawnloc.getY();
            double spawnlocZ = spawnloc.getZ();
            double spawnlocPitch = spawnloc.getPitch();
            double spawnlocYaw = spawnloc.getYaw();
            String worldInfo = ChatColor.AQUA + "----- " + world + " -----\n\n" + ChatColor.GOLD + "Difficulty: " + ChatColor.RESET + difficulty + "\n" + ChatColor.GOLD + "Generator: " + ChatColor.RESET + generator + "\n" + ChatColor.GOLD + "AutoLoad: " + ChatColor.RESET + autoLoad + "\n" + ChatColor.GOLD + "Environment: " + ChatColor.RESET + environment + "\n" + ChatColor.GOLD + "KeepSpawnInMemory: " + ChatColor.RESET + keepSpawnInMemory + "\n" + ChatColor.GOLD + "GenerateStructures: " + ChatColor.RESET + generateStructures + "\n\n" + ChatColor.AQUA + "----- Spawn -----\n" + ChatColor.GOLD + "X: " + ChatColor.RESET + spawnlocX + "\n" + ChatColor.GOLD + "Y: " + ChatColor.RESET + spawnlocY + "\n" + ChatColor.GOLD + "Z: " + ChatColor.RESET + spawnlocZ + "\n" + ChatColor.GOLD + "Pitch: " + ChatColor.RESET + spawnlocPitch + "\n" + ChatColor.GOLD + "Yaw: " + ChatColor.RESET + spawnlocYaw + "\n";
            return worldInfo;
        }
        return world;
    }
}

