/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock;

import com.github.Viduality.VSkyblock.Challenges.ChallengesCreator;
import com.github.Viduality.VSkyblock.Challenges.ChallengesManager;
import com.github.Viduality.VSkyblock.Commands.Admin.AdminCommands;
import com.github.Viduality.VSkyblock.Commands.Challenges;
import com.github.Viduality.VSkyblock.Commands.Island;
import com.github.Viduality.VSkyblock.DefaultFiles;
import com.github.Viduality.VSkyblock.Listener.BlockBreakListener;
import com.github.Viduality.VSkyblock.Listener.BlockProtector;
import com.github.Viduality.VSkyblock.Listener.ChallengesInventoryHandler;
import com.github.Viduality.VSkyblock.Listener.CobblestoneGenerator;
import com.github.Viduality.VSkyblock.Listener.CobblestoneGeneratorInventoryHandler;
import com.github.Viduality.VSkyblock.Listener.EntityProtector;
import com.github.Viduality.VSkyblock.Listener.InteractBlocker;
import com.github.Viduality.VSkyblock.Listener.IslandOptionsInventoryHandler;
import com.github.Viduality.VSkyblock.Listener.ItemDropBlocker;
import com.github.Viduality.VSkyblock.Listener.ItemPickupBlocker;
import com.github.Viduality.VSkyblock.Listener.NetherPortalListener;
import com.github.Viduality.VSkyblock.Listener.PhantomSpawn;
import com.github.Viduality.VSkyblock.Listener.PlayerDeathListener;
import com.github.Viduality.VSkyblock.Listener.PlayerJoinListener;
import com.github.Viduality.VSkyblock.Listener.PlayerLeaveListener;
import com.github.Viduality.VSkyblock.Listener.PortalAccessor;
import com.github.Viduality.VSkyblock.Listener.TeleporterInventoryHandler;
import com.github.Viduality.VSkyblock.SQLConnector;
import com.github.Viduality.VSkyblock.Utilitys.ChallengesConverter;
import com.github.Viduality.VSkyblock.Utilitys.ConfigChanger;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.Utilitys.DeleteOldIslands;
import com.github.Viduality.VSkyblock.Utilitys.Scoreboardmanager;
import com.github.Viduality.VSkyblock.Utilitys.TeleportHandler;
import com.github.Viduality.VSkyblock.Utilitys.WorldLoader;
import com.github.Viduality.VSkyblock.Utilitys.WorldManager;
import com.github.Viduality.VSkyblock.WorldGenerator.VoidGenerator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class VSkyblock
extends JavaPlugin
implements Listener {
    private static VSkyblock instance;
    private TeleportHandler teleportHandler;
    private SQLConnector sqlConnector;
    public Scoreboardmanager scoreboardmanager;
    private WorldManager worldManager;
    private ChallengesManager challengesManager;
    private ConfigChanger configChanger;

    public void onEnable() {
        instance = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        DefaultFiles.init();
        ConfigShorts.reloadAllConfigs();
        this.configChanger = new ConfigChanger(this);
        this.sqlConnector = new SQLConnector(this);
        this.worldManager = new WorldManager(this);
        this.challengesManager = new ChallengesManager(this);
        this.teleportHandler = new TeleportHandler(this);
        this.getCommand("Island").setExecutor((CommandExecutor)new Island(this));
        this.getCommand("Challenges").setExecutor((CommandExecutor)new Challenges(this));
        this.getCommand("VSkyblock").setExecutor((CommandExecutor)new AdminCommands(this));
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerLeaveListener(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerDeathListener(), (Plugin)this);
        pm.registerEvents((Listener)new BlockBreakListener(), (Plugin)this);
        pm.registerEvents((Listener)new NetherPortalListener(this), (Plugin)this);
        pm.registerEvents((Listener)new BlockProtector(), (Plugin)this);
        pm.registerEvents((Listener)new EntityProtector(this), (Plugin)this);
        pm.registerEvents((Listener)new InteractBlocker(this), (Plugin)this);
        pm.registerEvents((Listener)new ItemDropBlocker(), (Plugin)this);
        pm.registerEvents((Listener)new ItemPickupBlocker(), (Plugin)this);
        pm.registerEvents((Listener)new ChallengesInventoryHandler(this), (Plugin)this);
        pm.registerEvents((Listener)new PortalAccessor(this), (Plugin)this);
        pm.registerEvents((Listener)new TeleporterInventoryHandler(), (Plugin)this);
        pm.registerEvents((Listener)new IslandOptionsInventoryHandler(this), (Plugin)this);
        pm.registerEvents((Listener)new CobblestoneGenerator(this), (Plugin)this);
        pm.registerEvents((Listener)new CobblestoneGeneratorInventoryHandler(this), (Plugin)this);
        pm.registerEvents((Listener)new PhantomSpawn(), (Plugin)this);
        this.getServer().getScheduler().runTaskTimer((Plugin)this, (Runnable)new DeleteOldIslands(this), 10L, 72000L);
        this.sqlConnector.initTables();
        new WorldLoader(this).run();
        this.setGeneratorChances();
        this.scoreboardmanager = new Scoreboardmanager(this);
        ScoreboardManager sm = this.getServer().getScoreboardManager();
        Scoreboard scoreboard = sm.getMainScoreboard();
        if (!this.scoreboardmanager.doesobjectiveexist("deaths")) {
            Objective deathCount = scoreboard.registerNewObjective("deaths", "deathCount", "Deaths");
            deathCount.setDisplaySlot(DisplaySlot.PLAYER_LIST);
        }
        if (this.getOnlinePlayers().size() != 0) {
            this.getDb().getReader().refreshIslands(this.getOnlinePlayers());
            this.getDb().getReader().refreshDeathCounts(this.getOnlinePlayers());
        }
        this.updateNewTables();
        ChallengesCreator cc = new ChallengesCreator(this);
        if (cc.createAllChallenges() && !this.useNewTables()) {
            new ChallengesConverter(this).convertAllChallenges();
        }
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.sqlConnector.close();
        this.getServer().resetRecipes();
        this.getServer().getScoreboardManager().getMainScoreboard().getObjective("deaths").unregister();
    }

    public static VSkyblock getInstance() {
        return instance;
    }

    public ConfigChanger getConfigChanger() {
        return this.configChanger;
    }

    public SQLConnector getDb() {
        return this.sqlConnector;
    }

    public Scoreboardmanager getScoreboardManager() {
        return this.scoreboardmanager;
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    public ChallengesManager getChallengesManager() {
        return this.challengesManager;
    }

    public List<Player> getOnlinePlayers() {
        return new ArrayList<Player>(this.getServer().getOnlinePlayers());
    }

    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        return new VoidGenerator();
    }

    private void setGeneratorChances() {
        double coalLevel = 20.0;
        double coalChance = 3.0;
        double ironLevel = 35.0;
        double ironChance = 1.5;
        double redstoneLevel = 50.0;
        double redstoneChance = 1.5;
        double lapisLevel = 60.0;
        double lapisChance = 2.0;
        double goldLevel = 80.0;
        double goldChance = 1.0;
        double emeraldLevel = 100.0;
        double emeraldChance = 0.05;
        double diamondLevel = 100.0;
        double diamondChance = 0.2;
        double ancientDebrisLevel = 150.0;
        double ancientDebrisChance = 0.4;
        int cobblestoneLevelIntervall = 10;
        double cobblestoneChance = 20.0;
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.CoalLevel") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.CoalLevel"))) {
            coalLevel = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.CoalLevel");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.CoalChance") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.CoalChance"))) {
            coalChance = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.CoalChance");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.IronLevel") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.IronLevel"))) {
            ironLevel = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.IronLevel");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.IronChance") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.IronChance"))) {
            ironChance = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.IronChance");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.RedstoneLevel") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.RedstoneLevel"))) {
            redstoneLevel = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.RedstoneLevel");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.RedstoneChance") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.RedstoneChance"))) {
            redstoneChance = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.RedstoneChance");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.LapisLevel") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.LapisLevel"))) {
            lapisLevel = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.LapisLevel");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.LapisChance") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.LapisChance"))) {
            lapisChance = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.LapisChance");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.GoldLevel") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.GoldLevel"))) {
            goldLevel = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.GoldLevel");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.GoldChance") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.GoldChance"))) {
            goldChance = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.GoldChance");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.EmeraldLevel") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.EmeraldLevel"))) {
            emeraldLevel = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.EmeraldLevel");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.EmeraldChance") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.EmeraldChance"))) {
            emeraldChance = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.EmeraldChance");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.DiamondLevel") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.DiamondLevel"))) {
            diamondLevel = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.DiamondLevel");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.DiamondChance") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.DiamondChance"))) {
            diamondChance = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.DiamondChance");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.AncientDebrisLevel") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.AncientDebrisLevel"))) {
            ancientDebrisLevel = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.AncientDebrisLevel");
        }
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.AncientDebrisChance") != null && this.isDouble(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.AncientDebrisChance"))) {
            ancientDebrisChance = ConfigShorts.getDefConfig().getDouble("CobblestoneGenerator.AncientDebrisChance");
        }
        CobblestoneGenerator.generatorValues.put("CoalLevel", coalLevel);
        CobblestoneGenerator.generatorValues.put("CoalChance", coalChance);
        CobblestoneGenerator.generatorValues.put("IronLevel", ironLevel);
        CobblestoneGenerator.generatorValues.put("IronChance", ironChance);
        CobblestoneGenerator.generatorValues.put("RedstoneLevel", redstoneLevel);
        CobblestoneGenerator.generatorValues.put("RedstoneChance", redstoneChance);
        CobblestoneGenerator.generatorValues.put("LapisLevel", lapisLevel);
        CobblestoneGenerator.generatorValues.put("LapisChance", lapisChance);
        CobblestoneGenerator.generatorValues.put("GoldLevel", goldLevel);
        CobblestoneGenerator.generatorValues.put("GoldChance", goldChance);
        CobblestoneGenerator.generatorValues.put("EmeraldLevel", emeraldLevel);
        CobblestoneGenerator.generatorValues.put("EmeraldChance", emeraldChance);
        CobblestoneGenerator.generatorValues.put("DiamondLevel", diamondLevel);
        CobblestoneGenerator.generatorValues.put("DiamondChance", diamondChance);
        CobblestoneGenerator.generatorValues.put("AncientDebrisLevel", ancientDebrisLevel);
        CobblestoneGenerator.generatorValues.put("AncientDebrisChance", ancientDebrisChance);
        if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.Cobblestone.MultipleDrops") != null && ConfigShorts.getDefConfig().getString("CobblestoneGenerator.Cobblestone.MultipleDrops").equalsIgnoreCase("true")) {
            if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.Cobblestone.CobblestoneLevelIntervall") != null && this.isInt(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.Cobblestone.CobblestoneLevelIntervall"))) {
                cobblestoneLevelIntervall = ConfigShorts.getDefConfig().getInt("CobblestoneGenerator.Cobblestone.CobblestoneLevelIntervall");
            }
            if (ConfigShorts.getDefConfig().getString("CobblestoneGenerator.Cobblestone.CobblestoneChance") != null && this.isInt(ConfigShorts.getDefConfig().getString("CobblestoneGenerator.Cobblestone.CobblestoneChance"))) {
                cobblestoneChance = ConfigShorts.getDefConfig().getInt("CobblestoneGenerator.Cobblestone.CobblestoneChance");
            }
        }
        CobblestoneGenerator.generatorValues.put("CobblestoneLevelIntervall", Double.valueOf(cobblestoneLevelIntervall));
        CobblestoneGenerator.generatorValues.put("CobblestoneChance", cobblestoneChance);
    }

    private boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private boolean isInt(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private void updateNewTables() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try (Connection connection = this.getDb().getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM VSkyblock_Island");
                ResultSet resultSet = preparedStatement.executeQuery();
                ArrayList<Integer> islandids = new ArrayList<Integer>();
                ArrayList<String> islandnames = new ArrayList<String>();
                while (resultSet.next()) {
                    islandids.add(resultSet.getInt("islandid"));
                    islandnames.add(resultSet.getString("island"));
                }
                Statement prep = null;
                PreparedStatement insert = null;
                for (int i = 0; i < islandids.size(); ++i) {
                    insert = connection.prepareStatement("INSERT IGNORE INTO VSkyblock_IslandLocations(islandid) VALUES (?)");
                    insert.setInt(1, (Integer)islandids.get(i));
                    if (insert.executeUpdate() == 0) continue;
                    String currentis = (String)islandnames.get(i);
                    double x = ConfigShorts.getWorldConfig().getDouble("Worlds." + currentis + ".spawnLocation.x");
                    double y = ConfigShorts.getWorldConfig().getDouble("Worlds." + currentis + ".spawnLocation.y");
                    double z = ConfigShorts.getWorldConfig().getDouble("Worlds." + currentis + ".spawnLocation.z");
                    float yaw = (float)ConfigShorts.getWorldConfig().getDouble("Worlds." + currentis + ".spawnLocation.yaw");
                    float pitch = (float)ConfigShorts.getWorldConfig().getDouble("Worlds." + currentis + ".spawnLocation.pitch");
                    prep = connection.prepareStatement("UPDATE IGNORE VSkyblock_IslandLocations SET spawnX = ?, spawnY = ?, spawnZ = ?, spawnYaw = ?, spawnPitch = ? WHERE islandid = ?");
                    prep.setDouble(1, x);
                    prep.setDouble(2, y);
                    prep.setDouble(3, z);
                    prep.setDouble(4, yaw);
                    prep.setDouble(5, pitch);
                    prep.setInt(6, (Integer)islandids.get(i));
                    prep.executeUpdate();
                }
                if (prep != null) {
                    prep.close();
                    insert.close();
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
        });
    }

    private boolean useNewTables() {
        Connection con = this.getDb().getConnection();
        try {
            ResultSet r = con.getMetaData().getTables(null, null, "VSkyblock_Challenges_Easy", null);
            return !r.next();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
            return true;
        }
    }

    public boolean teleportToIsland(Player player, Location location, boolean visit, List<String> islandMembers) {
        return this.teleportHandler.teleportToIsland(player, location, visit, islandMembers);
    }

    public boolean teleportToIsland(Player player, Location location) {
        return this.teleportHandler.teleportToIsland(player, location, false, null);
    }
}

