/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.WorldGenerator;

import com.github.Viduality.VSkyblock.Commands.Island;
import com.github.Viduality.VSkyblock.Listener.CobblestoneGenerator;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.VSkyblock;
import java.util.UUID;
import org.bukkit.Difficulty;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class IslandCreator {
    private final VSkyblock plugin;
    private final UUID playerId;
    private String oldIsland = null;

    public IslandCreator(VSkyblock plugin, UUID playerId) {
        this.plugin = plugin;
        this.playerId = playerId;
    }

    public IslandCreator oldIsland(String oldIsland) {
        this.oldIsland = oldIsland;
        return this;
    }

    private boolean isInt(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public void createNewIsland() {
        String worldsizeString = ConfigShorts.getDefConfig().getString("WorldSize");
        String difficulty = ConfigShorts.getDefConfig().getString("Difficulty");
        this.plugin.getDb().getReader().getLatestIsland((worldName, a) -> {
            Player player = this.plugin.getServer().getPlayer(this.playerId);
            if (a) {
                if (!this.plugin.getWorldManager().createIsland(worldName)) {
                    ConfigShorts.messagefromString("FailedToCreateIsland", (CommandSender)player);
                    this.plugin.getLogger().severe("Failed to create new island for " + this.playerId + " with id " + worldName);
                    return;
                }
                World world = this.plugin.getServer().getWorld(worldName);
                if (world == null) {
                    ConfigShorts.messagefromString("FailedToCreateIsland", (CommandSender)player);
                    this.plugin.getLogger().severe("Could not create new island for " + this.playerId + " properly as we don't know the world?");
                    return;
                }
                world.getWorldBorder().setCenter(0.0, 0.0);
                if (worldsizeString != null) {
                    Integer worldsize;
                    if (this.isInt(worldsizeString) && (worldsize = Integer.valueOf(worldsizeString)) <= 2000) {
                        world.getWorldBorder().setSize((double)worldsize.intValue());
                    }
                } else {
                    world.getWorldBorder().setSize(500.0);
                }
                String finaldifficutly = difficulty;
                if (difficulty != null) {
                    if (difficulty.equalsIgnoreCase("EASY")) {
                        world.setDifficulty(Difficulty.EASY);
                    } else if (difficulty.equalsIgnoreCase("HARD")) {
                        world.setDifficulty(Difficulty.HARD);
                    } else if (difficulty.equalsIgnoreCase("PEACEFUL")) {
                        world.setDifficulty(Difficulty.PEACEFUL);
                    } else {
                        world.setDifficulty(Difficulty.NORMAL);
                        finaldifficutly = "NORMAL";
                    }
                } else {
                    world.setDifficulty(Difficulty.NORMAL);
                    finaldifficutly = "NORMAL";
                }
                world.setGameRule(GameRule.DO_INSOMNIA, (Object)false);
                Island.restartmap.asMap().remove(this.playerId);
                Island.playerislands.put(this.playerId, worldName);
                Island.islandhomes.put(worldName, world.getSpawnLocation());
                CobblestoneGenerator.islandGenLevel.put(worldName, 0);
                CobblestoneGenerator.islandlevels.put(worldName, 0);
                if (player != null) {
                    player.teleportAsync(world.getSpawnLocation()).thenAccept(b -> {
                        player.getInventory().clear();
                        player.getEnderChest().clear();
                        player.setExp(0.0f);
                        player.setTotalExperience(0);
                        player.removePotionEffect(PotionEffectType.BLINDNESS);
                        player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                    });
                }
                if (this.oldIsland != null) {
                    this.plugin.getWorldManager().unloadWorld(this.oldIsland);
                }
                this.plugin.getDb().getWriter().addIsland(worldName, this.playerId, finaldifficutly.toUpperCase());
                this.plugin.getDb().getWriter().updateDeathCount(this.playerId, 0);
                this.plugin.scoreboardmanager.updatePlayerScore(player.getName(), "deaths", 0);
            } else {
                ConfigShorts.messagefromString("FailedToCreateIsland", (CommandSender)this.plugin.getServer().getPlayer(this.playerId));
            }
        });
    }
}

