/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.shaded.minedown;

import com.github.Viduality.shaded.minedown.MineDownParser;
import com.github.Viduality.shaded.minedown.MineDownStringifier;
import com.github.Viduality.shaded.minedown.Replacer;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;

public class MineDown {
    private final String message;
    private final Replacer replacer = new Replacer();
    private final MineDownParser parser = new MineDownParser();
    private BaseComponent[] baseComponents = null;

    public MineDown(String message) {
        this.message = message;
    }

    public static BaseComponent[] parse(String message, String ... replacements) {
        return new MineDown(message).replace(replacements).toComponent();
    }

    public static String stringify(BaseComponent[] components) {
        return new MineDownStringifier().stringify(components);
    }

    public BaseComponent[] toComponent() {
        if (this.baseComponents() == null) {
            this.baseComponents = this.replacer().replaceIn(this.parser().parse(this.message()).create());
        }
        return this.baseComponents();
    }

    private void reset() {
        this.baseComponents = null;
    }

    public MineDown replace(String ... replacements) {
        this.reset();
        this.replacer().replace(replacements);
        return this;
    }

    public MineDown replace(Map<String, String> replacements) {
        this.reset();
        this.replacer().replace(replacements);
        return this;
    }

    public MineDown replace(String placeholder, BaseComponent ... replacement) {
        this.reset();
        this.replacer().replace(placeholder, replacement);
        return this;
    }

    public MineDown placeholderIndicator(String placeholderIndicator) {
        this.placeholderPrefix(placeholderIndicator);
        this.placeholderSuffix(placeholderIndicator);
        return this;
    }

    public MineDown placeholderPrefix(String placeholderPrefix) {
        this.reset();
        this.replacer().placeholderPrefix(placeholderPrefix);
        return this;
    }

    public String placeholderPrefix() {
        return this.replacer().placeholderPrefix();
    }

    public MineDown placeholderSuffix(String placeholderSuffix) {
        this.reset();
        this.replacer().placeholderSuffix(placeholderSuffix);
        return this;
    }

    public String placeholderSuffix() {
        return this.replacer().placeholderSuffix();
    }

    public MineDown ignorePlaceholderCase(boolean ignorePlaceholderCase) {
        this.reset();
        this.replacer().ignorePlaceholderCase(ignorePlaceholderCase);
        return this;
    }

    public boolean ignorePlaceholderCase() {
        return this.replacer().ignorePlaceholderCase();
    }

    @Deprecated
    public MineDown translateLegacyColors(boolean translateLegacyColors) {
        this.reset();
        this.parser().translateLegacyColors(translateLegacyColors);
        return this;
    }

    public MineDown urlDetection(boolean enabled) {
        this.reset();
        this.parser().urlDetection(enabled);
        return this;
    }

    public MineDown urlHoverText(String text) {
        this.reset();
        this.parser().urlHoverText(text);
        return this;
    }

    public MineDown enable(MineDownParser.Option option) {
        this.reset();
        this.parser().enable(option);
        return this;
    }

    public MineDown disable(MineDownParser.Option option) {
        this.reset();
        this.parser().disable(option);
        return this;
    }

    public MineDown filter(MineDownParser.Option option) {
        this.reset();
        this.parser().filter(option);
        return this;
    }

    public MineDown unfilter(MineDownParser.Option option) {
        this.reset();
        this.parser().unfilter(option);
        return this;
    }

    public MineDown colorChar(char colorChar) {
        this.reset();
        this.parser().colorChar(colorChar);
        return this;
    }

    public MineDown copy() {
        return new MineDown(this.message()).copy(this);
    }

    public MineDown copy(MineDown from) {
        this.replacer().copy(from.replacer());
        this.parser().copy(from.parser());
        return this;
    }

    public static String getFormatString(ChatColor format) {
        switch (format) {
            case BOLD: {
                return "**";
            }
            case ITALIC: {
                return "##";
            }
            case UNDERLINE: {
                return "__";
            }
            case STRIKETHROUGH: {
                return "~~";
            }
            case MAGIC: {
                return "??";
            }
        }
        return "";
    }

    public static ChatColor getFormatFromChar(char c) {
        switch (c) {
            case '~': {
                return ChatColor.STRIKETHROUGH;
            }
            case '_': {
                return ChatColor.UNDERLINE;
            }
            case '*': {
                return ChatColor.BOLD;
            }
            case '#': {
                return ChatColor.ITALIC;
            }
            case '?': {
                return ChatColor.MAGIC;
            }
        }
        return null;
    }

    public static String escape(String string) {
        return new MineDown(string).parser().escape(string);
    }

    public String message() {
        return this.message;
    }

    public Replacer replacer() {
        return this.replacer;
    }

    public MineDownParser parser() {
        return this.parser;
    }

    protected BaseComponent[] baseComponents() {
        return this.baseComponents;
    }
}

