/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.shaded.minedown;

import com.github.Viduality.shaded.minedown.MineDown;
import com.github.Viduality.shaded.minedown.Util;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;

public class MineDownParser {
    private char colorChar = (char)38;
    private Set<Option> enabledOptions = EnumSet.of(Option.LEGACY_COLORS, Option.SIMPLE_FORMATTING, Option.ADVANCED_FORMATTING);
    private Set<Option> filteredOptions = EnumSet.noneOf(Option.class);
    private boolean lenient = false;
    private boolean urlDetection = true;
    private String urlHoverText = "Click to open url";
    public static final Pattern URL_PATTERN = Pattern.compile("^(?:(https?)://)?([-\\w_\\.]{2,}\\.[a-z]{2,4})(/\\S*)?$");
    public static final String COLOR_PREFIX = "color=";
    public static final String FORMAT_PREFIX = "format=";
    public static final String HOVER_PREFIX = "hover=";
    private ComponentBuilder builder;
    private StringBuilder value;
    private ChatColor color;
    private Set<ChatColor> format;
    private ClickEvent clickEvent;
    private HoverEvent hoverEvent;

    public MineDownParser() {
        this.reset();
    }

    public ComponentBuilder parse(String message) throws IllegalArgumentException {
        Matcher urlMatcher = this.urlDetection() ? URL_PATTERN.matcher(message) : null;
        boolean escaped = false;
        for (int i = 0; i < message.length(); ++i) {
            boolean isFormatting;
            int j;
            int nextDefClose;
            int nextEventClose;
            char c = message.charAt(i);
            boolean isEscape = c == '\\' && i + 1 < message.length();
            boolean isColorCode = this.isEnabled(Option.LEGACY_COLORS) && i + 1 < message.length() && (c == '\u00a7' || c == this.colorChar());
            boolean isEvent = false;
            if (this.isEnabled(Option.ADVANCED_FORMATTING) && c == '[' && (nextEventClose = Util.indexOfNotEscaped(message, "](", i + 1)) != -1 && nextEventClose + 2 < message.length() && (nextDefClose = Util.indexOfNotEscaped(message, ")", i + 2)) != -1) {
                int depth = 1;
                isEvent = true;
                boolean innerEscaped = false;
                for (j = i + 1; j < nextEventClose; ++j) {
                    if (innerEscaped) {
                        innerEscaped = false;
                    } else if (message.charAt(j) == '\\') {
                        innerEscaped = true;
                    } else if (message.charAt(j) == '[') {
                        ++depth;
                    } else if (message.charAt(j) == ']') {
                        --depth;
                    }
                    if (depth != 0) continue;
                    isEvent = false;
                    break;
                }
            }
            boolean bl = isFormatting = this.isEnabled(Option.SIMPLE_FORMATTING) && (c == '_' || c == '*' || c == '~' || c == '?' || c == '#') && Util.isDouble(message, i) && message.indexOf(String.valueOf(c) + String.valueOf(c), i + 2) != -1;
            if (escaped) {
                escaped = false;
            } else {
                if (isEscape) {
                    escaped = true;
                    continue;
                }
                if (isColorCode) {
                    char code;
                    if ((code = message.charAt(++i)) >= 'A' && code <= 'Z') {
                        code = (char)(code + 32);
                    }
                    ChatColor encoded = null;
                    StringBuilder colorString = new StringBuilder();
                    for (j = i; j < message.length(); ++j) {
                        char c1 = message.charAt(j);
                        if (c1 == c) {
                            try {
                                encoded = ChatColor.valueOf((String)colorString.toString().toUpperCase());
                                i = j;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                            break;
                        }
                        if (!(c1 == '_' || c1 >= 'A' && c1 <= 'Z' || c1 >= 'a' && c1 <= 'z')) break;
                        colorString.append(c1);
                    }
                    if (encoded == null) {
                        encoded = ChatColor.getByChar((char)code);
                    }
                    if (encoded != null) {
                        if (this.isFiltered(Option.LEGACY_COLORS)) continue;
                        if (encoded == ChatColor.RESET) {
                            this.appendValue();
                            this.color = null;
                            Util.applyFormat(this.builder, this.format);
                            this.format = new HashSet<ChatColor>();
                            continue;
                        }
                        if (!Util.isFormat(encoded)) {
                            if (this.value.length() > 0) {
                                this.appendValue();
                            }
                            this.color = encoded;
                            this.format = new HashSet<ChatColor>();
                            continue;
                        }
                        if (this.value.length() > 0) {
                            this.appendValue();
                        }
                        this.format.add(encoded);
                        continue;
                    }
                    this.value.append(c).append(code);
                    continue;
                }
                if (isEvent) {
                    int index = Util.indexOfNotEscaped(message, "](", i + 1);
                    int endIndex = Util.indexOfNotEscaped(message, ")", index + 2);
                    this.appendValue();
                    if (!this.isFiltered(Option.ADVANCED_FORMATTING)) {
                        this.append(this.parseEvent(message.substring(i + 1, index), message.substring(index + 2, endIndex)));
                    } else {
                        this.append(this.copy(true).parse(message.substring(i + 1, index)));
                    }
                    i = endIndex;
                    continue;
                }
                if (isFormatting) {
                    int endIndex = message.indexOf(String.valueOf(c) + String.valueOf(c), i + 2);
                    HashSet<ChatColor> formats = new HashSet<ChatColor>(this.format);
                    if (!this.isFiltered(Option.SIMPLE_FORMATTING)) {
                        formats.add(MineDown.getFormatFromChar(c));
                    }
                    this.appendValue();
                    this.append(this.copy(true).format(formats).parse(message.substring(i + 2, endIndex)));
                    i = endIndex + 1;
                    continue;
                }
            }
            if (this.urlDetection() && urlMatcher != null) {
                int urlEnd = message.indexOf(32, i);
                if (urlEnd == -1) {
                    urlEnd = message.length();
                }
                if (urlMatcher.region(i, urlEnd).find()) {
                    this.appendValue();
                    this.value = new StringBuilder(message.substring(i, urlEnd));
                    this.appendValue();
                    i = urlEnd - 1;
                    continue;
                }
            }
            this.value.append(message.charAt(i));
        }
        if (escaped) {
            this.value.append('\\');
        }
        this.appendValue();
        if (this.builder == null) {
            this.builder = new ComponentBuilder("");
        }
        return this.builder;
    }

    private void append(ComponentBuilder builder) {
        this.append(builder.create());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void append(BaseComponent[] components) {
        if (this.builder == null) {
            if (components.length > 0) {
                this.builder = new ComponentBuilder(components[0]);
                for (int i = 1; i < components.length; ++i) {
                    this.builder.append(components[i]);
                }
                return;
            } else {
                this.builder = new ComponentBuilder("");
            }
            return;
        } else {
            try {
                this.builder.append(components);
                return;
            }
            catch (NoSuchMethodError e) {
                if (components.length <= 0) return;
                try {
                    Field fCurrent = this.builder.getClass().getDeclaredField("current");
                    fCurrent.setAccessible(true);
                    BaseComponent previous = (BaseComponent)fCurrent.get(this.builder);
                    Field fParts = this.builder.getClass().getDeclaredField("parts");
                    fParts.setAccessible(true);
                    List parts = (List)fParts.get(this.builder);
                    for (BaseComponent component : components) {
                        parts.add(previous);
                        fCurrent.set(this.builder, component.duplicate());
                    }
                    return;
                }
                catch (IllegalAccessException | NoSuchFieldException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void appendValue() {
        this.appendValue(ComponentBuilder.FormatRetention.NONE);
    }

    private void appendValue(ComponentBuilder.FormatRetention retention) {
        if (this.value.length() > 0) {
            if (this.builder == null) {
                this.builder = new ComponentBuilder(this.value.toString());
            } else {
                this.builder.append(this.value.toString(), retention);
            }
            this.builder.color(this.color);
            Util.applyFormat(this.builder, this.format);
            if (this.urlDetection() && URL_PATTERN.matcher(this.value).matches()) {
                String v = this.value.toString();
                if (!v.startsWith("http://") && !v.startsWith("https://")) {
                    v = "http://" + v;
                }
                this.builder.event(new ClickEvent(ClickEvent.Action.OPEN_URL, v));
                if (this.urlHoverText() != null && !this.urlHoverText().isEmpty()) {
                    this.builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new MineDown(this.urlHoverText()).replace("url", this.value.toString()).toComponent()));
                }
            }
            if (this.clickEvent != null) {
                this.builder.event(this.clickEvent);
            }
            if (this.hoverEvent != null) {
                this.builder.event(this.hoverEvent);
            }
            this.value = new StringBuilder();
        }
    }

    public ComponentBuilder parseEvent(String text, String definitions) {
        ArrayList<String> defParts = new ArrayList<String>();
        if (definitions.startsWith(" ")) {
            defParts.add("");
        }
        Collections.addAll(defParts, definitions.split(" "));
        if (definitions.endsWith(" ")) {
            defParts.add("");
        }
        ChatColor color = null;
        HashSet<ChatColor> formats = new HashSet<ChatColor>();
        ClickEvent clickEvent = null;
        HoverEvent hoverEvent = null;
        int formatEnd = -1;
        for (int i = 0; i < defParts.size(); ++i) {
            String definition = (String)defParts.get(i);
            ChatColor parsed = MineDownParser.parseColor(definition, "", true);
            if (parsed != null) {
                if (Util.isFormat(parsed)) {
                    formats.add(parsed);
                } else {
                    color = parsed;
                }
                formatEnd = i;
                continue;
            }
            if (definition.toLowerCase().startsWith(COLOR_PREFIX)) {
                color = MineDownParser.parseColor(definition, COLOR_PREFIX, this.lenient());
                if (!this.lenient() && Util.isFormat(color)) {
                    throw new IllegalArgumentException(color + " is a format and not a color!");
                }
                formatEnd = i;
                continue;
            }
            if (definition.toLowerCase().startsWith(FORMAT_PREFIX)) {
                for (String formatStr : definition.substring(FORMAT_PREFIX.length()).split(",")) {
                    ChatColor format = MineDownParser.parseColor(formatStr, "", this.lenient());
                    if (!this.lenient() && !Util.isFormat(format)) {
                        throw new IllegalArgumentException(formats + " is a color and not a format!");
                    }
                    formats.add(format);
                }
                formatEnd = i;
                continue;
            }
            if (i == formatEnd + 1 && URL_PATTERN.matcher(definition).matches()) {
                if (!definition.startsWith("http://") && !definition.startsWith("https://")) {
                    definition = "http://" + definition;
                }
                clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, definition);
                continue;
            }
            ClickEvent.Action clickAction = definition.startsWith("/") ? ClickEvent.Action.RUN_COMMAND : null;
            HoverEvent.Action hoverAction = null;
            if (definition.toLowerCase().startsWith(HOVER_PREFIX)) {
                hoverAction = HoverEvent.Action.SHOW_TEXT;
            }
            String[] parts = definition.split("=", 2);
            try {
                hoverAction = HoverEvent.Action.valueOf((String)parts[0].toUpperCase());
            }
            catch (IllegalArgumentException formatStr) {
                // empty catch block
            }
            try {
                clickAction = ClickEvent.Action.valueOf((String)parts[0].toUpperCase());
            }
            catch (IllegalArgumentException formatStr) {
                // empty catch block
            }
            boolean hasBracket = parts.length > 1 && parts[1].startsWith("{") && (clickAction != null || hoverAction != null);
            StringBuilder value = new StringBuilder();
            if (parts.length > 1 && clickAction != null || hoverAction != null) {
                if (hasBracket) {
                    value.append(parts[1].substring(1));
                } else {
                    value.append(parts[1]);
                }
            } else {
                value.append(definition);
            }
            ++i;
            while (i < defParts.size()) {
                if (!hasBracket && ((String)defParts.get(i)).indexOf(61) != -1) {
                    --i;
                    break;
                }
                value.append(" ");
                if (hasBracket && ((String)defParts.get(i)).endsWith("}")) {
                    value.append((CharSequence)defParts.get(i), 0, ((String)defParts.get(i)).length() - 1);
                    break;
                }
                value.append((String)defParts.get(i));
                ++i;
            }
            if (clickAction != null) {
                String v = value.toString();
                if (clickAction == ClickEvent.Action.OPEN_URL && !v.startsWith("http://") && !v.startsWith("https://")) {
                    v = "http://" + v;
                }
                clickEvent = new ClickEvent(clickAction, v);
            } else if (hoverAction == null) {
                hoverAction = HoverEvent.Action.SHOW_TEXT;
            }
            if (hoverAction == null) continue;
            hoverEvent = new HoverEvent(hoverAction, this.copy(false).urlDetection(false).parse(value.toString()).create());
        }
        if (clickEvent != null && hoverEvent == null) {
            hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(clickEvent.getAction().toString().toLowerCase().replace('_', ' ')).color(ChatColor.BLUE).append(" " + clickEvent.getValue()).color(ChatColor.WHITE).create());
        }
        return this.copy().urlDetection(false).color(color).format(formats).clickEvent(clickEvent).hoverEvent(hoverEvent).parse(text);
    }

    public static ChatColor parseColor(String colorString, String prefix, boolean lenient) {
        ChatColor color;
        block5: {
            color = null;
            if (prefix.length() + 1 == colorString.length()) {
                color = ChatColor.getByChar((char)colorString.charAt(prefix.length()));
                if (color == null && !lenient) {
                    throw new IllegalArgumentException(colorString.charAt(prefix.length()) + " is not a valid " + prefix + " char!");
                }
            } else {
                try {
                    color = ChatColor.valueOf((String)colorString.substring(prefix.length()).toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    if (lenient) break block5;
                    throw e;
                }
            }
        }
        return color;
    }

    public MineDownParser copy() {
        return this.copy(false);
    }

    public MineDownParser copy(boolean formatting) {
        return new MineDownParser().copy(this, formatting);
    }

    public MineDownParser copy(MineDownParser from) {
        return this.copy(from, false);
    }

    public MineDownParser copy(MineDownParser from, boolean formatting) {
        this.lenient(from.lenient());
        this.urlDetection(from.urlDetection());
        this.urlHoverText(from.urlHoverText());
        this.enabledOptions(from.enabledOptions());
        this.filteredOptions(from.filteredOptions());
        this.colorChar(from.colorChar());
        if (formatting) {
            this.format(from.format());
            this.color(from.color());
            this.clickEvent(from.clickEvent());
            this.hoverEvent(from.hoverEvent());
        }
        return this;
    }

    public MineDownParser reset() {
        this.builder = null;
        this.value = new StringBuilder();
        this.color = null;
        this.format = new HashSet<ChatColor>();
        this.clickEvent = null;
        this.hoverEvent = null;
        return this;
    }

    @Deprecated
    public boolean translateLegacyColors() {
        return this.isEnabled(Option.LEGACY_COLORS);
    }

    @Deprecated
    public MineDownParser translateLegacyColors(boolean enabled) {
        return enabled ? this.enable(Option.LEGACY_COLORS) : this.disable(Option.LEGACY_COLORS);
    }

    public boolean isEnabled(Option option) {
        return this.enabledOptions().contains((Object)option);
    }

    public MineDownParser enable(Option option) {
        this.enabledOptions().add(option);
        return this;
    }

    public MineDownParser disable(Option option) {
        this.enabledOptions().remove((Object)option);
        return this;
    }

    public boolean isFiltered(Option option) {
        return this.filteredOptions().contains((Object)option);
    }

    public MineDownParser filter(Option option) {
        this.filteredOptions().add(option);
        this.enabledOptions().add(option);
        return this;
    }

    public MineDownParser unfilter(Option option) {
        this.filteredOptions().remove((Object)option);
        return this;
    }

    public String escape(String string) {
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            boolean isFormatting;
            char c = string.charAt(i);
            boolean isEscape = c == '\\';
            boolean isColorCode = this.isEnabled(Option.LEGACY_COLORS) && i + 1 < string.length() && (c == '\u00a7' || c == this.colorChar());
            boolean isEvent = this.isEnabled(Option.ADVANCED_FORMATTING) && c == '[';
            boolean bl = isFormatting = this.isEnabled(Option.SIMPLE_FORMATTING) && (c == '_' || c == '*' || c == '~' || c == '?' || c == '#') && Util.isDouble(string, i);
            if (isEscape || isColorCode || isEvent || isFormatting) {
                value.append('\\');
            }
            value.append(c);
        }
        return value.toString();
    }

    public char colorChar() {
        return this.colorChar;
    }

    public Set<Option> enabledOptions() {
        return this.enabledOptions;
    }

    public Set<Option> filteredOptions() {
        return this.filteredOptions;
    }

    public boolean lenient() {
        return this.lenient;
    }

    public boolean urlDetection() {
        return this.urlDetection;
    }

    public String urlHoverText() {
        return this.urlHoverText;
    }

    public ComponentBuilder builder() {
        return this.builder;
    }

    public StringBuilder value() {
        return this.value;
    }

    public ChatColor color() {
        return this.color;
    }

    public Set<ChatColor> format() {
        return this.format;
    }

    public ClickEvent clickEvent() {
        return this.clickEvent;
    }

    public HoverEvent hoverEvent() {
        return this.hoverEvent;
    }

    public MineDownParser colorChar(char colorChar) {
        this.colorChar = colorChar;
        return this;
    }

    public MineDownParser enabledOptions(Set<Option> enabledOptions) {
        this.enabledOptions = enabledOptions;
        return this;
    }

    public MineDownParser filteredOptions(Set<Option> filteredOptions) {
        this.filteredOptions = filteredOptions;
        return this;
    }

    public MineDownParser lenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public MineDownParser urlDetection(boolean urlDetection) {
        this.urlDetection = urlDetection;
        return this;
    }

    public MineDownParser urlHoverText(String urlHoverText) {
        this.urlHoverText = urlHoverText;
        return this;
    }

    public MineDownParser builder(ComponentBuilder builder) {
        this.builder = builder;
        return this;
    }

    public MineDownParser value(StringBuilder value) {
        this.value = value;
        return this;
    }

    public MineDownParser color(ChatColor color) {
        this.color = color;
        return this;
    }

    public MineDownParser format(Set<ChatColor> format) {
        this.format = format;
        return this;
    }

    public MineDownParser clickEvent(ClickEvent clickEvent) {
        this.clickEvent = clickEvent;
        return this;
    }

    public MineDownParser hoverEvent(HoverEvent hoverEvent) {
        this.hoverEvent = hoverEvent;
        return this;
    }

    public static enum Option {
        SIMPLE_FORMATTING,
        ADVANCED_FORMATTING,
        LEGACY_COLORS;

    }
}

