/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.shaded.minedown;

import com.github.Viduality.shaded.minedown.MineDown;
import com.github.Viduality.shaded.minedown.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;

public class MineDownStringifier {
    private boolean useLegacyColors = true;
    private boolean useLegacyFormatting = false;
    private boolean preferSimpleEvents = true;
    private boolean formattingInEventDefinition = false;
    private boolean colorInEventDefinition = false;
    private char colorChar = (char)38;
    public static final String COLOR_PREFIX = "color=";
    public static final String FORMAT_PREFIX = "format=";
    public static final String HOVER_PREFIX = "hover=";
    private StringBuilder value = new StringBuilder();
    private ChatColor color = null;
    private ClickEvent clickEvent = null;
    private HoverEvent hoverEvent = null;
    private Set<ChatColor> formats = new LinkedHashSet<ChatColor>();

    public String stringify(BaseComponent[] components) {
        StringBuilder sb = new StringBuilder();
        for (BaseComponent component : components) {
            if (!component.hasFormatting()) {
                this.appendText(sb, component);
                continue;
            }
            if (component.getClickEvent() != null || component.getHoverEvent() != null) {
                sb.append('[');
                if (!this.formattingInEventDefinition()) {
                    this.appendFormat(sb, component);
                }
                if (!this.colorInEventDefinition()) {
                    this.appendColor(sb, component.getColor());
                }
            } else if (component.getColorRaw() != null) {
                this.appendFormat(sb, component);
                this.appendColor(sb, component.getColor());
            } else {
                this.appendFormat(sb, component);
            }
            this.appendText(sb, component);
            if (component.getExtra() != null && !component.getExtra().isEmpty()) {
                sb.append(this.copy().stringify(component.getExtra().toArray(new BaseComponent[0])));
            }
            if (component.getClickEvent() != this.clickEvent || component.getHoverEvent() != this.hoverEvent) {
                StringBuilder sbi;
                this.clickEvent = component.getClickEvent();
                this.hoverEvent = component.getHoverEvent();
                if (!this.formattingInEventDefinition()) {
                    this.appendFormatSuffix(sb, component);
                }
                sb.append("](");
                ArrayList<String> definitions = new ArrayList<String>();
                if (this.colorInEventDefinition()) {
                    sbi = new StringBuilder();
                    if (!this.preferSimpleEvents()) {
                        sbi.append(COLOR_PREFIX);
                    }
                    sbi.append(component.getColor().getName().toLowerCase());
                    definitions.add(sbi.toString());
                }
                if (this.formattingInEventDefinition()) {
                    sbi = new StringBuilder();
                    if (!this.preferSimpleEvents) {
                        sbi.append(FORMAT_PREFIX);
                    }
                    sbi.append(Util.getFormats(component, true).stream().map(c -> c.getName().toLowerCase()).collect(Collectors.joining(" ")));
                    definitions.add(sbi.toString());
                }
                if (component.getClickEvent() != null) {
                    if (this.preferSimpleEvents() && component.getClickEvent().getAction() == ClickEvent.Action.OPEN_URL) {
                        definitions.add(component.getClickEvent().getValue());
                    } else {
                        definitions.add(component.getClickEvent().getAction().toString().toLowerCase() + "=" + component.getClickEvent().getValue());
                    }
                }
                if (component.getHoverEvent() != null) {
                    sbi = new StringBuilder();
                    if (this.preferSimpleEvents()) {
                        if (component.getHoverEvent().getAction() == HoverEvent.Action.SHOW_TEXT && (component.getClickEvent() == null || component.getClickEvent().getAction() != ClickEvent.Action.OPEN_URL)) {
                            sbi.append(HOVER_PREFIX);
                        }
                    } else {
                        sbi.append(component.getHoverEvent().getAction().toString().toLowerCase()).append('=');
                    }
                    sbi.append(this.copy().stringify(component.getHoverEvent().getValue()));
                    definitions.add(sbi.toString());
                }
                sb.append(definitions.stream().collect(Collectors.joining(" ")));
                sb.append(')');
                continue;
            }
            this.appendFormatSuffix(sb, component);
        }
        return sb.toString();
    }

    private void appendText(StringBuilder sb, BaseComponent component) {
        if (!(component instanceof TextComponent)) {
            throw new UnsupportedOperationException("Cannot stringify " + component.getClass().getTypeName() + " yet! Only TextComponents are supported right now. Sorry. :(");
        }
        sb.append(((TextComponent)component).getText());
    }

    private void appendColor(StringBuilder sb, ChatColor color) {
        if (this.color != color) {
            this.color = color;
            if (this.useLegacyColors()) {
                sb.append(this.colorChar()).append(color.toString().substring(1));
            } else {
                sb.append(this.colorChar()).append(color.getName()).append(this.colorChar());
            }
        }
    }

    private void appendFormat(StringBuilder sb, BaseComponent component) {
        Set<ChatColor> formats = Util.getFormats(component, true);
        if (!formats.containsAll(this.formats)) {
            if (this.useLegacyFormatting()) {
                sb.append(this.colorChar()).append(ChatColor.RESET.toString().charAt(1));
            } else {
                ArrayDeque<ChatColor> formatDeque = new ArrayDeque<ChatColor>(this.formats);
                while (!formatDeque.isEmpty()) {
                    ChatColor format = (ChatColor)formatDeque.pollLast();
                    if (formats.contains(format)) continue;
                    sb.append(MineDown.getFormatString(format));
                }
            }
        } else {
            formats.removeAll(this.formats);
        }
        for (ChatColor format : formats) {
            if (this.useLegacyFormatting()) {
                sb.append(this.colorChar()).append(format.toString().charAt(1));
                continue;
            }
            sb.append(MineDown.getFormatString(format));
        }
        this.formats.clear();
        this.formats.addAll(formats);
    }

    private void appendFormatSuffix(StringBuilder sb, BaseComponent component) {
        if (!this.useLegacyFormatting()) {
            Set<ChatColor> formats = Util.getFormats(component, true);
            for (ChatColor format : formats) {
                sb.append(MineDown.getFormatString(format));
            }
            this.formats.removeAll(formats);
        }
    }

    public MineDownStringifier copy() {
        return new MineDownStringifier().copy(this);
    }

    public MineDownStringifier copy(MineDownStringifier from) {
        MineDownStringifier copy = new MineDownStringifier();
        this.useLegacyColors(from.useLegacyColors());
        this.useLegacyFormatting(from.useLegacyFormatting());
        this.preferSimpleEvents(from.preferSimpleEvents());
        this.formattingInEventDefinition(from.formattingInEventDefinition());
        this.colorInEventDefinition(from.colorInEventDefinition());
        this.colorChar(from.colorChar());
        return copy;
    }

    public boolean useLegacyColors() {
        return this.useLegacyColors;
    }

    public boolean useLegacyFormatting() {
        return this.useLegacyFormatting;
    }

    public boolean preferSimpleEvents() {
        return this.preferSimpleEvents;
    }

    public boolean formattingInEventDefinition() {
        return this.formattingInEventDefinition;
    }

    public boolean colorInEventDefinition() {
        return this.colorInEventDefinition;
    }

    public char colorChar() {
        return this.colorChar;
    }

    public StringBuilder value() {
        return this.value;
    }

    public ChatColor color() {
        return this.color;
    }

    public ClickEvent clickEvent() {
        return this.clickEvent;
    }

    public HoverEvent hoverEvent() {
        return this.hoverEvent;
    }

    public Set<ChatColor> formats() {
        return this.formats;
    }

    public MineDownStringifier useLegacyColors(boolean useLegacyColors) {
        this.useLegacyColors = useLegacyColors;
        return this;
    }

    public MineDownStringifier useLegacyFormatting(boolean useLegacyFormatting) {
        this.useLegacyFormatting = useLegacyFormatting;
        return this;
    }

    public MineDownStringifier preferSimpleEvents(boolean preferSimpleEvents) {
        this.preferSimpleEvents = preferSimpleEvents;
        return this;
    }

    public MineDownStringifier formattingInEventDefinition(boolean formattingInEventDefinition) {
        this.formattingInEventDefinition = formattingInEventDefinition;
        return this;
    }

    public MineDownStringifier colorInEventDefinition(boolean colorInEventDefinition) {
        this.colorInEventDefinition = colorInEventDefinition;
        return this;
    }

    public MineDownStringifier colorChar(char colorChar) {
        this.colorChar = colorChar;
        return this;
    }

    public MineDownStringifier value(StringBuilder value) {
        this.value = value;
        return this;
    }

    public MineDownStringifier color(ChatColor color) {
        this.color = color;
        return this;
    }

    public MineDownStringifier clickEvent(ClickEvent clickEvent) {
        this.clickEvent = clickEvent;
        return this;
    }

    public MineDownStringifier hoverEvent(HoverEvent hoverEvent) {
        this.hoverEvent = hoverEvent;
        return this;
    }

    public MineDownStringifier formats(Set<ChatColor> formats) {
        this.formats = formats;
        return this;
    }
}

