/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.shaded.minedown;

import com.github.Viduality.shaded.minedown.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.KeybindComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;

public class Replacer {
    private final Map<String, String> replacements = new LinkedHashMap<String, String>();
    private final Map<String, BaseComponent[]> componentReplacements = new LinkedHashMap<String, BaseComponent[]>();
    private String placeholderPrefix = "%";
    private String placeholderSuffix = "%";
    private boolean ignorePlaceholderCase = true;

    public static String replaceIn(String message, String ... replacements) {
        return new Replacer().replace(replacements).replaceIn(message);
    }

    public static BaseComponent[] replaceIn(BaseComponent[] message, String ... replacements) {
        return new Replacer().replace(replacements).replaceIn(message);
    }

    public static BaseComponent[] replaceIn(BaseComponent[] message, String placeholder, BaseComponent ... replacement) {
        return new Replacer().replace(placeholder, replacement).replaceIn(message);
    }

    public Replacer replace(String ... replacements) {
        Util.validate(replacements.length % 2 == 0, "The replacement length has to be even, mapping i % 2 == 0 to the placeholder and i % 2 = 1 to the placeholder's value");
        LinkedHashMap<String, String> replacementMap = new LinkedHashMap<String, String>();
        int i = 0;
        while (i + 1 < replacements.length) {
            replacementMap.put(replacements[i], replacements[i + 1]);
            i += 2;
        }
        return this.replace(replacementMap);
    }

    public Replacer replace(Map<String, ?> replacements) {
        if (replacements != null && !replacements.isEmpty()) {
            Object any = replacements.values().stream().findAny().orElse(null);
            if (any instanceof String) {
                this.replacements().putAll(replacements);
            } else if (any != null && any.getClass().isArray() && BaseComponent.class.isAssignableFrom(any.getClass().getComponentType())) {
                this.componentReplacements().putAll(replacements);
            } else {
                for (Map.Entry<String, ?> entry : replacements.entrySet()) {
                    this.replacements().put(entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
        }
        return this;
    }

    public Replacer replace(String placeholder, BaseComponent ... replacement) {
        this.componentReplacements().put(placeholder, replacement);
        return this;
    }

    public Replacer placeholderIndicator(String placeholderIndicator) {
        this.placeholderPrefix(placeholderIndicator);
        this.placeholderSuffix(placeholderIndicator);
        return this;
    }

    public BaseComponent[] replaceIn(BaseComponent ... components) {
        return this.replaceIn(Arrays.asList(components));
    }

    public BaseComponent[] replaceIn(List<BaseComponent> components) {
        ArrayList returnList = new ArrayList();
        for (int i = 0; i < components.size(); ++i) {
            BaseComponent component = components.get(i).duplicate();
            if (component instanceof KeybindComponent) {
                ((KeybindComponent)component).setKeybind(this.replaceIn(((KeybindComponent)component).getKeybind()));
            }
            if (component instanceof TextComponent) {
                ((TextComponent)component).setText(this.replaceIn(((TextComponent)component).getText()));
            }
            if (component instanceof TranslatableComponent) {
                ((TranslatableComponent)component).setTranslate(this.replaceIn(((TranslatableComponent)component).getTranslate()));
                ((TranslatableComponent)component).setWith(Arrays.asList(this.replaceIn(((TranslatableComponent)component).getWith())));
            }
            if (component.getClickEvent() != null) {
                component.setClickEvent(new ClickEvent(component.getClickEvent().getAction(), this.replaceIn(component.getClickEvent().getValue())));
            }
            if (component.getHoverEvent() != null) {
                component.setHoverEvent(new HoverEvent(component.getHoverEvent().getAction(), this.replaceIn(component.getHoverEvent().getValue())));
            }
            if (component.getExtra() != null) {
                component.setExtra(Arrays.asList(this.replaceIn(component.getExtra())));
            }
            ArrayList<BaseComponent> replacedComponents = new ArrayList<BaseComponent>();
            replacedComponents.add(component);
            for (Map.Entry<String, BaseComponent[]> replacement : this.componentReplacements().entrySet()) {
                ArrayList<Object> newReplacedComponents = new ArrayList<Object>();
                block2: for (BaseComponent replaceComponent : replacedComponents) {
                    if (replaceComponent instanceof TextComponent) {
                        String text;
                        TextComponent textComponent = (TextComponent)replaceComponent;
                        String placeHolder = this.placeholderPrefix() + (this.ignorePlaceholderCase() ? replacement.getKey().toLowerCase() : replacement.getKey()) + this.placeholderSuffix();
                        String string = text = this.ignorePlaceholderCase() ? textComponent.getText().toLowerCase() : textComponent.getText();
                        if (text.contains(placeHolder)) {
                            int index;
                            while ((index = text.indexOf(placeHolder)) > -1) {
                                TextComponent startComponent = new TextComponent(textComponent);
                                if (index > 0) {
                                    startComponent.setText(textComponent.getText().substring(0, index));
                                } else {
                                    startComponent.setText("");
                                }
                                startComponent.setExtra(Arrays.asList((Object[])replacement.getValue()));
                                newReplacedComponents.add(startComponent);
                                if (index + placeHolder.length() < textComponent.getText().length()) {
                                    textComponent.setText(textComponent.getText().substring(index + placeHolder.length()));
                                } else {
                                    textComponent.setText("");
                                }
                                text = this.ignorePlaceholderCase() ? textComponent.getText().toLowerCase() : textComponent.getText();
                                newReplacedComponents.add(textComponent);
                                if (!text.isEmpty()) continue;
                                continue block2;
                            }
                            continue;
                        }
                    }
                    newReplacedComponents.add(replaceComponent);
                }
                replacedComponents = newReplacedComponents;
            }
            returnList.addAll(replacedComponents);
        }
        return returnList.toArray(new BaseComponent[0]);
    }

    public String replaceIn(String string) {
        for (Map.Entry<String, String> replacement : this.replacements().entrySet()) {
            String replValue;
            String string2 = replValue = replacement.getValue() != null ? replacement.getValue() : "null";
            if (this.ignorePlaceholderCase()) {
                int startIndex;
                String placeholder = this.placeholderPrefix() + (this.ignorePlaceholderCase() ? replacement.getKey().toLowerCase() : replacement.getKey()) + this.placeholderSuffix();
                int nextStart = 0;
                while (nextStart < string.length() && (startIndex = string.toLowerCase().indexOf(placeholder, nextStart)) > -1) {
                    nextStart = startIndex + replValue.length();
                    string = string.substring(0, startIndex) + replValue + string.substring(startIndex + placeholder.length());
                }
                continue;
            }
            string = string.replace(this.placeholderPrefix() + replacement.getKey() + this.placeholderSuffix(), replValue);
        }
        return string;
    }

    public Replacer copy() {
        return new Replacer().copy(this);
    }

    public Replacer copy(Replacer from) {
        this.replacements().clear();
        this.replacements().putAll(from.replacements());
        this.componentReplacements().clear();
        this.componentReplacements().putAll(from.componentReplacements());
        this.placeholderPrefix(from.placeholderPrefix());
        this.placeholderSuffix(from.placeholderSuffix());
        return this;
    }

    public Map<String, String> replacements() {
        return this.replacements;
    }

    public Map<String, BaseComponent[]> componentReplacements() {
        return this.componentReplacements;
    }

    public String placeholderPrefix() {
        return this.placeholderPrefix;
    }

    public String placeholderSuffix() {
        return this.placeholderSuffix;
    }

    public boolean ignorePlaceholderCase() {
        return this.ignorePlaceholderCase;
    }

    public Replacer placeholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
        return this;
    }

    public Replacer placeholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
        return this;
    }

    public Replacer ignorePlaceholderCase(boolean ignorePlaceholderCase) {
        this.ignorePlaceholderCase = ignorePlaceholderCase;
        return this;
    }
}

