/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.shaded.minedown;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;

public class Util {
    public static void validate(boolean value, String message) throws IllegalArgumentException {
        if (!value) {
            throw new IllegalArgumentException(message);
        }
    }

    public static BaseComponent applyFormat(BaseComponent component, Collection<ChatColor> formats) {
        block8: for (ChatColor format : formats) {
            switch (format) {
                case BOLD: {
                    component.setBold(Boolean.valueOf(true));
                    continue block8;
                }
                case ITALIC: {
                    component.setItalic(Boolean.valueOf(true));
                    continue block8;
                }
                case UNDERLINE: {
                    component.setUnderlined(Boolean.valueOf(true));
                    continue block8;
                }
                case STRIKETHROUGH: {
                    component.setStrikethrough(Boolean.valueOf(true));
                    continue block8;
                }
                case MAGIC: {
                    component.setObfuscated(Boolean.valueOf(true));
                    continue block8;
                }
                case RESET: {
                    component.setBold(Boolean.valueOf(false));
                    component.setItalic(Boolean.valueOf(false));
                    component.setUnderlined(Boolean.valueOf(false));
                    component.setStrikethrough(Boolean.valueOf(false));
                    component.setObfuscated(Boolean.valueOf(false));
                    format = ChatColor.WHITE;
                }
            }
            component.setColor(format);
        }
        if (component.getExtra() != null) {
            for (BaseComponent extra : component.getExtra()) {
                Util.applyFormat(extra, formats);
            }
        }
        return component;
    }

    public static ComponentBuilder applyFormat(ComponentBuilder builder, Collection<ChatColor> formats) {
        block8: for (ChatColor format : formats) {
            switch (format) {
                case BOLD: {
                    builder.bold(true);
                    continue block8;
                }
                case ITALIC: {
                    builder.italic(true);
                    continue block8;
                }
                case UNDERLINE: {
                    builder.underlined(true);
                    continue block8;
                }
                case STRIKETHROUGH: {
                    builder.strikethrough(true);
                    continue block8;
                }
                case MAGIC: {
                    builder.obfuscated(true);
                    continue block8;
                }
                case RESET: {
                    builder.bold(false);
                    builder.italic(false);
                    builder.underlined(false);
                    builder.strikethrough(false);
                    builder.obfuscated(false);
                    format = null;
                }
            }
            builder.color(format);
        }
        return builder;
    }

    public static boolean isDouble(String string, int index) {
        return index + 1 < string.length() && string.charAt(index) == string.charAt(index + 1);
    }

    public static boolean isFormat(ChatColor format) {
        switch (format) {
            case BOLD: 
            case ITALIC: 
            case UNDERLINE: 
            case STRIKETHROUGH: 
            case MAGIC: {
                return true;
            }
        }
        return false;
    }

    public static Set<ChatColor> getFormats(BaseComponent component, boolean ignoreParent) {
        LinkedHashSet<ChatColor> formats = new LinkedHashSet<ChatColor>();
        if (!ignoreParent && component.isBold() || component.isBoldRaw() != null && component.isBoldRaw().booleanValue()) {
            formats.add(ChatColor.BOLD);
        }
        if (!ignoreParent && component.isItalic() || component.isItalicRaw() != null && component.isItalicRaw().booleanValue()) {
            formats.add(ChatColor.ITALIC);
        }
        if (!ignoreParent && component.isUnderlined() || component.isUnderlinedRaw() != null && component.isUnderlinedRaw().booleanValue()) {
            formats.add(ChatColor.UNDERLINE);
        }
        if (!ignoreParent && component.isStrikethrough() || component.isStrikethroughRaw() != null && component.isStrikethroughRaw().booleanValue()) {
            formats.add(ChatColor.STRIKETHROUGH);
        }
        if (!ignoreParent && component.isObfuscated() || component.isObfuscatedRaw() != null && component.isObfuscatedRaw().booleanValue()) {
            formats.add(ChatColor.MAGIC);
        }
        return formats;
    }

    public static int indexOfNotEscaped(String string, String chars) {
        return Util.indexOfNotEscaped(string, chars, 0);
    }

    public static int indexOfNotEscaped(String string, String chars, int fromIndex) {
        for (int i = fromIndex; i < string.length(); ++i) {
            int index = string.indexOf(chars, i);
            if (index == -1) {
                return -1;
            }
            if (Util.isEscaped(string, index)) continue;
            return index;
        }
        return -1;
    }

    public static boolean isEscaped(String string, int index) {
        int e;
        if (index - 1 > string.length()) {
            return false;
        }
        for (e = 0; index > e && string.charAt(index - e - 1) == '\\'; ++e) {
        }
        return e % 2 != 0;
    }
}

