/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.util.Native;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;

public class ZstdDictDecompress
implements Closeable {
    private long nativePtr = 0L;

    public ZstdDictDecompress(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ZstdDictDecompress(byte[] byArray, int n, int n2) {
        byte[] byArray2 = 0 == n && n2 == byArray.length ? byArray : Arrays.copyOfRange(byArray, n, n + n2);
        if (byArray2.length <= 0) {
            throw new IllegalArgumentException("Dictionary buffer is to short");
        }
        this.init(byArray2);
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createCDict failed");
        }
    }

    private native void init(byte[] var1);

    private native void free();

    @Override
    public void close() throws IOException {
        this.free();
        this.nativePtr = 0L;
    }

    static {
        Native.load();
    }
}

