/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.events4j.core;

import com.github.philippheuer.events4j.api.IEventManager;
import com.github.philippheuer.events4j.api.domain.IDisposable;
import com.github.philippheuer.events4j.api.domain.IEvent;
import com.github.philippheuer.events4j.api.service.IEventHandler;
import com.github.philippheuer.events4j.api.service.IServiceMediator;
import com.github.philippheuer.events4j.core.services.ServiceMediator;
import com.github.philippheuer.events4j.reactor.ReactorEventHandler;
import com.github.philippheuer.events4j.reactor.util.ReactorDisposableWrapper;
import com.github.philippheuer.events4j.simple.SimpleEventHandler;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;

public class EventManager
implements IEventManager {
    private static final Logger log = LoggerFactory.getLogger(EventManager.class);
    private final MeterRegistry metricsRegistry = Metrics.globalRegistry;
    private final IServiceMediator serviceMediator;
    private List<IEventHandler> eventHandlers = new ArrayList<IEventHandler>();
    private boolean annotationEventManagerState = false;
    private boolean isStopped = false;
    private Class defaultEventHandler;

    public EventManager() {
        this.serviceMediator = new ServiceMediator(this);
    }

    public void registerEventHandler(IEventHandler eventHandler) {
        if (!this.eventHandlers.contains(eventHandler)) {
            this.eventHandlers.add(eventHandler);
        }
    }

    public void autoDiscovery() {
        try {
            Class.forName("com.github.philippheuer.events4j.simple.SimpleEventHandler");
            log.info("Auto Discovery: SimpleEventHandler registered!");
            SimpleEventHandler simpleEventHandler = new SimpleEventHandler();
            this.registerEventHandler((IEventHandler)simpleEventHandler);
            if (this.defaultEventHandler == null) {
                this.defaultEventHandler = SimpleEventHandler.class;
            }
        }
        catch (ClassNotFoundException ex) {
            log.debug("Auto Discovery: SimpleEventHandler not available!");
        }
        try {
            Class.forName("com.github.philippheuer.events4j.reactor.ReactorEventHandler");
            log.info("Auto Discovery: ReactorEventHandler registered!");
            ReactorEventHandler reactorEventHandler = new ReactorEventHandler();
            this.registerEventHandler((IEventHandler)reactorEventHandler);
            if (this.defaultEventHandler == null) {
                this.defaultEventHandler = ReactorEventHandler.class;
            }
        }
        catch (ClassNotFoundException ex) {
            log.debug("Auto Discovery: ReactorEventHandler not available!");
        }
    }

    public void publish(Object event) {
        if (this.isStopped) {
            log.warn("Tried to dispatch a event to a closed eventManager!");
            return;
        }
        this.metricsRegistry.counter("events4j.published", new String[]{"name", event.getClass().getSimpleName()}).increment();
        if (event instanceof IEvent) {
            IEvent iEvent = (IEvent)event;
            if (iEvent.getServiceMediator() == null) {
                iEvent.setServiceMediator(this.getServiceMediator());
            }
            if (log.isDebugEnabled()) {
                log.debug("Dispatching event of type {} with id {}.", (Object)event.getClass().getSimpleName(), (Object)iEvent.getEventId());
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Dispatching event of type {}.", (Object)event.getClass().getSimpleName());
        }
        this.eventHandlers.forEach(eventHandler -> eventHandler.publish(event));
    }

    public boolean hasEventHandler(Class eventHandlerClass) {
        Optional<IEventHandler> eventHandler = this.getEventHandlers().stream().filter(h -> h.getClass().getName().equalsIgnoreCase(eventHandlerClass.getName())).findFirst();
        return eventHandler.isPresent();
    }

    public <E> E getEventHandler(Class<E> eventHandlerClass) {
        Optional<Object> eventHandler = this.getEventHandlers().stream().filter(h -> h.getClass().getName().equalsIgnoreCase(eventHandlerClass.getName())).map(h -> h).findFirst();
        if (eventHandler.isPresent()) {
            return (E)eventHandler.get();
        }
        throw new RuntimeException("No eventHandler of type " + eventHandlerClass.getName() + " is registered!");
    }

    public <E> IDisposable onEvent(Class<E> eventClass, Consumer<E> consumer) {
        if (this.defaultEventHandler == SimpleEventHandler.class) {
            return this.getEventHandler(SimpleEventHandler.class).onEvent(eventClass, consumer);
        }
        if (this.defaultEventHandler == ReactorEventHandler.class) {
            Disposable disposable = this.getEventHandler(ReactorEventHandler.class).onEvent(eventClass, consumer);
            return new ReactorDisposableWrapper(disposable);
        }
        throw new RuntimeException("EventHandler " + this.defaultEventHandler.getCanonicalName() + " has to be registered with EventManager.registerEventHandler or support EventManager.autoDiscovery!");
    }

    public void close() {
        this.isStopped = true;
        this.eventHandlers.forEach(eventHandler -> {
            try {
                eventHandler.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    public MeterRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public IServiceMediator getServiceMediator() {
        return this.serviceMediator;
    }

    public List<IEventHandler> getEventHandlers() {
        return this.eventHandlers;
    }

    public boolean isAnnotationEventManagerState() {
        return this.annotationEventManagerState;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public Class getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    public void setDefaultEventHandler(Class defaultEventHandler) {
        this.defaultEventHandler = defaultEventHandler;
    }
}

