/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.events4j.core.domain;

import com.github.philippheuer.events4j.api.domain.IEvent;
import com.github.philippheuer.events4j.api.service.IServiceMediator;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.UUID;

public abstract class Event
implements IEvent {
    private String eventId = UUID.randomUUID().toString();
    private Instant firedAtInstant = Instant.now();
    private IServiceMediator serviceMediator;

    public Calendar getFiredAt() {
        return GregorianCalendar.from(ZonedDateTime.ofInstant(this.firedAtInstant, ZoneId.systemDefault()));
    }

    public void setFiredAt(Calendar calendar) {
        this.setFiredAtInstant(calendar.toInstant());
    }

    public String getEventId() {
        return this.eventId;
    }

    public Instant getFiredAtInstant() {
        return this.firedAtInstant;
    }

    public IServiceMediator getServiceMediator() {
        return this.serviceMediator;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setFiredAtInstant(Instant firedAtInstant) {
        this.firedAtInstant = firedAtInstant;
    }

    public void setServiceMediator(IServiceMediator serviceMediator) {
        this.serviceMediator = serviceMediator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$eventId = this.getEventId();
        String other$eventId = other.getEventId();
        if (this$eventId == null ? other$eventId != null : !this$eventId.equals(other$eventId)) {
            return false;
        }
        Instant this$firedAtInstant = this.getFiredAtInstant();
        Instant other$firedAtInstant = other.getFiredAtInstant();
        if (this$firedAtInstant == null ? other$firedAtInstant != null : !((Object)this$firedAtInstant).equals(other$firedAtInstant)) {
            return false;
        }
        IServiceMediator this$serviceMediator = this.getServiceMediator();
        IServiceMediator other$serviceMediator = other.getServiceMediator();
        return !(this$serviceMediator == null ? other$serviceMediator != null : !this$serviceMediator.equals(other$serviceMediator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $eventId = this.getEventId();
        result = result * 59 + ($eventId == null ? 43 : $eventId.hashCode());
        Instant $firedAtInstant = this.getFiredAtInstant();
        result = result * 59 + ($firedAtInstant == null ? 43 : ((Object)$firedAtInstant).hashCode());
        IServiceMediator $serviceMediator = this.getServiceMediator();
        result = result * 59 + ($serviceMediator == null ? 43 : $serviceMediator.hashCode());
        return result;
    }

    public String toString() {
        return "Event(eventId=" + this.getEventId() + ", firedAtInstant=" + this.getFiredAtInstant() + ", serviceMediator=" + this.getServiceMediator() + ")";
    }
}

