/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.auth;

import com.github.philippheuer.credentialmanager.CredentialManager;
import com.github.philippheuer.credentialmanager.domain.IdentityProvider;
import com.github.twitch4j.auth.providers.TwitchIdentityProvider;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchAuth {
    private static final Logger log = LoggerFactory.getLogger(TwitchAuth.class);
    private final CredentialManager credentialManager;

    public TwitchAuth(CredentialManager credentialManager, String clientId, String clientSecret, String redirectUrl) {
        this.credentialManager = credentialManager;
        TwitchAuth.registerIdentityProvider(credentialManager, clientId, clientSecret, redirectUrl);
    }

    public static void registerIdentityProvider(CredentialManager credentialManager, String clientId, String clientSecret, String redirectUrl) {
        Optional ip = credentialManager.getOAuth2IdentityProviderByName("twitch");
        if (!ip.isPresent()) {
            TwitchIdentityProvider identityProvider = new TwitchIdentityProvider(clientId, clientSecret, redirectUrl);
            credentialManager.registerIdentityProvider((IdentityProvider)identityProvider);
        } else {
            log.warn("TwitchIdentityProvider was already registered, ignoring call to TwitchAuth.registerIdentityProvider!");
        }
    }

    public CredentialManager getCredentialManager() {
        return this.credentialManager;
    }
}

