/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.auth.providers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.credentialmanager.identityprovider.OAuth2IdentityProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchIdentityProvider
extends OAuth2IdentityProvider {
    private static final Logger log = LoggerFactory.getLogger(TwitchIdentityProvider.class);

    public TwitchIdentityProvider(String clientId, String clientSecret, String redirectUrl) {
        super("twitch", "oauth2", clientId, clientSecret, "https://id.twitch.tv/oauth2/authorize", "https://id.twitch.tv/oauth2/token", redirectUrl);
        this.tokenEndpointPostType = "QUERY";
        this.scopeSeperator = "+";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<OAuth2Credential> getAdditionalCredentialInformation(OAuth2Credential credential) {
        String responseBody;
        Response response;
        OkHttpClient client;
        block14: {
            client = new OkHttpClient();
            Request request = new Request.Builder().url("https://id.twitch.tv/oauth2/validate").header("Authorization", "OAuth " + credential.getAccessToken()).build();
            response = client.newCall(request).execute();
            responseBody = response.body().string();
            if (!response.isSuccessful()) break block14;
            ObjectMapper objectMapper = new ObjectMapper();
            HashMap tokenInfo = (HashMap)objectMapper.readValue(responseBody, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            String userId = (String)tokenInfo.get("user_id");
            String userName = (String)tokenInfo.get("login");
            List scopes = (List)tokenInfo.get("scopes");
            int expiresIn = (Integer)tokenInfo.get("expires_in");
            OAuth2Credential newCredential = new OAuth2Credential(credential.getIdentityProvider(), credential.getAccessToken(), credential.getRefreshToken(), userId, userName, Integer.valueOf(expiresIn), scopes);
            newCredential.getContext().put("client_id", (String)tokenInfo.get("client_id"));
            Optional<OAuth2Credential> optional = Optional.ofNullable(newCredential);
            client.dispatcher().executorService().shutdown();
            client.connectionPool().evictAll();
            if (client.cache() != null && !client.cache().isClosed()) {
                try {
                    client.cache().close();
                }
                catch (Exception ex) {
                    log.warn("Failed to close OkHttp Client Cache ... [{}]", (Object)ex.getMessage());
                }
            }
            return optional;
        }
        try {
            try {
                throw new RuntimeException("Request Failed! Code: " + response.code() + " - " + responseBody);
            }
            catch (Exception request) {
                client.dispatcher().executorService().shutdown();
                client.connectionPool().evictAll();
                if (client.cache() != null && !client.cache().isClosed()) {
                    try {
                        client.cache().close();
                    }
                    catch (Exception ex) {
                        log.warn("Failed to close OkHttp Client Cache ... [{}]", (Object)ex.getMessage());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            client.dispatcher().executorService().shutdown();
            client.connectionPool().evictAll();
            if (client.cache() != null && !client.cache().isClosed()) {
                try {
                    client.cache().close();
                }
                catch (Exception ex) {
                    log.warn("Failed to close OkHttp Client Cache ... [{}]", (Object)ex.getMessage());
                }
            }
            throw throwable;
        }
        return Optional.empty();
    }
}

