/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe;

import com.boydti.fawe.FaweVersion;
import com.boydti.fawe.IFawe;
import com.boydti.fawe.beta.implementation.queue.QueueHandler;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.brush.visualization.VisualQueue;
import com.boydti.fawe.util.CachedTextureUtil;
import com.boydti.fawe.util.CleanTextureUtil;
import com.boydti.fawe.util.FaweTimer;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MemUtil;
import com.boydti.fawe.util.RandomTextureUtil;
import com.boydti.fawe.util.TaskManager;
import com.boydti.fawe.util.TextureUtil;
import com.boydti.fawe.util.WEManager;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.NotificationEmitter;
import net.jpountz.util.Native;

public class Fawe {
    private static final Logger log = LoggerFactory.getLogger(Fawe.class);
    private static Fawe instance;
    private final FaweTimer timer;
    private FaweVersion version;
    private VisualQueue visualQueue;
    private TextureUtil textures;
    private QueueHandler queueHandler;
    private final IFawe implementation;
    private Thread thread;

    public static <T extends IFawe> T imp() {
        return (T)(instance != null ? Fawe.instance.implementation : null);
    }

    public static Fawe get() {
        return instance;
    }

    public static void set(IFawe implementation) throws InstanceAlreadyExistsException, IllegalArgumentException {
        if (instance != null) {
            throw new InstanceAlreadyExistsException("FAWE has already been initialized with: " + Fawe.instance.implementation);
        }
        if (implementation == null) {
            throw new IllegalArgumentException("Implementation may not be null.");
        }
        instance = new Fawe(implementation);
    }

    private Fawe(IFawe implementation) {
        instance = this;
        this.implementation = implementation;
        this.thread = Thread.currentThread();
        this.setupConfigs();
        TaskManager.IMP = this.implementation.getTaskManager();
        TaskManager.IMP.async(() -> {
            MainUtil.deleteOlder(MainUtil.getFile(this.implementation.getDirectory(), Settings.IMP.PATHS.HISTORY), TimeUnit.DAYS.toMillis(Settings.IMP.HISTORY.DELETE_AFTER_DAYS), false);
            MainUtil.deleteOlder(MainUtil.getFile(this.implementation.getDirectory(), Settings.IMP.PATHS.CLIPBOARD), TimeUnit.DAYS.toMillis(Settings.IMP.CLIPBOARD.DELETE_AFTER_DAYS), false);
        });
        this.setupMemoryListener();
        this.timer = new FaweTimer();
        TaskManager.IMP.later(() -> {
            try {
                this.visualQueue = new VisualQueue(3);
                WEManager.IMP.managers.addAll(this.implementation.getMaskManagers());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, 0);
        TaskManager.IMP.repeat(this.timer, 1);
    }

    public void onDisable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueHandler getQueueHandler() {
        if (this.queueHandler == null) {
            Fawe fawe = this;
            synchronized (fawe) {
                if (this.queueHandler == null) {
                    this.queueHandler = this.implementation.getQueueHandler();
                }
            }
        }
        return this.queueHandler;
    }

    public TextureUtil getCachedTextureUtil(boolean randomize, int min, int max) {
        TextureUtil tu = this.getTextureUtil();
        try {
            tu = min == 0 && max == 100 ? tu : new CleanTextureUtil(tu, min, max);
            tu = randomize ? new RandomTextureUtil(tu) : new CachedTextureUtil(tu);
        }
        catch (FileNotFoundException neverHappens) {
            neverHappens.printStackTrace();
        }
        return tu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureUtil getTextureUtil() {
        TextureUtil tmp = this.textures;
        if (tmp == null) {
            Fawe fawe = this;
            synchronized (fawe) {
                tmp = this.textures;
                if (tmp == null) {
                    try {
                        this.textures = tmp = new TextureUtil();
                        tmp.loadModTextures();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return tmp;
    }

    public FaweTimer getTimer() {
        return this.timer;
    }

    public VisualQueue getVisualQueue() {
        return this.visualQueue;
    }

    @Nullable
    public FaweVersion getVersion() {
        return this.version;
    }

    public double getTPS() {
        return this.timer.getTPS();
    }

    public void setupConfigs() {
        MainUtil.copyFile(MainUtil.getJarFile(), "lang/strings.json", null);
        File file = new File(this.implementation.getDirectory(), "config.yml");
        Settings.IMP.PLATFORM = this.implementation.getPlatform().replace("\"", "");
        try (InputStream stream2 = this.getClass().getResourceAsStream("/fawe.properties");
             BufferedReader br = new BufferedReader(new InputStreamReader(stream2));){
            String versionString = br.readLine();
            String commitString = br.readLine();
            String dateString = br.readLine();
            br.close();
            this.version = FaweVersion.tryParse(versionString, commitString, dateString);
            Settings.IMP.DATE = new Date(100 + this.version.year, this.version.month, this.version.day).toString();
            Settings.IMP.BUILD = "https://ci.athion.net/job/FastAsyncWorldEdit-1.16/" + this.version.build;
            Settings.IMP.COMMIT = "https://github.com/IntellectualSites/FastAsyncWorldEdit/commit/" + Integer.toHexString(this.version.hash);
        }
        catch (Throwable stream2) {
            // empty catch block
        }
        try {
            Settings.IMP.reload(file);
        }
        catch (Throwable e) {
            log.error("Failed to load config.", e);
        }
    }

    public WorldEdit getWorldEdit() {
        return WorldEdit.getInstance();
    }

    public static void setupInjector() {
        boolean x86JVM;
        boolean x86OS;
        if (!Settings.IMP.EXPERIMENTAL.DISABLE_NATIVES) {
            block6: {
                try {
                    com.github.luben.zstd.util.Native.load();
                }
                catch (Throwable e) {
                    if (Settings.IMP.CLIPBOARD.COMPRESSION_LEVEL <= 6 && Settings.IMP.HISTORY.COMPRESSION_LEVEL <= 6) break block6;
                    Settings.IMP.CLIPBOARD.COMPRESSION_LEVEL = Math.min(6, Settings.IMP.CLIPBOARD.COMPRESSION_LEVEL);
                    Settings.IMP.HISTORY.COMPRESSION_LEVEL = Math.min(6, Settings.IMP.HISTORY.COMPRESSION_LEVEL);
                    log.error("ZSTD Compression Binding Not Found.\nFAWE will still work but compression won't work as well.\n", e);
                }
            }
            try {
                Native.load();
            }
            catch (Throwable e) {
                log.error("LZ4 Compression Binding Not Found.\nFAWE will still work but compression will be slower.\n", e);
            }
        }
        if ((x86OS = System.getProperty("sun.arch.data.model").contains("32")) != (x86JVM = System.getProperty("os.arch").contains("32"))) {
            log.info("You are running 32-bit Java on a 64-bit machine. Please upgrade to 64-bit Java.");
        }
    }

    private void setupMemoryListener() {
        if (Settings.IMP.MAX_MEMORY_PERCENT < 1 || Settings.IMP.MAX_MEMORY_PERCENT > 99) {
            return;
        }
        try {
            MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
            NotificationEmitter ne = (NotificationEmitter)((Object)memBean);
            ne.addNotificationListener((notification, handback) -> {
                long heapMaxSize;
                long heapSize = Runtime.getRuntime().totalMemory();
                if (heapSize < (heapMaxSize = Runtime.getRuntime().maxMemory())) {
                    return;
                }
                MemUtil.memoryLimitedTask();
            }, null, null);
            List<MemoryPoolMXBean> memPools = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean mp : memPools) {
                MemoryUsage mu;
                long max;
                if (!mp.isUsageThresholdSupported() || (max = (mu = mp.getUsage()).getMax()) < 0L) continue;
                long alert = max * (long)Settings.IMP.MAX_MEMORY_PERCENT / 100L;
                mp.setUsageThreshold(alert);
            }
        }
        catch (Throwable ignored) {
            log.error("FAWE encountered an error trying to listen to JVM memory.\nPlease change your Java security settings or disable this message bychanging 'max-memory-percent' in the config files to '-1'.");
        }
    }

    public Thread getMainThread() {
        return this.thread;
    }

    public static boolean isMainThread() {
        return instance == null || Fawe.instance.thread == Thread.currentThread();
    }

    public Thread setMainThread() {
        this.thread = Thread.currentThread();
        return this.thread;
    }
}

