/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.beta.IQueueChunk;
import com.boydti.fawe.beta.IQueueExtent;
import com.boydti.fawe.beta.implementation.lighting.NMSRelighter;
import com.boydti.fawe.beta.implementation.queue.ParallelQueueExtent;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.RelightMode;
import com.boydti.fawe.object.changeset.DiskStorageHistory;
import com.boydti.fawe.object.changeset.SimpleChangeSetSummary;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MemUtil;
import com.boydti.fawe.util.TaskManager;
import com.boydti.fawe.util.WEManager;
import com.boydti.fawe.wrappers.WorldWrapper;
import com.google.common.collect.Sets;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

public class FaweAPI {
    @Deprecated
    public static EditSessionBuilder getEditSessionBuilder(World world) {
        return new EditSessionBuilder(world);
    }

    public static TaskManager getTaskManager() {
        return TaskManager.IMP;
    }

    public static IQueueExtent<IQueueChunk> createQueue(World world, boolean autoQueue) {
        IQueueExtent<IQueueChunk> queue = Fawe.get().getQueueHandler().getQueue(world);
        if (!autoQueue) {
            queue.disableQueue();
        }
        return queue;
    }

    public static World getWorld(String worldName) {
        Platform platform = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING);
        List<? extends World> worlds = platform.getWorlds();
        for (World world : worlds) {
            if (!world.getName().equals(worldName)) continue;
            return WorldWrapper.wrap(world);
        }
        return null;
    }

    public static URL upload(Clipboard clipboard, ClipboardFormat format) {
        return format.upload(clipboard);
    }

    public static Clipboard load(File file) throws IOException {
        return ClipboardFormats.findByFile(file).load(file);
    }

    public static Set<FaweMaskManager> getMaskManagers() {
        return new HashSet<FaweMaskManager>(WEManager.IMP.managers);
    }

    public static boolean isMemoryLimited() {
        return MemUtil.isMemoryLimited();
    }

    public static Region[] getRegions(Player player) {
        return WEManager.IMP.getMask(player);
    }

    public static void cancelEdit(AbstractDelegateExtent extent, Component reason) {
        try {
            WEManager.IMP.cancelEdit(extent, new FaweException(reason));
        }
        catch (WorldEditException worldEditException) {
            // empty catch block
        }
    }

    public static void addMaskManager(FaweMaskManager maskMan) {
        WEManager.IMP.managers.add(maskMan);
    }

    public static DiskStorageHistory getChangeSetFromFile(File file) {
        UUID uuid;
        if (!file.exists() || file.isDirectory()) {
            throw new IllegalArgumentException("Not a file!");
        }
        if (Settings.IMP.HISTORY.USE_DISK) {
            throw new IllegalArgumentException("History on disk not enabled!");
        }
        if (!file.getName().toLowerCase(Locale.ROOT).endsWith(".bd")) {
            throw new IllegalArgumentException("Not a BD file!");
        }
        String[] path = file.getPath().split(File.separator);
        if (path.length < 3) {
            throw new IllegalArgumentException("Not in history directory!");
        }
        String worldName = path[path.length - 3];
        String uuidString = path[path.length - 2];
        World world = FaweAPI.getWorld(worldName);
        if (world == null) {
            throw new IllegalArgumentException("Corresponding world does not exist: " + worldName);
        }
        try {
            uuid = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid UUID from file path: " + uuidString);
        }
        return new DiskStorageHistory(world, uuid, Integer.parseInt(file.getName().split("\\.")[0]));
    }

    public static List<DiskStorageHistory> getBDFiles(Location origin, UUID user, int radius, long timediff, boolean shallow) {
        Extent extent = origin.getExtent();
        if (!(extent instanceof World)) {
            throw new IllegalArgumentException("Origin is not a valid world");
        }
        World world = (World)extent;
        File history = MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.HISTORY + File.separator + world.getName());
        if (!history.exists()) {
            return new ArrayList<DiskStorageHistory>();
        }
        long now = System.currentTimeMillis();
        ArrayList<File> files = new ArrayList<File>();
        for (File userFile : history.listFiles()) {
            UUID userUUID;
            if (!userFile.isDirectory()) continue;
            try {
                userUUID = UUID.fromString(userFile.getName());
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (user != null && !userUUID.equals(user)) continue;
            ArrayList ids = new ArrayList();
            for (File file : userFile.listFiles()) {
                if (!file.getName().endsWith(".bd") || timediff < Integer.MAX_VALUE && now - file.lastModified() > timediff) continue;
                files.add(file);
                if (files.size() <= 2048) continue;
                return null;
            }
        }
        files.sort((a, b) -> {
            int bI;
            String aName = a.getName();
            String bName = b.getName();
            int aI = Integer.parseInt(aName.substring(0, aName.length() - 3));
            long value = aI - (bI = Integer.parseInt(bName.substring(0, bName.length() - 3)));
            return value == 0L ? 0 : (value < 0L ? -1 : 1);
        });
        RegionWrapper bounds = new RegionWrapper(origin.getBlockX() - radius, origin.getBlockX() + radius, origin.getBlockZ() - radius, origin.getBlockZ() + radius);
        RegionWrapper boundsPlus = new RegionWrapper(bounds.minX - 64, bounds.maxX + 512, bounds.minZ - 64, bounds.maxZ + 512);
        HashSet regionSet = Sets.newHashSet((Object[])new RegionWrapper[]{bounds});
        ArrayList<DiskStorageHistory> result = new ArrayList<DiskStorageHistory>();
        for (File file : files) {
            UUID uuid = UUID.fromString(file.getParentFile().getName());
            DiskStorageHistory dsh = new DiskStorageHistory(world, uuid, Integer.parseInt(file.getName().split("\\.")[0]));
            SimpleChangeSetSummary summary = dsh.summarize(boundsPlus, shallow);
            RegionWrapper region = new RegionWrapper(summary.minX, summary.maxX, summary.minZ, summary.maxZ);
            boolean encompassed = false;
            boolean isIn = false;
            for (RegionWrapper allowed : regionSet) {
                isIn = isIn || allowed.intersects(region);
                encompassed = allowed.isIn(region.minX, region.maxX) && allowed.isIn(region.minZ, region.maxZ);
                if (!encompassed) continue;
                break;
            }
            if (!isIn) continue;
            result.add(0, dsh);
            if (!encompassed) {
                regionSet.add(region);
            }
            if (!shallow || result.size() <= 64) continue;
            return result;
        }
        return result;
    }

    public static DiskStorageHistory getChangeSetFromDisk(World world, UUID uuid, int index) {
        return new DiskStorageHistory(world, uuid, index);
    }

    public static int fixLighting(World world, Region selection, @Nullable IQueueExtent<IQueueChunk> queue, RelightMode mode) {
        BlockVector3 bot = selection.getMinimumPoint();
        BlockVector3 top = selection.getMaximumPoint();
        int minX = bot.getBlockX() >> 4;
        int minZ = bot.getBlockZ() >> 4;
        int maxX = top.getBlockX() >> 4;
        int maxZ = top.getBlockZ() >> 4;
        int count = 0;
        if (queue == null) {
            World unwrapped = WorldWrapper.unwrap(world);
            if (unwrapped instanceof IQueueExtent) {
                queue = (IQueueExtent<IQueueChunk>)((Object)unwrapped);
            } else if (Settings.IMP.QUEUE.PARALLEL_THREADS > 1) {
                ParallelQueueExtent parallel = new ParallelQueueExtent(Fawe.get().getQueueHandler(), world, true);
                queue = parallel.getExtent();
            } else {
                queue = Fawe.get().getQueueHandler().getQueue(world);
            }
        }
        NMSRelighter relighter = new NMSRelighter((IQueueExtent<IQueueChunk>)queue, Settings.IMP.LIGHTING.DO_HEIGHTMAPS);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                relighter.addChunk(x, z, null, 65535);
                ++count;
            }
        }
        if (mode != RelightMode.NONE) {
            if (Settings.IMP.LIGHTING.REMOVE_FIRST) {
                relighter.removeAndRelight(true);
            } else {
                relighter.fixSkyLighting();
                relighter.fixBlockLighting();
            }
        } else {
            relighter.removeLighting();
        }
        relighter.flush();
        return count;
    }

    public static void addMemoryLimitedTask(Runnable run) {
        MemUtil.addMemoryLimitedTask(run);
    }

    public static void addMemoryPlentifulTask(Runnable run) {
        MemUtil.addMemoryPlentifulTask(run);
    }

    public static Map<String, String> getTranslations(Locale locale) {
        return WorldEdit.getInstance().getTranslationManager().getTranslationMap(locale);
    }
}

