/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.beta;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.IBlocks;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CombinedBlocks
implements IBlocks {
    private final IBlocks secondary;
    private final IBlocks primary;
    private final int addMask;

    public CombinedBlocks(IBlocks secondary, IBlocks primary, int addMask) {
        this.secondary = secondary;
        this.primary = primary;
        this.addMask = addMask == 0 ? 0 : addMask & secondary.getBitMask();
    }

    @Override
    public int getBitMask() {
        int bitMask = this.addMask;
        for (int layer = 0; layer < FaweCache.IMP.CHUNK_LAYERS; ++layer) {
            if (!this.primary.hasSection(layer)) continue;
            bitMask |= 1 << layer;
        }
        return bitMask;
    }

    @Override
    public void removeSectionLighting(int layer, boolean sky) {
        this.primary.removeSectionLighting(layer, sky);
        this.secondary.removeSectionLighting(layer, sky);
    }

    @Override
    public boolean hasSection(int layer) {
        return this.primary.hasSection(layer) || this.secondary.hasSection(layer);
    }

    @Override
    public char[] load(int layer) {
        if (this.primary.hasSection(layer)) {
            char[] blocks = this.primary.load(layer);
            if (this.secondary.hasSection(layer) && this.primary != this.secondary) {
                int i;
                for (i = 0; i < 4096 && blocks[i] != '\u0000'; ++i) {
                }
                if (i != 4096) {
                    char[] fallback = this.secondary.load(layer);
                    while (i < 4096) {
                        if (blocks[i] == '\u0000') {
                            blocks[i] = fallback[i];
                        }
                        ++i;
                    }
                }
            }
            return blocks;
        }
        return this.secondary.load(layer);
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        BlockState block = this.primary.getBlock(x, y, z);
        if (block.getBlockType() == BlockTypes.__RESERVED__) {
            return this.secondary.getBlock(x, y, z);
        }
        return block;
    }

    @Override
    public Map<BlockVector3, CompoundTag> getTiles() {
        Map<BlockVector3, CompoundTag> tiles = this.primary.getTiles();
        if (this.primary != this.secondary) {
            if (tiles.isEmpty()) {
                return this.secondary.getTiles();
            }
            Map<BlockVector3, CompoundTag> otherTiles = this.secondary.getTiles();
            if (!otherTiles.isEmpty()) {
                HashMap<BlockVector3, CompoundTag> copy = null;
                for (Map.Entry<BlockVector3, CompoundTag> entry : otherTiles.entrySet()) {
                    BlockVector3 pos = entry.getKey();
                    BlockState block = this.primary.getBlock(pos.getX(), pos.getY(), pos.getZ());
                    if (block.getBlockType() != BlockTypes.__RESERVED__) continue;
                    if (copy == null) {
                        copy = new HashMap<BlockVector3, CompoundTag>(tiles);
                    }
                    copy.put(pos, entry.getValue());
                }
                if (copy != null) {
                    return copy;
                }
            }
        }
        return tiles;
    }

    @Override
    public CompoundTag getTile(int x, int y, int z) {
        CompoundTag tile = this.primary.getTile(x, y, z);
        if (tile != null) {
            return tile;
        }
        return this.secondary.getTile(x, y, z);
    }

    @Override
    public Set<CompoundTag> getEntities() {
        Set<CompoundTag> joined = this.primary.getEntities();
        if (this.primary != this.secondary) {
            Set<CompoundTag> ents2 = this.secondary.getEntities();
            if (joined.isEmpty()) {
                return ents2;
            }
            if (ents2.isEmpty()) {
                return joined;
            }
            joined = new HashSet<CompoundTag>(joined);
            joined.addAll(ents2);
        }
        return joined;
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        BiomeType biome = this.primary.getBiomeType(x, y, z);
        if (biome == null) {
            return this.secondary.getBiomeType(x, y, z);
        }
        return biome;
    }

    @Override
    public IBlocks reset() {
        return null;
    }

    @Override
    public boolean trim(boolean aggressive) {
        return false;
    }

    @Override
    public boolean trim(boolean aggressive, int layer) {
        return false;
    }
}

