/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.beta;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.IChunk;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.beta.IChunkSet;
import com.boydti.fawe.beta.implementation.processors.EmptyBatchProcessor;
import com.boydti.fawe.beta.implementation.processors.MultiBatchProcessor;
import com.boydti.fawe.beta.implementation.processors.ProcessorScope;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public interface IBatchProcessor {
    public IChunkSet processSet(IChunk var1, IChunkGet var2, IChunkSet var3);

    public Future<IChunkSet> postProcessSet(IChunk var1, IChunkGet var2, IChunkSet var3);

    default public boolean processGet(int chunkX, int chunkZ) {
        return true;
    }

    @Nullable
    public Extent construct(Extent var1);

    default public boolean trimY(IChunkSet set, int minY, int maxY) {
        int maxLayer;
        int layer;
        int minLayer = minY - 1 >> 4;
        for (int layer2 = 0; layer2 <= minLayer; ++layer2) {
            if (!set.hasSection(layer2)) continue;
            if (layer2 == minLayer) {
                char[] arr = set.load(layer2);
                int index = (minY & 0xF) << 8;
                for (int i = 0; i < index; ++i) {
                    arr[i] = '\u0000';
                }
                set.setBlocks(layer2, arr);
                continue;
            }
            set.setBlocks(layer2, null);
        }
        for (layer = maxLayer = maxY + 1 >> 4; layer < FaweCache.IMP.CHUNK_LAYERS; ++layer) {
            if (!set.hasSection(layer)) continue;
            if (layer == minLayer) {
                int index;
                char[] arr = set.load(layer);
                for (int i = index = (maxY + 1 & 0xF) << 8; i < arr.length; ++i) {
                    arr[i] = '\u0000';
                }
                set.setBlocks(layer, arr);
                continue;
            }
            set.setBlocks(layer, null);
        }
        try {
            for (layer = minY - 15 >> 4; layer < maxY + 15 >> 4; ++layer) {
                if (layer <= -1 || !set.hasSection(layer)) continue;
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            LoggerFactory.getLogger(IBatchProcessor.class).error("minY = {} , layer = {}", minY, minY - 15 >> 4, exception);
        }
        return false;
    }

    default public boolean trimNBT(IChunkSet set, Function<BlockVector3, Boolean> contains) {
        Map<BlockVector3, CompoundTag> tiles;
        Set<CompoundTag> ents = set.getEntities();
        if (!ents.isEmpty()) {
            ents.removeIf(ent -> (Boolean)contains.apply(ent.getEntityPosition().toBlockPoint()) == false);
        }
        if (!(tiles = set.getTiles()).isEmpty()) {
            tiles.entrySet().removeIf(blockVector3CompoundTagEntry -> (Boolean)contains.apply((BlockVector3)blockVector3CompoundTagEntry.getKey()) == false);
        }
        return !tiles.isEmpty() || !ents.isEmpty();
    }

    default public IBatchProcessor join(IBatchProcessor other) {
        return MultiBatchProcessor.of(this, other);
    }

    default public IBatchProcessor joinPost(IBatchProcessor other) {
        return MultiBatchProcessor.of(this, other);
    }

    default public void flush() {
    }

    default public <T extends IBatchProcessor> IBatchProcessor remove(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return EmptyBatchProcessor.getInstance();
        }
        return this;
    }

    default public ProcessorScope getScope() {
        return ProcessorScope.CUSTOM;
    }
}

