/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.beta.implementation.blocks;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.beta.IBlocks;
import com.boydti.fawe.beta.IChunkSet;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import org.jetbrains.annotations.Range;

public abstract class CharBlocks
implements IBlocks {
    public static final Logger logger = LoggerFactory.getLogger(CharBlocks.class);
    protected static final Section FULL = new Section(){

        @Override
        public final char[] get(CharBlocks blocks, int layer) {
            return blocks.blocks[layer];
        }

        @Override
        public final boolean isFull() {
            return true;
        }
    };
    protected final Section EMPTY = new Section(){

        @Override
        public final synchronized char[] get(CharBlocks blocks, int layer) {
            char[] arr = blocks.blocks[layer];
            if (arr == null) {
                blocks.blocks[layer] = blocks.update(layer, null);
                arr = blocks.blocks[layer];
                if (arr == null) {
                    throw new IllegalStateException("Array cannot be null: " + blocks.getClass());
                }
            } else {
                blocks.blocks[layer] = blocks.update(layer, arr);
                if (blocks.blocks[layer] == null) {
                    throw new IllegalStateException("Array cannot be null (update): " + blocks.getClass());
                }
            }
            if (blocks.blocks[layer] != null) {
                blocks.sections[layer] = FULL;
            }
            return arr;
        }

        @Override
        public final boolean isFull() {
            return false;
        }
    };
    public final char[][] blocks = new char[16][];
    public final Section[] sections = new Section[16];

    public CharBlocks() {
        for (int i = 0; i < 16; ++i) {
            this.sections[i] = this.EMPTY;
        }
    }

    @Override
    public boolean trim(boolean aggressive) {
        boolean result = true;
        for (int i = 0; i < 16; ++i) {
            if (!this.sections[i].isFull() && this.blocks[i] != null) {
                this.blocks[i] = null;
                continue;
            }
            result = false;
        }
        return result;
    }

    @Override
    public boolean trim(boolean aggressive, int layer) {
        boolean result = true;
        if (!this.sections[layer].isFull() && this.blocks[layer] != null) {
            this.blocks[layer] = null;
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public IChunkSet reset() {
        for (int i = 0; i < 16; ++i) {
            this.sections[i] = this.EMPTY;
        }
        return null;
    }

    public void reset(@Range(from=0L, to=15L) int layer) {
        this.sections[layer] = this.EMPTY;
    }

    public char[] update(int layer, char[] data) {
        if (data == null) {
            return new char[4096];
        }
        for (int i = 0; i < 4096; ++i) {
            data[i] = '\u0000';
        }
        return data;
    }

    @Override
    public boolean hasSection(@Range(from=0L, to=15L) int layer) {
        return this.sections[layer].isFull();
    }

    @Override
    public char[] load(@Range(from=0L, to=15L) int layer) {
        return this.sections[layer].get(this, layer);
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return BlockTypesCache.states[this.get(x, y, z)];
    }

    public char get(int x, @Range(from=0L, to=255L) int y, int z) {
        int layer = y >> 4;
        int index = (y & 0xF) << 8 | z << 4 | x;
        if (layer >= this.sections.length || layer < 0) {
            return '\u0000';
        }
        return this.sections[layer].get(this, layer, index);
    }

    public void set(int x, @Range(from=0L, to=255L) int y, int z, char value) {
        int layer = y >> 4;
        int index = (y & 0xF) << 8 | z << 4 | x;
        try {
            this.set(layer, index, value);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            logger.error("Tried setting block at coordinates (" + x + "," + y + "," + z + ")");
            assert (Fawe.imp() != null);
            logger.error("Layer variable was = {}", (Object)layer, (Object)exception);
        }
    }

    public final char get(@Range(from=0L, to=15L) int layer, int index) {
        return this.sections[layer].get(this, layer, index);
    }

    public final void set(@Range(from=0L, to=15L) int layer, int index, char value) throws ArrayIndexOutOfBoundsException {
        this.sections[layer].set(this, layer, index, value);
    }

    public static abstract class Section {
        public abstract char[] get(CharBlocks var1, @Range(from=0L, to=15L) int var2);

        public abstract boolean isFull();

        public final char get(CharBlocks blocks, @Range(from=0L, to=15L) int layer, int index) {
            return this.get(blocks, layer)[index];
        }

        public final void set(CharBlocks blocks, @Range(from=0L, to=15L) int layer, int index, char value) {
            this.get((CharBlocks)blocks, (int)layer)[index] = value;
        }
    }
}

