/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.beta.implementation.blocks;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.IChunkSet;
import com.boydti.fawe.beta.implementation.blocks.CharBlocks;
import com.boydti.fawe.beta.implementation.lighting.HeightMapType;
import com.boydti.fawe.beta.implementation.queue.Pool;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.collection.BlockVector3ChunkMap;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Range;

public class CharSetBlocks
extends CharBlocks
implements IChunkSet {
    private static final Pool<CharSetBlocks> POOL = FaweCache.IMP.registerPool(CharSetBlocks.class, CharSetBlocks::new, Settings.IMP.QUEUE.POOL);
    public BiomeType[] biomes;
    public char[][] light;
    public char[][] skyLight;
    public BlockVector3ChunkMap<CompoundTag> tiles;
    public HashSet<CompoundTag> entities;
    public HashSet<UUID> entityRemoves;
    public Map<HeightMapType, int[]> heightMaps;
    private boolean fastMode = false;
    private int bitMask = -1;

    public static CharSetBlocks newInstance() {
        return POOL.poll();
    }

    private CharSetBlocks() {
    }

    @Override
    public void recycle() {
        POOL.offer(this);
    }

    @Override
    public BiomeType[] getBiomes() {
        return this.biomes;
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        if (this.biomes == null) {
            return null;
        }
        return this.biomes[y >> 2 << 4 | z >> 2 << 2 | x >> 2];
    }

    @Override
    public Map<BlockVector3, CompoundTag> getTiles() {
        return this.tiles == null ? Collections.emptyMap() : this.tiles;
    }

    @Override
    public CompoundTag getTile(int x, int y, int z) {
        return this.tiles == null ? null : this.tiles.get(x, y, z);
    }

    @Override
    public Set<CompoundTag> getEntities() {
        return this.entities == null ? Collections.emptySet() : this.entities;
    }

    @Override
    public Set<UUID> getEntityRemoves() {
        return this.entityRemoves == null ? Collections.emptySet() : this.entityRemoves;
    }

    @Override
    public Map<HeightMapType, int[]> getHeightMaps() {
        return this.heightMaps == null ? new HashMap() : this.heightMaps;
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        if (this.biomes == null) {
            this.biomes = new BiomeType[1024];
        }
        this.biomes[y >> 2 << 4 | z >> 2 << 2 | x >> 2] = biome;
        return true;
    }

    @Override
    public <T extends BlockStateHolder<T>> boolean setBlock(int x, @Range(from=0L, to=255L) int y, int z, T holder) {
        this.set(x, y, z, holder.getOrdinalChar());
        holder.applyTileEntity(this, x, y, z);
        return true;
    }

    @Override
    public void setBlocks(int layer, char[] data) {
        this.blocks[layer] = data;
        this.sections[layer] = data == null ? this.EMPTY : FULL;
    }

    @Override
    public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 position, T block) throws WorldEditException {
        return this.setBlock(position.getX(), position.getY(), position.getZ(), block);
    }

    @Override
    public boolean setTile(int x, int y, int z, CompoundTag tile) {
        if (this.tiles == null) {
            this.tiles = new BlockVector3ChunkMap();
        }
        this.tiles.put(x, y, z, tile);
        return true;
    }

    @Override
    public void setBlockLight(int x, int y, int z, int value) {
        int layer;
        if (this.light == null) {
            this.light = new char[16][];
        }
        if (this.light[layer = y >> 4] == null) {
            char[] c = new char[4096];
            Arrays.fill(c, '\u0010');
            this.light[layer] = c;
        }
        int index = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
        this.light[y >> 4][index] = (char)value;
    }

    @Override
    public void setSkyLight(int x, int y, int z, int value) {
        int layer;
        if (this.skyLight == null) {
            this.skyLight = new char[16][];
        }
        if (this.skyLight[layer = y >> 4] == null) {
            char[] c = new char[4096];
            Arrays.fill(c, '\u0010');
            this.skyLight[layer] = c;
        }
        int index = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
        this.skyLight[y >> 4][index] = (char)value;
    }

    @Override
    public void setHeightMap(HeightMapType type, int[] heightMap) {
        if (this.heightMaps == null) {
            this.heightMaps = new HashMap<HeightMapType, int[]>();
        }
        this.heightMaps.put(type, heightMap);
    }

    @Override
    public void setLightLayer(int layer, char[] toSet) {
        if (this.light == null) {
            this.light = new char[16][];
        }
        this.light[layer] = toSet;
    }

    @Override
    public void setSkyLightLayer(int layer, char[] toSet) {
        if (this.skyLight == null) {
            this.skyLight = new char[16][];
        }
        this.skyLight[layer] = toSet;
    }

    @Override
    public char[][] getLight() {
        return this.light;
    }

    @Override
    public char[][] getSkyLight() {
        return this.skyLight;
    }

    @Override
    public void removeSectionLighting(int layer, boolean sky) {
        if (this.light == null) {
            this.light = new char[16][];
        }
        if (this.light[layer] == null) {
            this.light[layer] = new char[4096];
        }
        Arrays.fill(this.light[layer], '\u0000');
        if (sky) {
            if (this.skyLight == null) {
                this.skyLight = new char[16][];
            }
            if (this.skyLight[layer] == null) {
                this.skyLight[layer] = new char[4096];
            }
            Arrays.fill(this.skyLight[layer], '\u0000');
        }
    }

    @Override
    public void setFullBright(int layer) {
        if (this.light == null) {
            this.light = new char[16][];
        }
        if (this.light[layer] == null) {
            this.light[layer] = new char[4096];
        }
        if (this.skyLight == null) {
            this.skyLight = new char[16][];
        }
        if (this.skyLight[layer] == null) {
            this.skyLight[layer] = new char[4096];
        }
        Arrays.fill(this.light[layer], '\u000f');
        Arrays.fill(this.skyLight[layer], '\u000f');
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        return this.setBiome(position.getX(), position.getY(), position.getZ(), biome);
    }

    @Override
    public void setEntity(CompoundTag tag) {
        if (this.entities == null) {
            this.entities = new HashSet();
        }
        this.entities.add(tag);
    }

    @Override
    public void removeEntity(UUID uuid) {
        if (this.entityRemoves == null) {
            this.entityRemoves = new HashSet();
        }
        this.entityRemoves.add(uuid);
    }

    @Override
    public void setFastMode(boolean fastMode) {
        this.fastMode = fastMode;
    }

    @Override
    public boolean isFastMode() {
        return this.fastMode;
    }

    @Override
    public void setBitMask(int bitMask) {
        this.bitMask = bitMask;
    }

    @Override
    public int getBitMask() {
        return this.bitMask;
    }

    @Override
    public boolean isEmpty() {
        if (this.biomes != null || this.light != null || this.skyLight != null) {
            return false;
        }
        return IntStream.range(0, 16).noneMatch(this::hasSection);
    }

    @Override
    public IChunkSet reset() {
        this.biomes = null;
        this.tiles = null;
        this.entities = null;
        this.entityRemoves = null;
        super.reset();
        return null;
    }
}

