/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.beta.implementation.blocks;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.IBlocks;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.beta.IChunkSet;
import com.boydti.fawe.beta.implementation.lighting.HeightMapType;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;

public class FallbackChunkGet
implements IChunkGet {
    private final int bx;
    private final int bz;
    private final Extent extent;

    public FallbackChunkGet(Extent extent, int chunkX, int chunkZ) {
        this.extent = extent;
        this.bx = chunkX << 4;
        this.bz = chunkZ << 4;
    }

    @Override
    public BaseBlock getFullBlock(int x, int y, int z) {
        return this.extent.getFullBlock(this.bx + x, y, this.bz + z);
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        return this.extent.getBiomeType(this.bx + x, y, this.bz + z);
    }

    @Override
    public void removeSectionLighting(int layer, boolean sky) {
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return this.extent.getBlock(this.bx + x, y, this.bz + z);
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        return this.extent.getSkyLight(this.bx + x, y, this.bz + z);
    }

    @Override
    public int[] getHeightMap(HeightMapType type) {
        return this.extent.getHeightMap(type);
    }

    @Override
    public int getEmmittedLight(int x, int y, int z) {
        return this.extent.getEmmittedLight(this.bx + x, y, this.bz + z);
    }

    @Override
    public CompoundTag getTile(int x, int y, int z) {
        return this.extent.getFullBlock(this.bx + x, y, this.bz + z).getNbtData();
    }

    @Override
    public Map<BlockVector3, CompoundTag> getTiles() {
        return null;
    }

    @Override
    public Set<CompoundTag> getEntities() {
        List<? extends Entity> result = this.extent.getEntities(new CuboidRegion(BlockVector3.at(this.bx, 0, this.bz), BlockVector3.at(this.bx + 15, 255, this.bz + 15)));
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<CompoundTag> set = new HashSet<CompoundTag>(result.size());
        for (Entity entity : result) {
            set.add(entity.getState().getNbtData());
        }
        return set;
    }

    @Override
    public CompoundTag getEntity(UUID uuid) {
        long checkMost = uuid.getMostSignificantBits();
        long checkLeast = uuid.getLeastSignificantBits();
        for (CompoundTag entityTag : this.getEntities()) {
            long entLeast;
            long entMost = entityTag.getLong("UUIDMost");
            if (entMost != checkMost || (entLeast = entityTag.getLong("UUIDLeast")) != checkLeast) continue;
            return entityTag;
        }
        return null;
    }

    @Override
    public void setCreateCopy(boolean createCopy) {
    }

    @Override
    public boolean isCreateCopy() {
        return false;
    }

    @Override
    public void setLightingToGet(char[][] lighting) {
    }

    @Override
    public void setSkyLightingToGet(char[][] lighting) {
    }

    @Override
    public void setHeightmapToGet(HeightMapType type, int[] data) {
    }

    @Override
    public boolean trim(boolean aggressive) {
        return true;
    }

    @Override
    public boolean trim(boolean aggressive, int layer) {
        return true;
    }

    @Override
    public <T extends Future<T>> T call(IChunkSet set, Runnable finalize) {
        BiomeType[] biomes;
        Set<UUID> kills;
        Set<CompoundTag> spawns;
        Object arr;
        for (int layer = 0; layer < 16; ++layer) {
            if (!set.hasSection(layer)) continue;
            arr = set.load(layer);
            int by = layer << 4;
            int i = 0;
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    int x = 0;
                    while (x < 16) {
                        Object ordinal = arr[i];
                        if (ordinal != false) {
                            BlockState block = BlockState.getFromOrdinal((int)ordinal);
                            this.extent.setBlock(this.bx + x, by + y, this.bz + z, block);
                        }
                        ++x;
                        ++i;
                    }
                }
            }
        }
        Map<BlockVector3, CompoundTag> tiles = set.getTiles();
        if (!tiles.isEmpty()) {
            arr = tiles.entrySet().iterator();
            while (arr.hasNext()) {
                Map.Entry entry = (Map.Entry)arr.next();
                BlockVector3 pos = (BlockVector3)entry.getKey();
                this.extent.setTile(this.bx + pos.getX(), pos.getY(), this.bz + pos.getZ(), (CompoundTag)entry.getValue());
            }
        }
        if (!(spawns = set.getEntities()).isEmpty()) {
            for (CompoundTag spawn : spawns) {
                BaseEntity ent = new BaseEntity(spawn);
                this.extent.createEntity(ent.getLocation(this.extent), ent);
            }
        }
        if (!(kills = set.getEntityRemoves()).isEmpty()) {
            for (UUID kill : kills) {
                this.extent.removeEntity(0, 0, 0, kill);
            }
        }
        if ((biomes = set.getBiomes()) != null) {
            int i = 0;
            for (int y = 0; y < 64; ++y) {
                for (int z = 0; z < 4; ++z) {
                    int x = 0;
                    while (x < 4) {
                        BiomeType biome = biomes[i];
                        if (biome != null) {
                            this.extent.setBiome(this.bx + (x << 2), y << 2, this.bz + (z << 2), biome);
                        }
                        ++x;
                        ++i;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public char[] load(int layer) {
        char[] arr = (char[])FaweCache.IMP.SECTION_BITS_TO_CHAR.get();
        int by = layer << 4;
        int i = 0;
        for (int y = 0; y < 16; ++y) {
            for (int z = 0; z < 16; ++z) {
                int x = 0;
                while (x < 16) {
                    arr[i] = this.getBlock(this.bx + x, by + y, this.bz + z).getOrdinalChar();
                    ++x;
                    ++i;
                }
            }
        }
        return arr;
    }

    @Override
    public boolean hasSection(int layer) {
        return true;
    }

    @Override
    public IBlocks reset() {
        return null;
    }
}

