/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.beta.implementation.cache;

import com.boydti.fawe.beta.IChunkCache;
import com.boydti.fawe.beta.Trimable;
import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.bukkit.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import com.sk89q.worldedit.bukkit.fastutil.longs.Long2ObjectMap;
import com.sk89q.worldedit.bukkit.fastutil.objects.ObjectIterator;
import java.lang.ref.WeakReference;

public class ChunkCache<T extends Trimable>
implements IChunkCache<T> {
    protected final Long2ObjectLinkedOpenHashMap<WeakReference<T>> getCache = new Long2ObjectLinkedOpenHashMap();
    private final IChunkCache<T> delegate;

    public ChunkCache(IChunkCache<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public synchronized T get(int x, int z) {
        Trimable blocks;
        long pair = MathMan.pairInt(x, z);
        WeakReference<T> ref = this.getCache.get(pair);
        if (ref != null && (blocks = (Trimable)ref.get()) != null) {
            return (T)blocks;
        }
        blocks = this.newChunk(x, z);
        this.getCache.put(pair, (WeakReference<T>)new WeakReference<Trimable>(blocks));
        return (T)blocks;
    }

    public T newChunk(int chunkX, int chunkZ) {
        return (T)((Trimable)this.delegate.get(chunkX, chunkZ));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean trim(boolean aggressive) {
        if (this.getCache.isEmpty()) {
            return true;
        }
        boolean result = true;
        ObjectIterator iter = this.getCache.long2ObjectEntrySet().fastIterator();
        while (iter.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iter.next();
            WeakReference value = (WeakReference)entry.getValue();
            Trimable igb = (Trimable)value.get();
            if (igb == null) {
                iter.remove();
                continue;
            }
            result = false;
            if (!aggressive) {
                return false;
            }
            Trimable trimable = igb;
            synchronized (trimable) {
                igb.trim(true);
            }
        }
        return result;
    }
}

