/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.beta.implementation.cache.preloader;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.beta.implementation.cache.preloader.Preloader;
import com.boydti.fawe.object.collection.MutablePair;
import com.boydti.fawe.util.FaweTimer;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class AsyncPreloader
implements Preloader,
Runnable {
    private final ConcurrentHashMap<UUID, MutablePair<World, Set<BlockVector2>>> update = new ConcurrentHashMap();

    public AsyncPreloader() {
        Fawe.get().getQueueHandler().async(this);
    }

    @Override
    public void cancel(Player player) {
        this.cancelAndGet(player);
    }

    private MutablePair<World, Set<BlockVector2>> cancelAndGet(Actor player) {
        MutablePair<World, Set<BlockVector2>> existing = this.update.get(player.getUniqueId());
        if (existing != null) {
            existing.setValue(null);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Player player) {
        block11: {
            LocalSession session = WorldEdit.getInstance().getSessionManager().getIfPresent(player);
            if (session == null) {
                return;
            }
            World world = player.getWorld();
            MutablePair<World, Set<BlockVector2>> existing = this.cancelAndGet(player);
            try {
                Region region = session.getSelection(world);
                if (!(region instanceof CuboidRegion) || region.getVolume() > 50466816L) {
                    return;
                }
                if (existing != null) break block11;
                existing = new MutablePair();
                MutablePair previous = this.update.putIfAbsent(player.getUniqueId(), existing);
                if (previous != null) {
                    existing = previous;
                }
                Object object = existing;
                synchronized (object) {
                    existing.setKey(world);
                    existing.setValue(region.getChunks());
                }
                object = this.update;
                synchronized (object) {
                    this.update.notify();
                }
            }
            catch (IncompleteRegionException incompleteRegionException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        FaweTimer timer = Fawe.get().getTimer();
        try {
            while (true) {
                Object plrIter;
                if (!this.update.isEmpty()) {
                    if (timer.getTPS() > 19.0) {
                        plrIter = this.update.entrySet().iterator();
                        Map.Entry entry = (Map.Entry)plrIter.next();
                        MutablePair pair = (MutablePair)entry.getValue();
                        World world = (World)pair.getKey();
                        Set chunks = (Set)pair.getValue();
                        if (chunks != null) {
                            Iterator chunksIter = chunks.iterator();
                            while (chunksIter.hasNext() && pair.getValue() == chunks) {
                                BlockVector2 chunk = (BlockVector2)chunksIter.next();
                                this.queueLoad(world, chunk);
                            }
                        }
                        plrIter.remove();
                        continue;
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                plrIter = this.update;
                synchronized (plrIter) {
                    this.update.wait();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public void queueLoad(World world, BlockVector2 chunk) {
        world.checkLoadedChunk(BlockVector3.at(chunk.getX() << 4, 0, chunk.getZ() << 4));
    }
}

