/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.beta.implementation.chunk;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.Filter;
import com.boydti.fawe.beta.IChunk;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.beta.IChunkSet;
import com.boydti.fawe.beta.IQueueChunk;
import com.boydti.fawe.beta.IQueueExtent;
import com.boydti.fawe.beta.implementation.filter.block.ChunkFilterBlock;
import com.boydti.fawe.beta.implementation.lighting.HeightMapType;
import com.boydti.fawe.beta.implementation.processors.EmptyBatchProcessor;
import com.boydti.fawe.beta.implementation.queue.Pool;
import com.boydti.fawe.config.Settings;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Range;

public class ChunkHolder<T extends Future<T>>
implements IQueueChunk<T> {
    private static final Pool<ChunkHolder> POOL = FaweCache.IMP.registerPool(ChunkHolder.class, ChunkHolder::new, Settings.IMP.QUEUE.POOL);
    private IChunkGet chunkExisting;
    private IChunkSet chunkSet;
    private IBlockDelegate delegate = NULL;
    private IQueueExtent<? extends IChunk> extent;
    private int chunkX;
    private int chunkZ;
    private boolean fastmode;
    private int bitMask = -1;
    private boolean isInit = false;
    private boolean createCopy = false;
    private static final IBlockDelegate BOTH = new IBlockDelegate(){

        public IChunkGet get(ChunkHolder chunk) {
            return chunk.chunkExisting;
        }

        @Override
        public IChunkSet set(ChunkHolder chunk) {
            return chunk.chunkSet;
        }

        @Override
        public boolean setBiome(ChunkHolder chunk, int x, int y, int z, BiomeType biome) {
            return chunk.chunkSet.setBiome(x, y, z, biome);
        }

        public <B extends BlockStateHolder<B>> boolean setBlock(ChunkHolder chunk, int x, int y, int z, B block) {
            return chunk.chunkSet.setBlock(x, y, z, block);
        }

        @Override
        public void setSkyLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.chunkSet.setSkyLight(x, y, z, value);
        }

        @Override
        public void setBlockLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.chunkSet.setBlockLight(x, y, z, value);
        }

        @Override
        public void removeSectionLighting(ChunkHolder chunk, int layer, boolean sky) {
            chunk.chunkSet.removeSectionLighting(layer, sky);
            chunk.chunkExisting.removeSectionLighting(layer, sky);
        }

        @Override
        public void setFullBright(ChunkHolder chunk, int layer) {
            chunk.chunkSet.setFullBright(layer);
        }

        @Override
        public void setLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.chunkSet.setLightLayer(layer, toSet);
        }

        @Override
        public void setSkyLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.chunkSet.setSkyLightLayer(layer, toSet);
        }

        @Override
        public void setHeightMap(ChunkHolder chunk, HeightMapType type, int[] heightMap) {
            chunk.chunkSet.setHeightMap(type, heightMap);
        }

        @Override
        public BiomeType getBiome(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getBiomeType(x, y, z);
        }

        @Override
        public BlockState getBlock(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getBlock(x, y, z);
        }

        @Override
        public BaseBlock getFullBlock(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getFullBlock(x, y, z);
        }

        @Override
        public int getSkyLight(ChunkHolder chunk, int x, int y, int z) {
            if (chunk.chunkSet.getSkyLight() != null) {
                char setLightValue;
                int layer = y >> 4;
                if (chunk.chunkSet.getSkyLight()[layer] != null && (setLightValue = chunk.chunkSet.getSkyLight()[layer][(y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF]) < '\u0010') {
                    return setLightValue;
                }
            }
            return chunk.chunkExisting.getSkyLight(x, y, z);
        }

        @Override
        public int getEmmittedLight(ChunkHolder chunk, int x, int y, int z) {
            if (chunk.chunkSet.getLight() != null) {
                char setLightValue;
                int layer = y >> 4;
                if (chunk.chunkSet.getLight()[layer] != null && (setLightValue = chunk.chunkSet.getLight()[layer][(y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF]) < '\u0010') {
                    return setLightValue;
                }
            }
            return chunk.chunkExisting.getEmmittedLight(x, y, z);
        }

        @Override
        public int getBrightness(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getBrightness(x, y, z);
        }

        @Override
        public int getOpacity(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getOpacity(x, y, z);
        }

        @Override
        public int[] getHeightMap(ChunkHolder chunk, HeightMapType type) {
            return chunk.chunkExisting.getHeightMap(type);
        }

        @Override
        public void flushLightToGet(ChunkHolder chunk, boolean heightmaps) {
            chunk.chunkExisting.setLightingToGet(chunk.chunkSet.getLight());
            chunk.chunkExisting.setSkyLightingToGet(chunk.chunkSet.getSkyLight());
        }

        @Override
        public void setLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.chunkExisting.setLightingToGet(lighting);
        }

        @Override
        public void setSkyLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.chunkExisting.setSkyLightingToGet(lighting);
        }

        @Override
        public void setHeightmapToGet(ChunkHolder chunk, HeightMapType type, int[] data) {
            chunk.chunkExisting.setHeightmapToGet(type, data);
        }
    };
    private static final IBlockDelegate GET = new IBlockDelegate(){

        public IChunkGet get(ChunkHolder chunk) {
            return chunk.chunkExisting;
        }

        @Override
        public IChunkSet set(ChunkHolder chunk) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            return chunk.chunkSet;
        }

        @Override
        public boolean setBiome(ChunkHolder chunk, int x, int y, int z, BiomeType biome) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            return chunk.setBiome(x, y, z, biome);
        }

        @Override
        public <T extends BlockStateHolder<T>> boolean setBlock(ChunkHolder chunk, int x, int y, int z, T block) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            return chunk.setBlock(x, y, z, block);
        }

        @Override
        public void setSkyLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.setSkyLight(x, y, z, value);
        }

        @Override
        public void setBlockLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.setBlockLight(x, y, z, value);
        }

        @Override
        public void removeSectionLighting(ChunkHolder chunk, int layer, boolean sky) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.removeSectionLighting(layer, sky);
        }

        @Override
        public void setFullBright(ChunkHolder chunk, int layer) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.setFullBright(layer);
        }

        @Override
        public void setLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.setLightLayer(layer, toSet);
        }

        @Override
        public void setSkyLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.setSkyLightLayer(layer, toSet);
        }

        @Override
        public void setHeightMap(ChunkHolder chunk, HeightMapType type, int[] heightMap) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.setHeightMap(type, heightMap);
        }

        @Override
        public BiomeType getBiome(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getBiomeType(x, y, z);
        }

        @Override
        public BlockState getBlock(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getBlock(x, y, z);
        }

        @Override
        public BaseBlock getFullBlock(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getFullBlock(x, y, z);
        }

        @Override
        public int getSkyLight(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getSkyLight(x, y, z);
        }

        @Override
        public int getEmmittedLight(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getEmmittedLight(x, y, z);
        }

        @Override
        public int getBrightness(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getBrightness(x, y, z);
        }

        @Override
        public int getOpacity(ChunkHolder chunk, int x, int y, int z) {
            return chunk.chunkExisting.getOpacity(x, y, z);
        }

        @Override
        public int[] getHeightMap(ChunkHolder chunk, HeightMapType type) {
            return chunk.chunkExisting.getHeightMap(type);
        }

        @Override
        public void flushLightToGet(ChunkHolder chunk, boolean heightmaps) {
        }

        @Override
        public void setLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.chunkExisting.setLightingToGet(lighting);
        }

        @Override
        public void setSkyLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.chunkExisting.setSkyLightingToGet(lighting);
        }

        @Override
        public void setHeightmapToGet(ChunkHolder chunk, HeightMapType type, int[] data) {
            chunk.chunkExisting.setHeightmapToGet(type, data);
        }
    };
    private static final IBlockDelegate SET = new IBlockDelegate(){

        public IChunkGet get(ChunkHolder chunk) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.chunkExisting.trim(false);
            return chunk.chunkExisting;
        }

        @Override
        public IChunkSet set(ChunkHolder chunk) {
            return chunk.chunkSet;
        }

        @Override
        public boolean setBiome(ChunkHolder chunk, int x, int y, int z, BiomeType biome) {
            return chunk.chunkSet.setBiome(x, y, z, biome);
        }

        public <B extends BlockStateHolder<B>> boolean setBlock(ChunkHolder chunk, int x, @Range(from=0L, to=255L) int y, int z, B block) {
            return chunk.chunkSet.setBlock(x, y, z, block);
        }

        @Override
        public void setSkyLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.chunkSet.setSkyLight(x, y, z, value);
        }

        @Override
        public void setBlockLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.chunkSet.setBlockLight(x, y, z, value);
        }

        @Override
        public void removeSectionLighting(ChunkHolder chunk, int layer, boolean sky) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.removeSectionLighting(layer, sky);
        }

        @Override
        public void setFullBright(ChunkHolder chunk, int layer) {
            chunk.chunkSet.setFullBright(layer);
        }

        @Override
        public void setLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.chunkSet.setLightLayer(layer, toSet);
        }

        @Override
        public void setSkyLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.chunkSet.setSkyLightLayer(layer, toSet);
        }

        @Override
        public void setHeightMap(ChunkHolder chunk, HeightMapType type, int[] heightMap) {
            chunk.chunkSet.setHeightMap(type, heightMap);
        }

        @Override
        public BiomeType getBiome(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.chunkExisting.trim(false);
            return chunk.getBiomeType(x, y, z);
        }

        @Override
        public BlockState getBlock(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.chunkExisting.trim(false);
            return chunk.getBlock(x, y, z);
        }

        @Override
        public BaseBlock getFullBlock(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.chunkExisting.trim(false);
            return chunk.getFullBlock(x, y, z);
        }

        @Override
        public int getSkyLight(ChunkHolder chunk, int x, int y, int z) {
            if (chunk.chunkSet.getSkyLight() != null) {
                char setLightValue;
                int layer = y >> 4;
                if (chunk.chunkSet.getSkyLight()[layer] != null && (setLightValue = chunk.chunkSet.getSkyLight()[layer][(y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF]) < '\u0010') {
                    return setLightValue;
                }
            }
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.chunkExisting.trim(false);
            return chunk.getSkyLight(x, y, z);
        }

        @Override
        public int getEmmittedLight(ChunkHolder chunk, int x, int y, int z) {
            if (chunk.chunkSet.getLight() != null) {
                char setLightValue;
                int layer = y >> 4;
                if (chunk.chunkSet.getLight()[layer] != null && (setLightValue = chunk.chunkSet.getLight()[layer][(y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF]) < '\u0010') {
                    return setLightValue;
                }
            }
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.chunkExisting.trim(false);
            return chunk.getEmmittedLight(x, y, z);
        }

        @Override
        public int getBrightness(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.chunkExisting.trim(false);
            return chunk.getBrightness(x, y, z);
        }

        @Override
        public int getOpacity(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.chunkExisting.trim(false);
            return chunk.getOpacity(x, y, z);
        }

        @Override
        public int[] getHeightMap(ChunkHolder chunk, HeightMapType type) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.chunkExisting.trim(false);
            return chunk.getHeightMap(type);
        }

        @Override
        public void flushLightToGet(ChunkHolder chunk, boolean heightmaps) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.chunkExisting.trim(false);
            chunk.chunkExisting.setLightingToGet(chunk.chunkSet.getLight());
            chunk.chunkExisting.setSkyLightingToGet(chunk.chunkSet.getSkyLight());
        }

        @Override
        public void setLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.chunkExisting.trim(false);
            chunk.chunkExisting.setLightingToGet(lighting);
        }

        @Override
        public void setSkyLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.chunkExisting.trim(false);
            chunk.chunkExisting.setSkyLightingToGet(lighting);
        }

        @Override
        public void setHeightmapToGet(ChunkHolder chunk, HeightMapType type, int[] data) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.chunkExisting.trim(false);
            chunk.chunkExisting.setHeightmapToGet(type, data);
        }
    };
    private static final IBlockDelegate NULL = new IBlockDelegate(){

        public IChunkGet get(ChunkHolder chunk) {
            chunk.getOrCreateGet();
            chunk.delegate = BOTH;
            chunk.chunkExisting.trim(false);
            return chunk.chunkExisting;
        }

        @Override
        public IChunkSet set(ChunkHolder chunk) {
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            return chunk.chunkSet;
        }

        @Override
        public boolean setBiome(ChunkHolder chunk, int x, int y, int z, BiomeType biome) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            return chunk.setBiome(x, y, z, biome);
        }

        @Override
        public <T extends BlockStateHolder<T>> boolean setBlock(ChunkHolder chunk, int x, int y, int z, T block) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            return chunk.setBlock(x, y, z, block);
        }

        @Override
        public BiomeType getBiome(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            chunk.chunkExisting.trim(false);
            return chunk.getBiomeType(x, y, z);
        }

        @Override
        public BlockState getBlock(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            chunk.chunkExisting.trim(false);
            return chunk.getBlock(x, y, z);
        }

        @Override
        public BaseBlock getFullBlock(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            chunk.chunkExisting.trim(false);
            return chunk.getFullBlock(x, y, z);
        }

        @Override
        public void setSkyLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            chunk.setSkyLight(x, y, z, value);
        }

        @Override
        public void setBlockLight(ChunkHolder chunk, int x, int y, int z, int value) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            chunk.setBlockLight(x, y, z, value);
        }

        @Override
        public void removeSectionLighting(ChunkHolder chunk, int layer, boolean sky) {
            chunk.getOrCreateGet();
            chunk.getOrCreateSet();
            chunk.delegate = BOTH;
            chunk.removeSectionLighting(layer, sky);
        }

        @Override
        public void setFullBright(ChunkHolder chunk, int layer) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            chunk.setFullBright(layer);
        }

        @Override
        public void setLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            chunk.setLightLayer(layer, toSet);
        }

        @Override
        public void setSkyLightLayer(ChunkHolder chunk, int layer, char[] toSet) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            chunk.setSkyLightLayer(layer, toSet);
        }

        @Override
        public void setHeightMap(ChunkHolder chunk, HeightMapType type, int[] heightMap) {
            chunk.getOrCreateSet();
            chunk.delegate = SET;
            chunk.setHeightMap(type, heightMap);
        }

        @Override
        public int getSkyLight(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            chunk.chunkExisting.trim(false);
            return chunk.getSkyLight(x, y, z);
        }

        @Override
        public int getEmmittedLight(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            chunk.chunkExisting.trim(false);
            return chunk.getEmmittedLight(x, y, z);
        }

        @Override
        public int getBrightness(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            chunk.chunkExisting.trim(false);
            return chunk.getBrightness(x, y, z);
        }

        @Override
        public int getOpacity(ChunkHolder chunk, int x, int y, int z) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            chunk.chunkExisting.trim(false);
            return chunk.getOpacity(x, y, z);
        }

        @Override
        public int[] getHeightMap(ChunkHolder chunk, HeightMapType type) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            chunk.chunkExisting.trim(false);
            return chunk.getHeightMap(type);
        }

        @Override
        public void flushLightToGet(ChunkHolder chunk, boolean heightmaps) {
        }

        @Override
        public void setLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            chunk.chunkExisting.trim(false);
            chunk.setLightingToGet(lighting);
        }

        @Override
        public void setSkyLightingToGet(ChunkHolder chunk, char[][] lighting) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            chunk.chunkExisting.trim(false);
            chunk.setSkyLightingToGet(lighting);
        }

        @Override
        public void setHeightmapToGet(ChunkHolder chunk, HeightMapType type, int[] data) {
            chunk.getOrCreateGet();
            chunk.delegate = GET;
            chunk.chunkExisting.trim(false);
            chunk.setHeightmapToGet(type, data);
        }
    };

    public static ChunkHolder newInstance() {
        return POOL.poll();
    }

    private ChunkHolder() {
    }

    public void init(IBlockDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public void recycle() {
        this.delegate = NULL;
    }

    public IBlockDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean setTile(int x, int y, int z, CompoundTag tag) {
        return this.delegate.set(this).setTile(x, y, z, tag);
    }

    @Override
    public CompoundTag getTile(int x, int y, int z) {
        return this.delegate.set(this).getTile(x, y, z);
    }

    @Override
    public void setEntity(CompoundTag tag) {
        this.delegate.set(this).setEntity(tag);
    }

    @Override
    public void removeEntity(UUID uuid) {
        this.delegate.set(this).removeEntity(uuid);
    }

    @Override
    public Set<UUID> getEntityRemoves() {
        return this.delegate.set(this).getEntityRemoves();
    }

    @Override
    public BiomeType[] getBiomes() {
        return this.delegate.set(this).getBiomes();
    }

    @Override
    public char[][] getLight() {
        return this.delegate.set(this).getLight();
    }

    @Override
    public char[][] getSkyLight() {
        return this.delegate.set(this).getSkyLight();
    }

    @Override
    public void setBlocks(int layer, char[] data) {
        this.delegate.set(this).setBlocks(layer, data);
    }

    @Override
    public char[] load(int layer) {
        return this.getOrCreateGet().load(layer);
    }

    @Override
    public boolean isFastMode() {
        return this.fastmode;
    }

    @Override
    public void setFastMode(boolean fastmode) {
        this.fastmode = fastmode;
    }

    @Override
    public void setBitMask(int bitMask) {
        this.bitMask = bitMask;
    }

    @Override
    public int getBitMask() {
        return this.bitMask;
    }

    public boolean isInit() {
        return this.isInit;
    }

    @Override
    public CompoundTag getEntity(UUID uuid) {
        return this.delegate.get(this).getEntity(uuid);
    }

    @Override
    public void setCreateCopy(boolean createCopy) {
        this.createCopy = createCopy;
    }

    @Override
    public boolean isCreateCopy() {
        return this.createCopy;
    }

    @Override
    public void setLightingToGet(char[][] lighting) {
        this.delegate.setLightingToGet(this, lighting);
    }

    @Override
    public void setSkyLightingToGet(char[][] lighting) {
        this.delegate.setSkyLightingToGet(this, lighting);
    }

    @Override
    public void setHeightmapToGet(HeightMapType type, int[] data) {
        this.delegate.setHeightmapToGet(this, type, data);
    }

    public void flushLightToGet(boolean heightmaps) {
        this.delegate.flushLightToGet(this, heightmaps);
    }

    @Override
    public Map<BlockVector3, CompoundTag> getTiles() {
        return this.delegate.get(this).getTiles();
    }

    @Override
    public Set<CompoundTag> getEntities() {
        return this.delegate.get(this).getEntities();
    }

    @Override
    public boolean hasSection(int layer) {
        return this.chunkExisting != null && this.chunkExisting.hasSection(layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filterBlocks(Filter filter, ChunkFilterBlock block, @Nullable Region region, boolean full) {
        IChunkGet get = this.getOrCreateGet();
        IChunkSet set = this.getOrCreateSet();
        set.setFastMode(this.fastmode);
        try {
            block.filter(this, get, set, filter, region, full);
        }
        finally {
            filter.finishChunk(this);
        }
    }

    @Override
    public boolean trim(boolean aggressive) {
        boolean result;
        if (this.chunkSet != null && (result = this.chunkSet.trim(aggressive))) {
            this.delegate = NULL;
            this.chunkExisting = null;
            this.chunkSet = null;
            return true;
        }
        if (aggressive) {
            this.chunkExisting = null;
            if (this.delegate == BOTH) {
                this.delegate = SET;
            } else if (this.delegate == GET) {
                this.delegate = NULL;
            }
        } else {
            this.chunkExisting.trim(false);
        }
        return false;
    }

    @Override
    public boolean trim(boolean aggressive, int layer) {
        return this.trim(aggressive);
    }

    @Override
    public boolean isEmpty() {
        return this.chunkSet == null || this.chunkSet.isEmpty();
    }

    public final IChunkGet getOrCreateGet() {
        if (this.chunkExisting == null) {
            this.chunkExisting = this.newWrappedGet();
        }
        return this.chunkExisting;
    }

    public final IChunkSet getOrCreateSet() {
        if (this.chunkSet == null) {
            this.chunkSet = this.newWrappedSet();
        }
        return this.chunkSet;
    }

    private IChunkSet newWrappedSet() {
        return this.extent.getCachedSet(this.chunkX, this.chunkZ);
    }

    private IChunkGet newWrappedGet() {
        return this.extent.getCachedGet(this.chunkX, this.chunkZ);
    }

    @Override
    public <V extends IChunk> void init(IQueueExtent<V> extent, int chunkX, int chunkZ) {
        this.extent = extent;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        if (this.chunkSet != null) {
            this.chunkSet.reset();
            this.delegate = SET;
        } else {
            this.delegate = NULL;
        }
        this.chunkExisting = null;
        this.isInit = true;
    }

    @Override
    public synchronized T call() {
        if (this.chunkSet != null) {
            this.chunkSet.setBitMask(this.bitMask);
            return this.call(this.chunkSet, this::recycle);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call(IChunkSet set, Runnable finalize) {
        if (set != null) {
            IChunkGet get = this.getOrCreateGet();
            get.trim(false);
            boolean postProcess = !(this.getExtent().getPostProcessor() instanceof EmptyBatchProcessor);
            get.setCreateCopy(postProcess);
            set = this.getExtent().processSet(this, get, set);
            try {
                Object t = get.call(set, finalize);
                return t;
            }
            finally {
                if (postProcess) {
                    this.getExtent().postProcessSet(this, get.getCopy(), set);
                }
            }
        }
        return null;
    }

    public IQueueExtent<? extends IChunk> getExtent() {
        return this.extent;
    }

    @Override
    public int getX() {
        return this.chunkX;
    }

    @Override
    public int getZ() {
        return this.chunkZ;
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        return this.delegate.setBiome(this, x, y, z, biome);
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(int x, int y, int z, B block) {
        return this.delegate.setBlock(this, x, y, z, block);
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        return this.delegate.getBiome(this, x, y, z);
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return this.delegate.getBlock(this, x, y, z);
    }

    @Override
    public BaseBlock getFullBlock(int x, int y, int z) {
        return this.delegate.getFullBlock(this, x, y, z);
    }

    @Override
    public void setSkyLight(int x, int y, int z, int value) {
        this.delegate.setSkyLight(this, x, y, z, value);
    }

    @Override
    public void setHeightMap(HeightMapType type, int[] heightMap) {
        this.delegate.setHeightMap(this, type, heightMap);
    }

    @Override
    public void removeSectionLighting(int layer, boolean sky) {
        this.delegate.removeSectionLighting(this, layer, sky);
    }

    @Override
    public void setFullBright(int layer) {
        this.delegate.setFullBright(this, layer);
    }

    @Override
    public void setBlockLight(int x, int y, int z, int value) {
        this.delegate.setBlockLight(this, x, y, z, value);
    }

    @Override
    public void setLightLayer(int layer, char[] toSet) {
        this.delegate.setLightLayer(this, layer, toSet);
    }

    @Override
    public void setSkyLightLayer(int layer, char[] toSet) {
        this.delegate.setSkyLightLayer(this, layer, toSet);
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        return this.delegate.getSkyLight(this, x, y, z);
    }

    @Override
    public int getEmmittedLight(int x, int y, int z) {
        return this.delegate.getEmmittedLight(this, x, y, z);
    }

    @Override
    public int getBrightness(int x, int y, int z) {
        return this.delegate.getBrightness(this, x, y, z);
    }

    @Override
    public int getOpacity(int x, int y, int z) {
        return this.delegate.getOpacity(this, x, y, z);
    }

    @Override
    public int[] getHeightMap(HeightMapType type) {
        return this.delegate.getHeightMap(this, type);
    }

    public static interface IBlockDelegate {
        public <C extends Future<C>> IChunkGet get(ChunkHolder<C> var1);

        public IChunkSet set(ChunkHolder var1);

        public boolean setBiome(ChunkHolder var1, int var2, int var3, int var4, BiomeType var5);

        public <T extends BlockStateHolder<T>> boolean setBlock(ChunkHolder var1, int var2, int var3, int var4, T var5);

        public BiomeType getBiome(ChunkHolder var1, int var2, int var3, int var4);

        public BlockState getBlock(ChunkHolder var1, int var2, int var3, int var4);

        public BaseBlock getFullBlock(ChunkHolder var1, int var2, int var3, int var4);

        public void setSkyLight(ChunkHolder var1, int var2, int var3, int var4, int var5);

        public void setBlockLight(ChunkHolder var1, int var2, int var3, int var4, int var5);

        public void removeSectionLighting(ChunkHolder var1, int var2, boolean var3);

        public void setFullBright(ChunkHolder var1, int var2);

        public void setLightLayer(ChunkHolder var1, int var2, char[] var3);

        public void setSkyLightLayer(ChunkHolder var1, int var2, char[] var3);

        public void setHeightMap(ChunkHolder var1, HeightMapType var2, int[] var3);

        public int getSkyLight(ChunkHolder var1, int var2, int var3, int var4);

        public int getEmmittedLight(ChunkHolder var1, int var2, int var3, int var4);

        public int getBrightness(ChunkHolder var1, int var2, int var3, int var4);

        public int getOpacity(ChunkHolder var1, int var2, int var3, int var4);

        public int[] getHeightMap(ChunkHolder var1, HeightMapType var2);

        public void flushLightToGet(ChunkHolder var1, boolean var2);

        public void setLightingToGet(ChunkHolder var1, char[][] var2);

        public void setSkyLightingToGet(ChunkHolder var1, char[][] var2);

        public void setHeightmapToGet(ChunkHolder var1, HeightMapType var2, int[] var3);
    }
}

