/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.beta.implementation.filter;

import com.boydti.fawe.beta.Filter;
import com.boydti.fawe.beta.implementation.filter.block.DelegateFilter;
import com.boydti.fawe.beta.implementation.filter.block.FilterBlock;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.Mask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class MaskFilter<T extends Filter>
extends DelegateFilter<T> {
    private final Supplier<Mask> supplier;
    private final Mask mask;
    private final AtomicInteger changes;

    public MaskFilter(T other, Mask mask) {
        this(other, () -> mask);
    }

    public MaskFilter(T other, Supplier<Mask> supplier) {
        this(other, supplier, supplier.get());
    }

    public MaskFilter(T other, Supplier<Mask> supplier, Mask root) {
        this(other, supplier, root, new AtomicInteger());
    }

    public MaskFilter(T other, Supplier<Mask> supplier, Mask root, AtomicInteger changes) {
        super(other);
        this.supplier = supplier;
        this.mask = root;
        this.changes = changes;
    }

    @Override
    public void applyBlock(FilterBlock block) {
        if (this.mask instanceof AbstractExtentMask) {
            if (((AbstractExtentMask)this.mask).test(block, block)) {
                this.getParent().applyBlock(block);
                this.changes.incrementAndGet();
            }
        } else if (this.mask.test(block)) {
            this.getParent().applyBlock(block);
            this.changes.incrementAndGet();
        }
    }

    public int getBlocksApplied() {
        return this.changes.get();
    }

    @Override
    public MaskFilter<?> newInstance(Filter other) {
        return new MaskFilter<Filter>(other, this.supplier);
    }

    @Override
    public Filter fork() {
        return new MaskFilter<Filter>(this.getParent().fork(), this.mask::copy, this.mask.copy(), this.changes);
    }
}

