/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.beta.implementation.filter.block;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.Filter;
import com.boydti.fawe.beta.FilterBlockMask;
import com.boydti.fawe.beta.Flood;
import com.boydti.fawe.beta.IBlocks;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.beta.IChunkSet;
import com.boydti.fawe.beta.implementation.blocks.CharGetBlocks;
import com.boydti.fawe.beta.implementation.filter.block.ChunkFilterBlock;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class CharFilterBlock
extends ChunkFilterBlock {
    private static final SetDelegate FULL = (block, value) -> {
        block.setArr[block.index] = value;
    };
    private static final SetDelegate NULL = (block, value) -> block.initSet().set(block, value);
    private CharGetBlocks get;
    private IChunkSet set;
    private char[] getArr;
    @Nullable
    private char[] setArr;
    private SetDelegate delegate;
    private int layer;
    private int index;
    private int x;
    private int y;
    private int z;
    private int xx;
    private int yy;
    private int zz;
    private int chunkX;
    private int chunkZ;

    public CharFilterBlock(Extent extent) {
        super(extent);
    }

    @Override
    public final ChunkFilterBlock initChunk(int chunkX, int chunkZ) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.xx = chunkX << 4;
        this.zz = chunkZ << 4;
        return this;
    }

    @Override
    public final ChunkFilterBlock initLayer(IBlocks iget, IChunkSet iset, int layer) {
        this.get = (CharGetBlocks)iget;
        this.layer = layer;
        this.getArr = !iget.hasSection(layer) ? FaweCache.IMP.EMPTY_CHAR_4096 : iget.load(layer);
        this.set = iset;
        if (this.set.hasSection(layer)) {
            this.setArr = this.set.load(layer);
            this.delegate = FULL;
        } else {
            this.delegate = NULL;
            this.setArr = null;
        }
        this.yy = layer << 4;
        return this;
    }

    @Override
    public void flood(IChunkGet iget, IChunkSet iset, int layer, Flood flood, FilterBlockMask mask) {
        boolean checkDepth;
        int maxDepth = flood.getMaxDepth();
        boolean bl = checkDepth = maxDepth < 65535;
        if (this.initLayer(iget, iset, layer) != null) {
            while ((this.index = flood.poll()) != -1) {
                this.x = this.index & 0xF;
                this.z = this.index >> 4 & 0xF;
                this.y = this.index >> 8 & 0xF;
                if (!mask.applyBlock(this)) continue;
                int depth = this.index >> 12;
                if (checkDepth && depth > maxDepth) continue;
                flood.apply(this.x, this.y, this.z, depth);
            }
        }
    }

    @Override
    public void filter(Filter filter, int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.index = x | z << 4 | y << 8;
        filter.applyBlock(this);
    }

    @Override
    public void filter(Filter filter, int startY, int endY) {
        this.y = startY;
        this.index = startY << 8;
        while (this.y <= endY) {
            this.z = 0;
            while (this.z < 16) {
                this.x = 0;
                while (this.x < 16) {
                    filter.applyBlock(this);
                    ++this.x;
                    ++this.index;
                }
                ++this.z;
            }
            ++this.y;
        }
    }

    @Override
    public void filter(Filter filter, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int yis = minY << 8;
        int zis = minZ << 4;
        int zie = 15 - maxZ << 4;
        int xie = 15 - maxX;
        this.y = minY;
        this.index = yis;
        while (this.y <= maxY) {
            this.index += zis;
            this.z = minZ;
            while (this.z <= maxZ) {
                this.index += minX;
                this.x = minX;
                while (this.x <= maxX) {
                    filter.applyBlock(this);
                    ++this.x;
                    ++this.index;
                }
                this.index += xie;
                ++this.z;
            }
            this.index += zie;
            ++this.y;
        }
    }

    @Override
    public final void filter(Filter filter, Region region) {
        this.y = 0;
        this.index = 0;
        while (this.y < 16) {
            int absY = this.yy + this.y;
            this.z = 0;
            while (this.z < 16) {
                int absZ = this.zz + this.z;
                this.x = 0;
                while (this.x < 16) {
                    int absX = this.xx + this.x;
                    if (region.contains(absX, absY, absZ)) {
                        filter.applyBlock(this);
                    }
                    ++this.x;
                    ++this.index;
                }
                ++this.z;
            }
            ++this.y;
        }
    }

    @Override
    public final void filter(Filter filter) {
        this.y = 0;
        this.index = 0;
        while (this.y < 16) {
            this.z = 0;
            while (this.z < 16) {
                this.x = 0;
                while (this.x < 16) {
                    filter.applyBlock(this);
                    ++this.x;
                    ++this.index;
                }
                ++this.z;
            }
            ++this.y;
        }
    }

    @Override
    public void setBiome(BiomeType biome) {
        this.set.setBiome(this.x, this.y, this.z, biome);
    }

    @Override
    public final int getX() {
        return this.xx + this.x;
    }

    @Override
    public final int getY() {
        return this.yy + this.y;
    }

    @Override
    public final int getZ() {
        return this.zz + this.z;
    }

    @Override
    public final int getLocalX() {
        return this.x;
    }

    @Override
    public final int getLocalY() {
        return this.y;
    }

    @Override
    public final int getLocalZ() {
        return this.z;
    }

    @Override
    public final int getChunkX() {
        return this.chunkX;
    }

    @Override
    public final int getChunkZ() {
        return this.chunkZ;
    }

    public final char getOrdinalChar() {
        return this.getArr[this.index];
    }

    @Override
    public final int getOrdinal() {
        return this.getArr[this.index];
    }

    @Override
    public void setOrdinal(int ordinal) {
        this.delegate.set(this, (char)ordinal);
    }

    @Override
    public final BlockState getBlock() {
        char ordinal = this.getArr[this.index];
        return BlockTypesCache.states[ordinal];
    }

    @Override
    public void setBlock(BlockState state) {
        this.delegate.set(this, state.getOrdinalChar());
    }

    @Override
    public final BaseBlock getFullBlock() {
        BlockState state = this.getBlock();
        BlockMaterial material = state.getMaterial();
        if (material.hasContainer()) {
            CompoundTag tag = this.get.getTile(this.x, this.y + this.yy, this.z);
            return state.toBaseBlock(tag);
        }
        return state.toBaseBlock();
    }

    @Override
    public void setFullBlock(BaseBlock block) {
        this.delegate.set(this, block.getOrdinalChar());
        CompoundTag nbt = block.getNbtData();
        if (nbt != null) {
            this.set.setTile(this.x, this.yy + this.y, this.z, nbt);
        }
    }

    @Override
    public final CompoundTag getNbtData() {
        return this.get.getTile(this.x, this.y + this.yy, this.z);
    }

    @Override
    public void setNbtData(CompoundTag tag) {
        if (tag != null) {
            this.set.setTile(this.x, this.y + this.yy, this.z, tag);
        }
    }

    @Override
    public boolean hasNbtData() {
        BlockState state = this.getBlock();
        BlockMaterial material = state.getMaterial();
        return material.hasContainer();
    }

    @Override
    public final BlockState getBlockNorth() {
        if (this.z > 0) {
            return BlockTypesCache.states[this.getArr[this.index - 16]];
        }
        return this.getExtent().getBlock(this.getX(), this.getY(), this.getZ() - 1);
    }

    @Override
    public final BlockState getBlockEast() {
        if (this.x < 15) {
            return BlockTypesCache.states[this.getArr[this.index + 1]];
        }
        return this.getExtent().getBlock(this.getX() + 1, this.getY(), this.getZ());
    }

    @Override
    public final BlockState getBlockSouth() {
        if (this.z < 15) {
            return BlockTypesCache.states[this.getArr[this.index + 16]];
        }
        return this.getExtent().getBlock(this.getX(), this.getY(), this.getZ() + 1);
    }

    @Override
    public final BlockState getBlockWest() {
        if (this.x > 0) {
            return BlockTypesCache.states[this.getArr[this.index - 1]];
        }
        return this.getExtent().getBlock(this.getX() - 1, this.getY(), this.getZ());
    }

    @Override
    public final BlockState getBlockBelow() {
        if (this.y > 0) {
            return BlockTypesCache.states[this.getArr[this.index - 256]];
        }
        if (this.layer > 0) {
            int newLayer = this.layer - 1;
            CharGetBlocks chunk = this.get;
            return BlockTypesCache.states[chunk.sections[newLayer].get(chunk, newLayer, this.index + 3840)];
        }
        return BlockTypes.__RESERVED__.getDefaultState();
    }

    @Override
    public final BlockState getBlockAbove() {
        if (this.y < 16) {
            return BlockTypesCache.states[this.getArr[this.index + 256]];
        }
        if (this.layer < 16) {
            int newLayer = this.layer + 1;
            CharGetBlocks chunk = this.get;
            return BlockTypesCache.states[chunk.sections[newLayer].get(chunk, newLayer, this.index - 3840)];
        }
        return BlockTypes.__RESERVED__.getDefaultState();
    }

    @Override
    public final BlockState getBlockRelativeY(int y) {
        int newY = this.y + y;
        int layerAdd = newY >> 4;
        switch (layerAdd) {
            case 0: {
                return BlockTypesCache.states[this.getArr[this.index + (y << 8)]];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                int newLayer = this.layer + layerAdd;
                if (newLayer >= 16) break;
                int index = this.index + ((y & 0xF) << 8);
                return BlockTypesCache.states[this.get.sections[newLayer].get(this.get, newLayer, index)];
            }
            case -15: 
            case -14: 
            case -13: 
            case -12: 
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                int newLayer = this.layer + layerAdd;
                if (newLayer < 0) break;
                int index = this.index + ((y & 0xF) << 8);
                return BlockTypesCache.states[this.get.sections[newLayer].get(this.get, newLayer, index)];
            }
        }
        return BlockTypes.__RESERVED__.getDefaultState();
    }

    @Override
    public char getOrdinalChar(Extent orDefault) {
        return this.getOrdinalChar();
    }

    private SetDelegate initSet() {
        this.setArr = this.set.load(this.layer);
        this.delegate = FULL;
        return this.delegate;
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        if (x >> 4 == this.chunkX && z >> 4 == this.chunkZ) {
            return this.get.getBiomeType(x & 0xF, y, z & 0xF);
        }
        return this.getExtent().getBiomeType(x, y, z);
    }

    public <T extends BlockStateHolder<T>> boolean setBlock(int x, int y, int z, T block) throws WorldEditException {
        return this.getExtent().setBlock(x, y, z, block);
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        return this.setBiome(position.getX(), position.getY(), position.getBlockZ(), biome);
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        if (x >> 4 == this.chunkX && z >> 4 == this.chunkZ) {
            return this.set.setBiome(x & 0xF, y, z & 0xF, biome);
        }
        return this.getExtent().setBiome(x, y, z, biome);
    }

    private static interface SetDelegate {
        public void set(@NotNull CharFilterBlock var1, char var2);
    }
}

