/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.beta.implementation.processors;

import com.boydti.fawe.beta.CombinedBlocks;
import com.boydti.fawe.beta.IBlocks;
import com.boydti.fawe.beta.IChunk;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.beta.IChunkSet;
import com.boydti.fawe.beta.implementation.IChunkExtent;
import com.boydti.fawe.beta.implementation.packet.ChunkPacket;
import com.boydti.fawe.beta.implementation.processors.ChunkSendProcessor;
import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.bukkit.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import com.sk89q.worldedit.bukkit.fastutil.longs.Long2ObjectMap;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.world.World;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class PersistentChunkSendProcessor
extends ChunkSendProcessor {
    private final Long2ObjectLinkedOpenHashMap<Character> current = new Long2ObjectLinkedOpenHashMap();
    @Nullable
    private Long2ObjectLinkedOpenHashMap<Character> previous;
    private IChunkExtent queue;

    public PersistentChunkSendProcessor(World world, PersistentChunkSendProcessor previous, Supplier<Collection<Player>> players) {
        super(world, players);
        this.previous = previous != null ? previous.current : null;
    }

    public void init(IChunkExtent queue) {
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBlocks combine(IChunk chunk, IChunkGet get, IChunkSet set) {
        int chunkX = chunk.getX();
        int chunkZ = chunk.getZ();
        long pair = MathMan.pairInt(chunkX, chunkZ);
        char bitMask = (char)(set.hasBiomes() ? 65535 : set.getBitMask());
        PersistentChunkSendProcessor persistentChunkSendProcessor = this;
        synchronized (persistentChunkSendProcessor) {
            Character lastValue;
            this.current.put(pair, Character.valueOf(bitMask));
            if (this.previous != null && (lastValue = this.previous.remove(pair)) != null) {
                bitMask = (char)(bitMask | lastValue.charValue());
            }
        }
        return new CombinedBlocks(get, set, bitMask);
    }

    @Override
    public void flush() {
        this.clear(this.previous);
        this.previous = null;
    }

    public void clear() {
        if (this.queue == null) {
            throw new IllegalStateException("Queue is not provided");
        }
        this.clear(this.current);
        this.current.clear();
        this.queue = null;
    }

    public void clear(Long2ObjectLinkedOpenHashMap<Character> current) {
        if (current != null && !current.isEmpty()) {
            Collection<Player> players = this.getPlayers().get();
            for (Long2ObjectMap.Entry entry : current.long2ObjectEntrySet()) {
                long pair = entry.getLongKey();
                int chunkX = MathMan.unpairIntX(pair);
                int chunkZ = MathMan.unpairIntY(pair);
                BlockVector2 pos = BlockVector2.at(chunkX, chunkZ);
                Supplier<IBlocks> chunk = () -> this.queue.getOrCreateChunk(pos.getX(), pos.getZ());
                ChunkPacket packet = new ChunkPacket(pos.getX(), pos.getZ(), chunk, true);
                char bitMask = ((Character)entry.getValue()).charValue();
                if (players == null) {
                    this.getWorld().sendFakeChunk(null, packet);
                    continue;
                }
                players.forEach(player -> this.getWorld().sendFakeChunk((Player)player, packet));
            }
        }
    }
}

