/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.beta.implementation.queue;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.Filter;
import com.boydti.fawe.beta.IQueueChunk;
import com.boydti.fawe.beta.IQueueExtent;
import com.boydti.fawe.beta.IQueueWrapper;
import com.boydti.fawe.beta.implementation.filter.CountFilter;
import com.boydti.fawe.beta.implementation.filter.DistrFilter;
import com.boydti.fawe.beta.implementation.filter.LinkedFilter;
import com.boydti.fawe.beta.implementation.filter.block.ChunkFilterBlock;
import com.boydti.fawe.beta.implementation.processors.BatchProcessorHolder;
import com.boydti.fawe.beta.implementation.queue.QueueHandler;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.clipboard.WorldCopyClipboard;
import com.boydti.fawe.object.extent.NullExtent;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.PassthroughExtent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.BlockMask;
import com.sk89q.worldedit.function.mask.BlockMaskBuilder;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Countable;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.IntStream;

public class ParallelQueueExtent
extends PassthroughExtent
implements IQueueWrapper {
    private final World world;
    private final QueueHandler handler;
    private final BatchProcessorHolder processor;
    private final BatchProcessorHolder postProcessor;
    private int changes;
    private final boolean fastmode;

    public ParallelQueueExtent(QueueHandler handler, World world, boolean fastmode) {
        super(handler.getQueue(world, new BatchProcessorHolder(), new BatchProcessorHolder()));
        this.world = world;
        this.handler = handler;
        this.processor = (BatchProcessorHolder)this.getExtent().getProcessor();
        this.postProcessor = (BatchProcessorHolder)this.getExtent().getPostProcessor();
        this.fastmode = fastmode;
    }

    @Override
    public IQueueExtent<IQueueChunk> getExtent() {
        return (IQueueExtent)super.getExtent();
    }

    @Override
    public boolean cancel() {
        if (super.cancel()) {
            this.processor.setProcessor(new NullExtent((Extent)this, FaweCache.MANUAL));
            this.postProcessor.setPostProcessor(new NullExtent((Extent)this, FaweCache.MANUAL));
            return true;
        }
        return false;
    }

    private IQueueExtent<IQueueChunk> getNewQueue() {
        return this.wrapQueue(this.handler.getQueue(this.world, this.processor, this.postProcessor));
    }

    @Override
    public IQueueExtent<IQueueChunk> wrapQueue(IQueueExtent<IQueueChunk> queue) {
        queue.setProcessor(this.processor);
        queue.setPostProcessor(this.postProcessor);
        return queue;
    }

    @Override
    public <T extends Filter> T apply(Region region, T filter, boolean full) {
        Set<BlockVector2> chunks = region.getChunks();
        Iterator<BlockVector2> chunksIter = chunks.iterator();
        int size = Math.min(chunks.size(), Settings.IMP.QUEUE.PARALLEL_THREADS);
        if (size <= 1 && chunksIter.hasNext()) {
            BlockVector2 pos = chunksIter.next();
            this.getExtent().apply(null, filter, region, pos.getX(), pos.getZ(), full);
        } else {
            ForkJoinTask[] tasks;
            for (ForkJoinTask task : tasks = (ForkJoinTask[])IntStream.range(0, size).mapToObj(i -> this.handler.submit(() -> {
                try {
                    Filter newFilter = filter.fork();
                    IQueueExtent<IQueueChunk> queue = this.getNewQueue();
                    queue.setFastMode(this.fastmode);
                    IQueueExtent<IQueueChunk> iQueueExtent = queue;
                    synchronized (iQueueExtent) {
                        ChunkFilterBlock block = null;
                        while (true) {
                            int chunkZ;
                            int chunkX;
                            Iterator iterator = chunksIter;
                            synchronized (iterator) {
                                if (!chunksIter.hasNext()) {
                                    break;
                                }
                                BlockVector2 pos = (BlockVector2)chunksIter.next();
                                chunkX = pos.getX();
                                chunkZ = pos.getZ();
                            }
                            block = queue.apply(block, newFilter, region, chunkX, chunkZ, full);
                        }
                        queue.flush();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            })).toArray(ForkJoinTask[]::new)) {
                if (task == null) continue;
                task.quietlyJoin();
            }
            filter.join();
        }
        return filter;
    }

    @Override
    public int countBlocks(Region region, Mask searchMask) {
        return ((CountFilter)this.apply(region, searchMask.toFilter(new CountFilter()), searchMask.replacesAir()).getParent()).getTotal();
    }

    @Override
    public <B extends BlockStateHolder<B>> int setBlocks(Region region, B block) throws MaxChangedBlocksException {
        this.changes = ((CountFilter)this.apply(region, new BlockMaskBuilder().add(block).build(this).toFilter(new CountFilter())).getParent()).getTotal();
        return this.changes;
    }

    @Override
    public int setBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
        this.changes = this.apply(region, new LinkedFilter<Pattern, CountFilter>(pattern, new CountFilter()), true).getChild().getTotal();
        return this.changes;
    }

    @Override
    public int setBlocks(Set<BlockVector3> vset, Pattern pattern) {
        if (vset instanceof Region) {
            this.changes = this.setBlocks((Region)((Object)vset), pattern);
        }
        for (BlockVector3 blockVector3 : vset) {
            if (!pattern.apply(this, blockVector3, blockVector3)) continue;
            ++this.changes;
        }
        return this.changes;
    }

    @Override
    public int replaceBlocks(Region region, Mask mask, Pattern pattern) throws MaxChangedBlocksException {
        boolean full = mask.replacesAir();
        this.changes = this.apply(region, mask.toFilter(pattern), full).getBlocksApplied();
        return this.changes;
    }

    @Override
    public List<Countable<BlockState>> getBlockDistributionWithData(Region region) {
        return this.apply(region, new DistrFilter(), true).getDistribution();
    }

    @Override
    public List<Countable<BlockType>> getBlockDistribution(Region region) {
        return this.apply(region, new DistrFilter(), true).getTypeDistribution();
    }

    @Override
    public Clipboard lazyCopy(Region region) {
        WorldCopyClipboard clipboard = new WorldCopyClipboard(() -> this, region);
        clipboard.setOrigin(region.getMinimumPoint());
        return clipboard;
    }

    @Override
    public int countBlocks(Region region, Set<BaseBlock> searchBlocks) {
        BlockMask mask = new BlockMask((Extent)this, searchBlocks);
        return this.countBlocks(region, mask);
    }

    @Override
    public <B extends BlockStateHolder<B>> int replaceBlocks(Region region, Set<BaseBlock> filter, B replacement) throws MaxChangedBlocksException {
        return this.replaceBlocks(region, filter, (Pattern)new BlockPattern(replacement));
    }

    @Override
    public int replaceBlocks(Region region, Set<BaseBlock> filter, Pattern pattern) throws MaxChangedBlocksException {
        AbstractExtentMask mask = filter == null ? new ExistingBlockMask(this) : new BlockMask((Extent)this, filter);
        return this.replaceBlocks(region, mask, pattern);
    }
}

