/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.beta.implementation.queue;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.beta.IChunk;
import com.boydti.fawe.beta.IChunkCache;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.beta.IChunkSet;
import com.boydti.fawe.beta.IQueueChunk;
import com.boydti.fawe.beta.IQueueExtent;
import com.boydti.fawe.beta.implementation.blocks.CharSetBlocks;
import com.boydti.fawe.beta.implementation.chunk.ChunkHolder;
import com.boydti.fawe.beta.implementation.chunk.NullChunk;
import com.boydti.fawe.beta.implementation.filter.block.CharFilterBlock;
import com.boydti.fawe.beta.implementation.filter.block.ChunkFilterBlock;
import com.boydti.fawe.beta.implementation.processors.EmptyBatchProcessor;
import com.boydti.fawe.beta.implementation.processors.ExtentBatchProcessorHolder;
import com.boydti.fawe.beta.implementation.processors.ProcessorScope;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.MemUtil;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.sk89q.worldedit.bukkit.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;

public class SingleThreadQueueExtent
extends ExtentBatchProcessorHolder
implements IQueueExtent<IQueueChunk> {
    private static final Logger log = LoggerFactory.getLogger("SingleThreadQueueExtent");
    private final Long2ObjectLinkedOpenHashMap<IQueueChunk> chunks = new Long2ObjectLinkedOpenHashMap();
    private IChunkCache<IChunkGet> cacheGet;
    private IChunkCache<IChunkSet> cacheSet;
    private boolean initialized;
    private Thread currentThread;
    private ConcurrentLinkedQueue<Future> submissions = new ConcurrentLinkedQueue();
    private IQueueChunk lastChunk;
    private long lastPair = Long.MAX_VALUE;
    private boolean enabledQueue = true;
    private boolean fastmode = false;
    private final ReentrantLock getChunkLock = new ReentrantLock();

    private void checkThread() {
        if (Thread.currentThread() != this.currentThread && this.currentThread != null) {
            throw new UnsupportedOperationException("This class must be used from a single thread. Use multiple queues for concurrent operations");
        }
    }

    @Override
    public void enableQueue() {
        this.enabledQueue = true;
    }

    @Override
    public void disableQueue() {
        this.enabledQueue = false;
    }

    @Override
    public IChunkGet getCachedGet(int chunkX, int chunkZ) {
        return this.cacheGet.get(chunkX, chunkZ);
    }

    @Override
    public IChunkSet getCachedSet(int chunkX, int chunkZ) {
        return this.cacheSet.get(chunkX, chunkZ);
    }

    @Override
    public void setFastMode(boolean fastmode) {
        this.fastmode = fastmode;
    }

    @Override
    public boolean isFastMode() {
        return this.fastmode;
    }

    protected synchronized void reset() {
        if (!this.initialized) {
            return;
        }
        if (!this.chunks.isEmpty()) {
            for (IChunk chunk : this.chunks.values()) {
                chunk.recycle();
            }
            this.getChunkLock.lock();
            this.chunks.clear();
            this.getChunkLock.unlock();
        }
        this.enabledQueue = true;
        this.lastChunk = null;
        this.lastPair = Long.MAX_VALUE;
        this.currentThread = null;
        this.initialized = false;
        this.setProcessor(EmptyBatchProcessor.getInstance());
        this.setPostProcessor(EmptyBatchProcessor.getInstance());
    }

    @Override
    public synchronized void init(Extent extent, IChunkCache<IChunkGet> get, IChunkCache<IChunkSet> set) {
        this.reset();
        this.currentThread = Thread.currentThread();
        if (get == null) {
            get = (x, z) -> {
                throw new UnsupportedOperationException();
            };
        }
        if (set == null) {
            set = (x, z) -> CharSetBlocks.newInstance();
        }
        this.cacheGet = get;
        this.cacheSet = set;
        this.setProcessor(EmptyBatchProcessor.getInstance());
        this.setPostProcessor(EmptyBatchProcessor.getInstance());
        this.initialized = true;
    }

    @Override
    public int size() {
        return this.chunks.size() + this.submissions.size();
    }

    @Override
    public boolean isEmpty() {
        return this.chunks.isEmpty() && this.submissions.isEmpty();
    }

    @Override
    public <V extends Future<V>> V submit(IQueueChunk chunk) {
        if (this.lastChunk == chunk) {
            this.lastPair = Long.MAX_VALUE;
            this.lastChunk = null;
        }
        long index = MathMan.pairInt(chunk.getX(), chunk.getZ());
        this.getChunkLock.lock();
        this.chunks.remove(index, (Object)chunk);
        this.getChunkLock.unlock();
        V future = this.submitUnchecked(chunk);
        this.submissions.add((Future)future);
        return future;
    }

    private <V extends Future<V>> V submitUnchecked(IQueueChunk chunk) {
        if (chunk.isEmpty()) {
            chunk.recycle();
            ListenableFuture result = Futures.immediateFuture(null);
            return (V)result;
        }
        if (Fawe.isMainThread()) {
            Object result = chunk.call();
            if (result == null) {
                return (V)Futures.immediateFuture(null);
            }
            return (V)result;
        }
        return (V)Fawe.get().getQueueHandler().submit(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean trim(boolean aggressive) {
        this.cacheGet.trim(aggressive);
        this.cacheSet.trim(aggressive);
        if (Thread.currentThread() == this.currentThread) {
            this.lastChunk = null;
            this.lastPair = Long.MAX_VALUE;
            return this.chunks.isEmpty();
        }
        if (!this.submissions.isEmpty()) {
            if (aggressive) {
                this.pollSubmissions(0, aggressive);
            } else {
                this.pollSubmissions(Settings.IMP.QUEUE.PARALLEL_THREADS, aggressive);
            }
        }
        SingleThreadQueueExtent singleThreadQueueExtent = this;
        synchronized (singleThreadQueueExtent) {
            return this.currentThread == null;
        }
    }

    private ChunkHolder poolOrCreate(int chunkX, int chunkZ) {
        ChunkHolder next = this.create(false);
        next.init(this, chunkX, chunkZ);
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IQueueChunk getOrCreateChunk(int x, int z) {
        this.getChunkLock.lock();
        try {
            Object future;
            long pair = (long)x << 32 | (long)z & 0xFFFFFFFFL;
            if (pair == this.lastPair) {
                IQueueChunk iQueueChunk = this.lastChunk;
                return iQueueChunk;
            }
            if (!this.processGet(x, z)) {
                this.lastPair = pair;
                this.lastChunk = NullChunk.getInstance();
                NullChunk nullChunk = NullChunk.getInstance();
                return nullChunk;
            }
            IQueueChunk chunk = this.chunks.get(pair);
            if (chunk != null) {
                this.lastPair = pair;
                this.lastChunk = chunk;
            }
            if (chunk != null) {
                IQueueChunk iQueueChunk = chunk;
                return iQueueChunk;
            }
            int size = this.chunks.size();
            boolean lowMem = MemUtil.isMemoryLimited();
            if (this.enabledQueue && (lowMem && size > Settings.IMP.QUEUE.PARALLEL_THREADS + 8 || size > Settings.IMP.QUEUE.TARGET_SIZE && Fawe.get().getQueueHandler().isUnderutilized()) && (future = this.submitUnchecked(chunk = this.chunks.removeFirst())) != null && !future.isDone()) {
                int targetSize = lowMem ? Settings.IMP.QUEUE.PARALLEL_THREADS + 8 : Settings.IMP.QUEUE.TARGET_SIZE;
                this.pollSubmissions(targetSize, lowMem);
                this.submissions.add((Future)future);
            }
            chunk = this.poolOrCreate(x, z);
            chunk = this.wrap(chunk);
            this.chunks.put(pair, chunk);
            this.lastPair = pair;
            this.lastChunk = chunk;
            IQueueChunk iQueueChunk = chunk;
            return iQueueChunk;
        }
        finally {
            this.getChunkLock.unlock();
        }
    }

    @Override
    public ChunkHolder create(boolean isFull) {
        return ChunkHolder.newInstance();
    }

    private void pollSubmissions(int targetSize, boolean aggressive) {
        int overflow = this.submissions.size() - targetSize;
        if (aggressive) {
            if (targetSize == 0) {
                while (!this.submissions.isEmpty()) {
                    try {
                        for (Future future = this.submissions.poll(); future != null; future = (Future)future.get()) {
                        }
                    }
                    catch (FaweException messageOnly) {
                        log.warn(messageOnly.getMessage());
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() instanceof FaweException) {
                            log.warn(e.getCause().getClass().getCanonicalName() + ": " + e.getCause().getMessage());
                            continue;
                        }
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            for (int i = 0; i < overflow; ++i) {
                try {
                    for (Future first = this.submissions.poll(); first != null; first = (Future)first.get()) {
                    }
                    continue;
                }
                catch (FaweException messageOnly) {
                    log.warn(messageOnly.getMessage());
                    continue;
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof FaweException) {
                        log.warn(e.getCause().getClass().getCanonicalName() + ": " + e.getCause().getMessage());
                        continue;
                    }
                    e.printStackTrace();
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (int i = 0; i < overflow; ++i) {
                Future next = this.submissions.peek();
                while (next != null) {
                    if (next.isDone()) {
                        try {
                            next = (Future)next.get();
                        }
                        catch (FaweException messageOnly) {
                            log.warn(messageOnly.getMessage());
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() instanceof FaweException) {
                                log.warn(e.getCause().getClass().getCanonicalName() + ": " + e.getCause().getMessage());
                                continue;
                            }
                            e.printStackTrace();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    return;
                }
                this.submissions.poll();
            }
        }
    }

    @Override
    public synchronized void flush() {
        if (!this.chunks.isEmpty()) {
            if (MemUtil.isMemoryLimited()) {
                for (IQueueChunk chunk : this.chunks.values()) {
                    Object future = this.submitUnchecked(chunk);
                    if (future == null || future.isDone()) continue;
                    this.pollSubmissions(Settings.IMP.QUEUE.PARALLEL_THREADS, true);
                    this.submissions.add((Future)future);
                }
            } else {
                for (IQueueChunk chunk : this.chunks.values()) {
                    Object future = this.submitUnchecked(chunk);
                    if (future == null || future.isDone()) continue;
                    this.submissions.add((Future)future);
                }
            }
            this.getChunkLock.lock();
            this.chunks.clear();
            this.getChunkLock.unlock();
        }
        this.pollSubmissions(0, true);
    }

    @Override
    public ChunkFilterBlock initFilterBlock() {
        return new CharFilterBlock(this);
    }

    @Override
    public ProcessorScope getScope() {
        return ProcessorScope.ADDING_BLOCKS;
    }
}

