/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit;

import com.boydti.fawe.FAWEPlatformAdapterImpl;
import com.boydti.fawe.Fawe;
import com.boydti.fawe.IFawe;
import com.boydti.fawe.beta.implementation.cache.preloader.AsyncPreloader;
import com.boydti.fawe.beta.implementation.cache.preloader.Preloader;
import com.boydti.fawe.beta.implementation.queue.QueueHandler;
import com.boydti.fawe.bukkit.adapter.BukkitQueueHandler;
import com.boydti.fawe.bukkit.adapter.NMSAdapter;
import com.boydti.fawe.bukkit.listener.BrushListener;
import com.boydti.fawe.bukkit.listener.BukkitImageListener;
import com.boydti.fawe.bukkit.listener.CFIPacketListener;
import com.boydti.fawe.bukkit.listener.ChunkListener9;
import com.boydti.fawe.bukkit.listener.RenderListener;
import com.boydti.fawe.bukkit.regions.FreeBuildRegion;
import com.boydti.fawe.bukkit.regions.GriefPreventionFeature;
import com.boydti.fawe.bukkit.regions.ResidenceFeature;
import com.boydti.fawe.bukkit.regions.TownyFeature;
import com.boydti.fawe.bukkit.regions.Worldguard;
import com.boydti.fawe.bukkit.regions.plotsquared.PlotSquaredFeature;
import com.boydti.fawe.bukkit.util.BukkitTaskManager;
import com.boydti.fawe.bukkit.util.ItemUtil;
import com.boydti.fawe.bukkit.util.image.BukkitImageViewer;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.util.TaskManager;
import com.boydti.fawe.util.ThirdPartyManager;
import com.boydti.fawe.util.WEManager;
import com.boydti.fawe.util.image.ImageViewer;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.paperlib.PaperLib;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class FaweBukkit
implements IFawe,
Listener {
    private static final Logger log = LoggerFactory.getLogger(FaweBukkit.class);
    private final Plugin plugin;
    private ItemUtil itemUtil;
    private boolean listeningImages;
    private BukkitImageListener imageListener;
    private CFIPacketListener packetListener;
    private final boolean chunksStretched;
    private final FAWEPlatformAdapterImpl platformAdapter;
    private volatile boolean keepUnloaded;

    public FaweBukkit(Plugin plugin) {
        this.plugin = plugin;
        try {
            Settings.IMP.TICK_LIMITER.ENABLED = !Bukkit.hasWhitelist();
            Fawe.set(this);
            Fawe.setupInjector();
            try {
                new BrushListener(plugin);
            }
            catch (Throwable e) {
                log.error("Brush Listener Failed", e);
            }
            if (PaperLib.isPaper() && Settings.IMP.EXPERIMENTAL.DYNAMIC_CHUNK_RENDERING > 1) {
                new RenderListener(plugin);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            Bukkit.getServer().shutdown();
        }
        this.chunksStretched = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].split("\\.")[1]) >= 16;
        this.platformAdapter = new NMSAdapter();
        TaskManager.IMP.later(this::setupPlotSquared, 0);
        TaskManager.IMP.task(() -> {
            Settings.IMP.PROTOCOL_SUPPORT_FIX = Bukkit.getPluginManager().isPluginEnabled("ProtocolSupport");
            Bukkit.getPluginManager().registerEvents((Listener)this, this.plugin);
            new ChunkListener9();
        });
    }

    @Override
    public void registerPacketListener() {
        PluginManager manager = Bukkit.getPluginManager();
        if (this.packetListener == null && manager.getPlugin("ProtocolLib") != null) {
            this.packetListener = new CFIPacketListener(this.plugin);
        }
    }

    @Override
    public QueueHandler getQueueHandler() {
        return new BukkitQueueHandler();
    }

    @Override
    public synchronized ImageViewer getImageViewer(Player player) {
        if (this.listeningImages && this.imageListener == null) {
            return null;
        }
        try {
            Throwable throwable;
            FileOutputStream fos;
            byte[] jarData;
            File output;
            this.listeningImages = true;
            this.registerPacketListener();
            PluginManager manager = Bukkit.getPluginManager();
            if (manager.getPlugin("PacketListenerApi") == null) {
                output = new File(this.plugin.getDataFolder().getParentFile(), "PacketListenerAPI_v3.7.6-SNAPSHOT.jar");
                jarData = ThirdPartyManager.PacketListenerAPI.download();
                fos = new FileOutputStream(output);
                throwable = null;
                try {
                    fos.write(jarData);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fos != null) {
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            fos.close();
                        }
                    }
                }
            }
            if (manager.getPlugin("MapManager") == null) {
                output = new File(this.plugin.getDataFolder().getParentFile(), "MapManager_v1.7.8-SNAPSHOT.jar");
                jarData = ThirdPartyManager.MapManager.download();
                fos = new FileOutputStream(output);
                throwable = null;
                try {
                    fos.write(jarData);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fos != null) {
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            fos.close();
                        }
                    }
                }
            }
            BukkitImageViewer viewer = new BukkitImageViewer(BukkitAdapter.adapt(player));
            if (this.imageListener == null) {
                this.imageListener = new BukkitImageListener(this.plugin);
            }
            return viewer;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public File getDirectory() {
        return this.plugin.getDataFolder();
    }

    public ItemUtil getItemUtil() {
        ItemUtil tmp = this.itemUtil;
        if (tmp == null) {
            try {
                this.itemUtil = tmp = new ItemUtil();
            }
            catch (Throwable e) {
                Settings.IMP.EXPERIMENTAL.PERSISTENT_BRUSHES = false;
                log.error("Persistent Brushes Failed", e);
            }
        }
        return tmp;
    }

    @Override
    public String getDebugInfo() {
        StringBuilder msg = new StringBuilder();
        Plugin[] plugins = Bukkit.getServer().getPluginManager().getPlugins();
        msg.append("Server Version: ").append(Bukkit.getVersion()).append("\n");
        msg.append("Plugins (").append(plugins.length).append("): \n");
        for (Plugin p : plugins) {
            msg.append(" - ").append(p.getName()).append(":").append("\n").append("  \u2022 Version: ").append(p.getDescription().getVersion()).append("\n").append("  \u2022 Enabled: ").append(p.isEnabled()).append("\n").append("  \u2022 Main: ").append(p.getDescription().getMain()).append("\n").append("  \u2022 Authors: ").append(p.getDescription().getAuthors()).append("\n").append("  \u2022 Load Before: ").append(p.getDescription().getLoadBefore()).append("\n").append("  \u2022 Dependencies: ").append(p.getDescription().getDepend()).append("\n").append("  \u2022 Soft Dependencies: ").append(p.getDescription().getSoftDepend()).append("\n").append("  \u2022 Provides: ").append(p.getDescription().getProvides()).append("\n");
        }
        return msg.toString();
    }

    @Override
    public TaskManager getTaskManager() {
        return new BukkitTaskManager(this.plugin);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public Collection<FaweMaskManager> getMaskManagers() {
        Plugin griefpreventionPlugin;
        Plugin residencePlugin;
        Plugin townyPlugin;
        Plugin worldguardPlugin = Bukkit.getServer().getPluginManager().getPlugin("WorldGuard");
        ArrayList<FaweMaskManager> managers = new ArrayList<FaweMaskManager>();
        if (worldguardPlugin != null && worldguardPlugin.isEnabled()) {
            try {
                managers.add(new Worldguard(worldguardPlugin));
                log.debug("Attempting to use plugin 'WorldGuard'");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((townyPlugin = Bukkit.getServer().getPluginManager().getPlugin("Towny")) != null && townyPlugin.isEnabled()) {
            try {
                managers.add(new TownyFeature(townyPlugin));
                log.debug("Attempting to use plugin 'Towny'");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((residencePlugin = Bukkit.getServer().getPluginManager().getPlugin("Residence")) != null && residencePlugin.isEnabled()) {
            try {
                managers.add(new ResidenceFeature(residencePlugin, this));
                log.debug("Attempting to use plugin 'Residence'");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((griefpreventionPlugin = Bukkit.getServer().getPluginManager().getPlugin("GriefPrevention")) != null && griefpreventionPlugin.isEnabled()) {
            try {
                managers.add(new GriefPreventionFeature(griefpreventionPlugin));
                log.debug("Attempting to use plugin 'GriefPrevention'");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (Settings.IMP.EXPERIMENTAL.FREEBUILD) {
            try {
                managers.add(new FreeBuildRegion());
                log.debug("Attempting to use plugin '<internal.freebuild>'");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return managers;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldLoad(WorldLoadEvent event) {
        if (this.keepUnloaded) {
            World world = event.getWorld();
            world.setKeepSpawnInMemory(false);
        }
    }

    public synchronized <T> T createWorldUnloaded(Supplier<T> task) {
        this.keepUnloaded = true;
        try {
            T t = task.get();
            return t;
        }
        finally {
            this.keepUnloaded = false;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        org.bukkit.entity.Player player = event.getPlayer();
        BukkitPlayer wePlayer = BukkitAdapter.adapt(player);
        wePlayer.unregister();
    }

    @Override
    public String getPlatform() {
        return "Bukkit";
    }

    @Override
    public UUID getUUID(String name) {
        return Bukkit.getOfflinePlayer((String)name).getUniqueId();
    }

    @Override
    public String getName(UUID uuid) {
        return Bukkit.getOfflinePlayer((UUID)uuid).getName();
    }

    @Override
    public Preloader getPreloader() {
        if (PaperLib.isPaper()) {
            return new AsyncPreloader();
        }
        return null;
    }

    @Override
    public boolean isChunksStretched() {
        return this.chunksStretched;
    }

    @Override
    public FAWEPlatformAdapterImpl getPlatformAdapter() {
        return this.platformAdapter;
    }

    private void setupPlotSquared() {
        Plugin plotSquared = this.plugin.getServer().getPluginManager().getPlugin("PlotSquared");
        if (plotSquared == null) {
            return;
        }
        if (plotSquared.getClass().getPackage().toString().contains("intellectualsites")) {
            WEManager.IMP.managers.add(new com.boydti.fawe.bukkit.regions.plotsquaredv4.PlotSquaredFeature());
        } else {
            WEManager.IMP.managers.add(new PlotSquaredFeature());
        }
        log.info("Plugin 'PlotSquared' found. Using it now.");
    }
}

