/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.adapter;

import com.boydti.fawe.FAWEPlatformAdapterImpl;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.bukkit.adapter.BukkitGetBlocks;
import com.boydti.fawe.config.Settings;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.util.Map;
import java.util.function.Function;

public class NMSAdapter
implements FAWEPlatformAdapterImpl {
    public static int createPalette(int[] blockToPalette, int[] paletteToBlock, int[] blocksCopy, int[] num_palette_buffer, char[] set, Map<BlockVector3, Integer> ticking_blocks, boolean fastmode) {
        int air = 0;
        int num_palette = 0;
        int lastOrdinal = 0;
        boolean lastticking = false;
        boolean tick_placed = Settings.IMP.EXPERIMENTAL.ALLOW_TICK_PLACED;
        for (int i = 0; i < 4096; ++i) {
            int ordinal = set[i];
            switch (ordinal) {
                case 0: {
                    ordinal = 1;
                }
                case 1: 
                case 2: 
                case 3: {
                    ++air;
                    break;
                }
                default: {
                    boolean ticking;
                    if (fastmode || tick_placed) break;
                    if (ordinal != lastOrdinal) {
                        ticking = BlockTypesCache.ticking[ordinal];
                        lastOrdinal = ordinal;
                        lastticking = ticking;
                    } else {
                        ticking = lastticking;
                    }
                    if (!ticking) break;
                    BlockState state = BlockState.getFromOrdinal(ordinal);
                    ticking_blocks.put(BlockVector3.at(i & 0xF, i >> 8 & 0xF, i >> 4 & 0xF), WorldEditPlugin.getInstance().getBukkitImplAdapter().getInternalBlockStateId(state).orElse(0));
                }
            }
            int palette = blockToPalette[ordinal];
            if (palette == Integer.MAX_VALUE) {
                blockToPalette[ordinal] = palette = num_palette;
                paletteToBlock[num_palette] = ordinal;
                ++num_palette;
            }
            blocksCopy[i] = palette;
        }
        num_palette_buffer[0] = num_palette;
        return air;
    }

    public static int createPalette(int layer, int[] blockToPalette, int[] paletteToBlock, int[] blocksCopy, int[] num_palette_buffer, Function<Integer, char[]> get, char[] set, Map<BlockVector3, Integer> ticking_blocks, boolean fastmode) {
        int air = 0;
        int num_palette = 0;
        char[] getArr = null;
        int lastOrdinal = 0;
        boolean lastticking = false;
        boolean tick_placed = Settings.IMP.EXPERIMENTAL.ALLOW_TICK_PLACED;
        boolean tick_existing = Settings.IMP.EXPERIMENTAL.ALLOW_TICK_EXISTING;
        for (int i = 0; i < 4096; ++i) {
            int palette;
            BlockState state;
            boolean ticking;
            int ordinal = set[i];
            switch (ordinal) {
                case 0: {
                    if (getArr == null) {
                        getArr = get.apply(layer);
                    }
                    ordinal = getArr[i];
                    switch (ordinal) {
                        case 0: {
                            ordinal = 1;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            ++air;
                            break;
                        }
                        default: {
                            if (fastmode || tick_placed || !tick_existing) break;
                            if (ordinal != lastOrdinal) {
                                ticking = BlockTypesCache.ticking[ordinal];
                                lastOrdinal = ordinal;
                                lastticking = ticking;
                            } else {
                                ticking = lastticking;
                            }
                            if (!ticking) break;
                            state = BlockState.getFromOrdinal(ordinal);
                            ticking_blocks.put(BlockVector3.at(i & 0xF, i >> 8 & 0xF, i >> 4 & 0xF), WorldEditPlugin.getInstance().getBukkitImplAdapter().getInternalBlockStateId(state).orElse(0));
                        }
                    }
                    set[i] = ordinal;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    ++air;
                }
            }
            if (!fastmode && tick_placed) {
                if (ordinal != lastOrdinal) {
                    ticking = BlockTypesCache.ticking[ordinal];
                    lastOrdinal = ordinal;
                    lastticking = ticking;
                } else {
                    ticking = lastticking;
                }
                if (ticking) {
                    state = BlockState.getFromOrdinal(ordinal);
                    ticking_blocks.put(BlockVector3.at(i & 0xF, i >> 8 & 0xF, i >> 4 & 0xF), WorldEditPlugin.getInstance().getBukkitImplAdapter().getInternalBlockStateId(state).orElse(0));
                }
            }
            if ((palette = blockToPalette[ordinal]) == Integer.MAX_VALUE) {
                blockToPalette[ordinal] = palette = num_palette;
                paletteToBlock[num_palette] = ordinal;
                ++num_palette;
            }
            blocksCopy[i] = palette;
        }
        num_palette_buffer[0] = num_palette;
        return air;
    }

    @Override
    public void sendChunk(IChunkGet chunk, int mask, boolean lighting) {
        if (!(chunk instanceof BukkitGetBlocks)) {
            throw new IllegalArgumentException("(IChunkGet) chunk not of type BukkitGetBlocks");
        }
        ((BukkitGetBlocks)((Object)chunk)).send(mask, lighting);
    }
}

