/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.adapter.mc1_15_2;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweCache;
import com.boydti.fawe.bukkit.adapter.DelegateLock;
import com.boydti.fawe.bukkit.adapter.NMSAdapter;
import com.boydti.fawe.bukkit.adapter.mc1_15_2.BlockMaterial_1_15_2;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.collection.BitArray;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.ReflectionUtils;
import com.boydti.fawe.util.TaskManager;
import com.sk89q.worldedit.bukkit.paperlib.PaperLib;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import net.jpountz.util.UnsafeUtils;
import net.minecraft.server.v1_15_R1.BiomeBase;
import net.minecraft.server.v1_15_R1.BiomeStorage;
import net.minecraft.server.v1_15_R1.Block;
import net.minecraft.server.v1_15_R1.Chunk;
import net.minecraft.server.v1_15_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_15_R1.ChunkSection;
import net.minecraft.server.v1_15_R1.DataBits;
import net.minecraft.server.v1_15_R1.DataPaletteBlock;
import net.minecraft.server.v1_15_R1.DataPaletteExpandable;
import net.minecraft.server.v1_15_R1.DataPaletteLinear;
import net.minecraft.server.v1_15_R1.GameProfileSerializer;
import net.minecraft.server.v1_15_R1.IBlockData;
import net.minecraft.server.v1_15_R1.LightEngine;
import net.minecraft.server.v1_15_R1.LightEngineStorage;
import net.minecraft.server.v1_15_R1.NibbleArray;
import net.minecraft.server.v1_15_R1.Packet;
import net.minecraft.server.v1_15_R1.PacketPlayOutLightUpdate;
import net.minecraft.server.v1_15_R1.PlayerChunk;
import net.minecraft.server.v1_15_R1.PlayerChunkMap;
import net.minecraft.server.v1_15_R1.World;
import net.minecraft.server.v1_15_R1.WorldServer;
import org.bukkit.craftbukkit.v1_15_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import sun.misc.Unsafe;

public final class BukkitAdapter_1_15_2
extends NMSAdapter {
    public static final Field fieldBits;
    public static final Field fieldPalette;
    public static final Field fieldSize;
    public static final Field fieldFluidCount;
    public static final Field fieldTickingBlockCount;
    public static final Field fieldNonEmptyBlockCount;
    private static final Field fieldDirtyCount;
    private static final Field fieldDirtyBits;
    private static final Field fieldBiomeArray;
    private static final MethodHandle methodGetVisibleChunk;
    public static final MethodHandle methodSetLightNibbleArray;
    private static final int CHUNKSECTION_BASE;
    private static final int CHUNKSECTION_SHIFT;
    private static final Field fieldLock;

    protected static boolean setSectionAtomic(ChunkSection[] sections, ChunkSection expected, ChunkSection value, int layer) {
        long offset = ((long)layer << CHUNKSECTION_SHIFT) + (long)CHUNKSECTION_BASE;
        if (layer >= 0 && layer < sections.length) {
            return UnsafeUtils.getUNSAFE().compareAndSwapObject(sections, offset, expected, value);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DelegateLock applyLock(ChunkSection section) {
        try {
            ChunkSection chunkSection = section;
            synchronized (chunkSection) {
                DataPaletteBlock blocks = section.getBlocks();
                ReentrantLock currentLock = (ReentrantLock)fieldLock.get(blocks);
                if (currentLock instanceof DelegateLock) {
                    return (DelegateLock)currentLock;
                }
                DelegateLock newLock = new DelegateLock(currentLock);
                fieldLock.set(blocks, newLock);
                return newLock;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static Chunk ensureLoaded(World nmsWorld, int chunkX, int chunkZ) {
        Chunk nmsChunk = nmsWorld.getChunkIfLoaded(chunkX, chunkZ);
        if (nmsChunk != null) {
            return nmsChunk;
        }
        if (Fawe.isMainThread()) {
            return nmsWorld.getChunkAt(chunkX, chunkZ);
        }
        if (PaperLib.isPaper()) {
            CraftWorld craftWorld = nmsWorld.getWorld();
            CompletableFuture future = craftWorld.getChunkAtAsync(chunkX, chunkZ, true);
            try {
                CraftChunk chunk = (CraftChunk)future.get();
                return chunk.getHandle();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return TaskManager.IMP.sync(() -> nmsWorld.getChunkAt(chunkX, chunkZ));
    }

    public static PlayerChunk getPlayerChunk(WorldServer nmsWorld, int cx, int cz) {
        PlayerChunkMap chunkMap = nmsWorld.getChunkProvider().playerChunkMap;
        try {
            return methodGetVisibleChunk.invoke(chunkMap, ChunkCoordIntPair.pair((int)cx, (int)cz));
        }
        catch (Throwable thr) {
            throw new RuntimeException(thr);
        }
    }

    public static void sendChunk(WorldServer nmsWorld, int chunkX, int chunkZ, int mask, boolean lighting) {
        PlayerChunk playerChunk = BukkitAdapter_1_15_2.getPlayerChunk(nmsWorld, chunkX, chunkZ);
        if (playerChunk == null) {
            return;
        }
        if (playerChunk.hasBeenLoaded()) {
            try {
                int dirtyBits = fieldDirtyBits.getInt(playerChunk);
                if (dirtyBits == 0) {
                    nmsWorld.getChunkProvider().playerChunkMap.a(playerChunk);
                }
                dirtyBits = mask == 0 ? 65535 : (dirtyBits |= mask);
                fieldDirtyBits.set(playerChunk, dirtyBits);
                fieldDirtyCount.set(playerChunk, 64);
                if (lighting) {
                    ChunkCoordIntPair chunkCoordIntPair = new ChunkCoordIntPair(chunkX, chunkZ);
                    PacketPlayOutLightUpdate packet = new PacketPlayOutLightUpdate(chunkCoordIntPair, (LightEngine)nmsWorld.getChunkProvider().getLightEngine());
                    playerChunk.players.a(chunkCoordIntPair, false).forEach(p -> p.playerConnection.sendPacket((Packet)packet));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static ChunkSection newChunkSection(int layer, char[] blocks, boolean fastmode) {
        return BukkitAdapter_1_15_2.newChunkSection(layer, null, blocks, fastmode);
    }

    public static ChunkSection newChunkSection(int layer, Function<Integer, char[]> get, char[] set, boolean fastmode) {
        if (set == null) {
            return BukkitAdapter_1_15_2.newChunkSection(layer);
        }
        int[] blockToPalette = (int[])FaweCache.IMP.BLOCK_TO_PALETTE.get();
        int[] paletteToBlock = (int[])FaweCache.IMP.PALETTE_TO_BLOCK.get();
        long[] blockStates = (long[])FaweCache.IMP.BLOCK_STATES.get();
        int[] blocksCopy = (int[])FaweCache.IMP.SECTION_BLOCKS.get();
        try {
            int[] num_palette_buffer = new int[1];
            HashMap<BlockVector3, Integer> ticking_blocks = new HashMap<BlockVector3, Integer>();
            int air = get == null ? BukkitAdapter_1_15_2.createPalette(blockToPalette, paletteToBlock, blocksCopy, num_palette_buffer, set, ticking_blocks, fastmode) : BukkitAdapter_1_15_2.createPalette(layer, blockToPalette, paletteToBlock, blocksCopy, num_palette_buffer, get, set, ticking_blocks, fastmode);
            int num_palette = num_palette_buffer[0];
            int bitsPerEntry = MathMan.log2nlz(num_palette - 1);
            bitsPerEntry = Settings.IMP.PROTOCOL_SUPPORT_FIX || num_palette != 1 ? Math.max(bitsPerEntry, 4) : Math.max(bitsPerEntry, 1);
            int blockBitArrayEnd = bitsPerEntry * 4096 >> 6;
            if (num_palette == 1) {
                for (int i = 0; i < blockBitArrayEnd; ++i) {
                    blockStates[i] = 0L;
                }
            } else {
                BitArray bitArray = new BitArray(bitsPerEntry, 4096, blockStates);
                bitArray.fromRaw(blocksCopy);
            }
            ChunkSection section = BukkitAdapter_1_15_2.newChunkSection(layer);
            DataPaletteBlock dataPaletteBlocks = section.getBlocks();
            long[] bits = Arrays.copyOfRange(blockStates, 0, blockBitArrayEnd);
            DataBits nmsBits = new DataBits(bitsPerEntry, 4096, bits);
            DataPaletteLinear palette = new DataPaletteLinear(Block.REGISTRY_ID, bitsPerEntry, (DataPaletteExpandable)dataPaletteBlocks, GameProfileSerializer::d);
            for (int i = 0; i < num_palette; ++i) {
                int ordinal2 = paletteToBlock[i];
                blockToPalette[ordinal2] = Integer.MAX_VALUE;
                BlockState state = BlockTypesCache.states[ordinal2];
                IBlockData ibd = ((BlockMaterial_1_15_2)state.getMaterial()).getState();
                palette.a((Object)ibd);
            }
            try {
                fieldBits.set(dataPaletteBlocks, nmsBits);
                fieldPalette.set(dataPaletteBlocks, palette);
                fieldSize.set(dataPaletteBlocks, bitsPerEntry);
                BukkitAdapter_1_15_2.setCount(ticking_blocks.size(), 4096 - air, section);
                if (!fastmode) {
                    ticking_blocks.forEach((pos, ordinal) -> section.setType(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ(), Block.getByCombinedId((int)ordinal)));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            return section;
        }
        catch (Throwable e) {
            Arrays.fill(blockToPalette, Integer.MAX_VALUE);
            throw e;
        }
    }

    private static ChunkSection newChunkSection(int layer) {
        return new ChunkSection(layer << 4);
    }

    public static void setCount(int tickingBlockCount, int nonEmptyBlockCount, ChunkSection section) throws NoSuchFieldException, IllegalAccessException {
        fieldFluidCount.setShort(section, (short)0);
        fieldTickingBlockCount.setShort(section, (short)tickingBlockCount);
        fieldNonEmptyBlockCount.setShort(section, (short)nonEmptyBlockCount);
    }

    public static BiomeBase[] getBiomeArray(BiomeStorage storage) {
        try {
            return (BiomeBase[])fieldBiomeArray.get(storage);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            fieldSize = DataPaletteBlock.class.getDeclaredField("i");
            fieldSize.setAccessible(true);
            fieldBits = DataPaletteBlock.class.getDeclaredField("a");
            fieldBits.setAccessible(true);
            fieldPalette = DataPaletteBlock.class.getDeclaredField("h");
            fieldPalette.setAccessible(true);
            fieldFluidCount = ChunkSection.class.getDeclaredField("e");
            fieldFluidCount.setAccessible(true);
            fieldTickingBlockCount = ChunkSection.class.getDeclaredField("tickingBlockCount");
            fieldTickingBlockCount.setAccessible(true);
            fieldNonEmptyBlockCount = ChunkSection.class.getDeclaredField("nonEmptyBlockCount");
            fieldNonEmptyBlockCount.setAccessible(true);
            fieldDirtyCount = PlayerChunk.class.getDeclaredField("dirtyCount");
            fieldDirtyCount.setAccessible(true);
            fieldDirtyBits = PlayerChunk.class.getDeclaredField("r");
            fieldDirtyBits.setAccessible(true);
            fieldBiomeArray = BiomeStorage.class.getDeclaredField("g");
            fieldBiomeArray.setAccessible(true);
            Method declaredGetVisibleChunk = PlayerChunkMap.class.getDeclaredMethod("getVisibleChunk", Long.TYPE);
            declaredGetVisibleChunk.setAccessible(true);
            methodGetVisibleChunk = MethodHandles.lookup().unreflect(declaredGetVisibleChunk);
            Method declaredSetLightNibbleArray = LightEngineStorage.class.getDeclaredMethod("a", Long.TYPE, NibbleArray.class);
            declaredSetLightNibbleArray.setAccessible(true);
            methodSetLightNibbleArray = MethodHandles.lookup().unreflect(declaredSetLightNibbleArray);
            Field tmp = DataPaletteBlock.class.getDeclaredField("j");
            ReflectionUtils.setAccessibleNonFinal(tmp);
            fieldLock = tmp;
            fieldLock.setAccessible(true);
            Unsafe unsafe = UnsafeUtils.getUNSAFE();
            CHUNKSECTION_BASE = unsafe.arrayBaseOffset(ChunkSection[].class);
            int scale = unsafe.arrayIndexScale(ChunkSection[].class);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            CHUNKSECTION_SHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable rethrow) {
            rethrow.printStackTrace();
            throw new RuntimeException(rethrow);
        }
    }
}

