/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.adapter.mc1_15_2;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweCache;
import com.boydti.fawe.beta.IChunkGet;
import com.boydti.fawe.beta.IChunkSet;
import com.boydti.fawe.beta.implementation.blocks.CharGetBlocks;
import com.boydti.fawe.beta.implementation.lighting.HeightMapType;
import com.boydti.fawe.beta.implementation.queue.QueueHandler;
import com.boydti.fawe.bukkit.adapter.BukkitGetBlocks;
import com.boydti.fawe.bukkit.adapter.DelegateLock;
import com.boydti.fawe.bukkit.adapter.mc1_15_2.BukkitAdapter_1_15_2;
import com.boydti.fawe.bukkit.adapter.mc1_15_2.BukkitGetBlocks_1_15_2_Copy;
import com.boydti.fawe.bukkit.adapter.mc1_15_2.nbt.LazyCompoundTag_1_15_2;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.collection.AdaptedMap;
import com.boydti.fawe.object.collection.BitArray;
import com.google.common.base.Function;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.FAWE_Spigot_v1_15_R2;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.server.v1_15_R1.BiomeBase;
import net.minecraft.server.v1_15_R1.BiomeStorage;
import net.minecraft.server.v1_15_R1.BlockPosition;
import net.minecraft.server.v1_15_R1.Chunk;
import net.minecraft.server.v1_15_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_15_R1.ChunkSection;
import net.minecraft.server.v1_15_R1.DataBits;
import net.minecraft.server.v1_15_R1.DataPalette;
import net.minecraft.server.v1_15_R1.DataPaletteBlock;
import net.minecraft.server.v1_15_R1.DataPaletteHash;
import net.minecraft.server.v1_15_R1.DataPaletteLinear;
import net.minecraft.server.v1_15_R1.EntityTypes;
import net.minecraft.server.v1_15_R1.EnumSkyBlock;
import net.minecraft.server.v1_15_R1.HeightMap;
import net.minecraft.server.v1_15_R1.IBlockData;
import net.minecraft.server.v1_15_R1.NBTBase;
import net.minecraft.server.v1_15_R1.NBTTagCompound;
import net.minecraft.server.v1_15_R1.NBTTagInt;
import net.minecraft.server.v1_15_R1.NibbleArray;
import net.minecraft.server.v1_15_R1.SectionPosition;
import net.minecraft.server.v1_15_R1.TileEntity;
import net.minecraft.server.v1_15_R1.World;
import net.minecraft.server.v1_15_R1.WorldServer;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.NotNull;

public class BukkitGetBlocks_1_15_2
extends CharGetBlocks
implements BukkitGetBlocks {
    private static final Logger log = LoggerFactory.getLogger(BukkitGetBlocks_1_15_2.class);
    private static final java.util.function.Function<BlockPosition, BlockVector3> posNms2We = v -> BlockVector3.at(v.getX(), v.getY(), v.getZ());
    private static final java.util.function.Function<TileEntity, CompoundTag> nmsTile2We = tileEntity -> new LazyCompoundTag_1_15_2((Supplier<NBTTagCompound>)Suppliers.memoize(() -> tileEntity.save(new NBTTagCompound())));
    public ChunkSection[] sections;
    public Chunk nmsChunk;
    public WorldServer world;
    public int chunkX;
    public int chunkZ;
    public NibbleArray[] blockLight = new NibbleArray[16];
    public NibbleArray[] skyLight = new NibbleArray[16];
    private boolean createCopy = false;
    private BukkitGetBlocks_1_15_2_Copy copy = null;
    private boolean forceLoadSections = true;
    private boolean lightUpdate = false;

    public BukkitGetBlocks_1_15_2(org.bukkit.World world, int chunkX, int chunkZ) {
        this(((CraftWorld)world).getHandle(), chunkX, chunkZ);
    }

    public BukkitGetBlocks_1_15_2(WorldServer world, int chunkX, int chunkZ) {
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    @Override
    public void setCreateCopy(boolean createCopy) {
        this.createCopy = createCopy;
    }

    @Override
    public boolean isCreateCopy() {
        return this.createCopy;
    }

    @Override
    public IChunkGet getCopy() {
        return this.copy;
    }

    @Override
    public void setLightingToGet(char[][] light) {
        if (light != null) {
            this.lightUpdate = true;
            try {
                this.fillLightNibble(light, EnumSkyBlock.BLOCK);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setSkyLightingToGet(char[][] light) {
        if (light != null) {
            this.lightUpdate = true;
            try {
                this.fillLightNibble(light, EnumSkyBlock.SKY);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setHeightmapToGet(HeightMapType type, int[] data) {
        BitArray bitArray = new BitArray(9, 256);
        bitArray.fromRaw(data);
        ((HeightMap)this.getChunk().heightMap.get(HeightMap.Type.valueOf((String)type.name()))).a(bitArray.getData());
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        BiomeStorage index = this.getChunk().getBiomeIndex();
        BiomeBase base = null;
        if (y == -1) {
            for (y = 0; y < FaweCache.IMP.WORLD_HEIGHT && (base = index.getBiome(x >> 2, y >> 2, z >> 2)) == null; ++y) {
            }
        } else {
            base = index.getBiome(x >> 2, y >> 2, z >> 2);
        }
        return base != null ? BukkitAdapter.adapt(CraftBlock.biomeBaseToBiome(base)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSectionLighting(int layer, boolean sky) {
        SectionPosition sectionPosition = SectionPosition.a((ChunkCoordIntPair)this.getChunk().getPos(), (int)layer);
        NibbleArray nibble = this.world.getChunkProvider().getLightEngine().a(EnumSkyBlock.BLOCK).a(sectionPosition);
        if (nibble != null) {
            this.lightUpdate = true;
            NibbleArray nibbleArray = nibble;
            synchronized (nibbleArray) {
                byte[] bytes = nibble.getCloneIfSet();
                if (bytes != NibbleArray.EMPTY_NIBBLE) {
                    Arrays.fill(bytes, (byte)0);
                }
            }
        }
        if (sky) {
            SectionPosition sectionPositionSky = SectionPosition.a((ChunkCoordIntPair)this.getChunk().getPos(), (int)layer);
            NibbleArray nibbleSky = this.world.getChunkProvider().getLightEngine().a(EnumSkyBlock.SKY).a(sectionPositionSky);
            if (nibble != null) {
                this.lightUpdate = true;
                NibbleArray nibbleArray = nibbleSky;
                synchronized (nibbleArray) {
                    byte[] bytes = nibbleSky.getCloneIfSet();
                    if (bytes != NibbleArray.EMPTY_NIBBLE) {
                        Arrays.fill(bytes, (byte)0);
                    }
                }
            }
        }
    }

    @Override
    public CompoundTag getTile(int x, int y, int z) {
        TileEntity tileEntity = this.getChunk().getTileEntity(new BlockPosition((x & 0xF) + (this.chunkX << 4), y, (z & 0xF) + (this.chunkZ << 4)));
        if (tileEntity == null) {
            return null;
        }
        return new LazyCompoundTag_1_15_2((Supplier<NBTTagCompound>)Suppliers.memoize(() -> tileEntity.save(new NBTTagCompound())));
    }

    @Override
    public Map<BlockVector3, CompoundTag> getTiles() {
        Map nmsTiles = this.getChunk().getTileEntities();
        if (nmsTiles.isEmpty()) {
            return Collections.emptyMap();
        }
        return AdaptedMap.immutable(nmsTiles, posNms2We, nmsTile2We);
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        int layer = y >> 4;
        if (this.skyLight[layer] == null) {
            SectionPosition sectionPosition = SectionPosition.a((ChunkCoordIntPair)this.getChunk().getPos(), (int)layer);
            NibbleArray nibbleArray = this.world.getChunkProvider().getLightEngine().a(EnumSkyBlock.SKY).a(sectionPosition);
            if (nibbleArray == null) {
                byte[] a = new byte[2048];
                Arrays.fill(a, (byte)15);
                nibbleArray = new NibbleArray(a);
                this.world.getChunkProvider().getLightEngine().a(EnumSkyBlock.SKY, sectionPosition, nibbleArray);
            }
            this.skyLight[layer] = nibbleArray;
        }
        long l = BlockPosition.a((int)x, (int)y, (int)z);
        return this.skyLight[layer].a(SectionPosition.b((int)BlockPosition.b((long)l)), SectionPosition.b((int)BlockPosition.c((long)l)), SectionPosition.b((int)BlockPosition.d((long)l)));
    }

    @Override
    public int getEmmittedLight(int x, int y, int z) {
        int layer = y >> 4;
        if (this.blockLight[layer] == null) {
            SectionPosition sectionPosition = SectionPosition.a((ChunkCoordIntPair)this.getChunk().getPos(), (int)layer);
            NibbleArray nibbleArray = this.world.getChunkProvider().getLightEngine().a(EnumSkyBlock.BLOCK).a(sectionPosition);
            if (nibbleArray == null) {
                byte[] a = new byte[2048];
                Arrays.fill(a, (byte)0);
                nibbleArray = new NibbleArray(a);
                this.world.getChunkProvider().getLightEngine().a(EnumSkyBlock.BLOCK, sectionPosition, nibbleArray);
            }
            this.blockLight[layer] = nibbleArray;
        }
        long l = BlockPosition.a((int)x, (int)y, (int)z);
        return this.blockLight[layer].a(SectionPosition.b((int)BlockPosition.b((long)l)), SectionPosition.b((int)BlockPosition.c((long)l)), SectionPosition.b((int)BlockPosition.d((long)l)));
    }

    @Override
    public int[] getHeightMap(HeightMapType type) {
        long[] longArray = ((HeightMap)this.getChunk().heightMap.get(HeightMap.Type.valueOf((String)type.name()))).a();
        BitArray bitArray = new BitArray(9, 256, longArray);
        return bitArray.toRaw(new int[256]);
    }

    @Override
    public CompoundTag getEntity(UUID uuid) {
        net.minecraft.server.v1_15_R1.Entity entity = this.world.getEntity(uuid);
        if (entity != null) {
            CraftEntity bukkitEnt = entity.getBukkitEntity();
            return BukkitAdapter.adapt((Entity)bukkitEnt).getState().getNbtData();
        }
        for (List entry : this.getChunk().getEntitySlices()) {
            if (entry == null) continue;
            for (net.minecraft.server.v1_15_R1.Entity ent : entry) {
                if (!uuid.equals(ent.getUniqueID())) continue;
                CraftEntity bukkitEnt = ent.getBukkitEntity();
                return BukkitAdapter.adapt((Entity)bukkitEnt).getState().getNbtData();
            }
        }
        return null;
    }

    @Override
    public Set<CompoundTag> getEntities() {
        final List[] slices = this.getChunk().getEntitySlices();
        int size = 0;
        for (List slice : slices) {
            if (slice == null) continue;
            size += slice.size();
        }
        if (slices.length == 0) {
            return Collections.emptySet();
        }
        final int finalSize = size;
        return new AbstractSet<CompoundTag>(){

            @Override
            public int size() {
                return finalSize;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object get) {
                if (!(get instanceof CompoundTag)) {
                    return false;
                }
                CompoundTag getTag = (CompoundTag)get;
                Object value = getTag.getValue();
                CompoundTag getParts = (CompoundTag)value.get("UUID");
                UUID getUUID = new UUID(getParts.getLong("Most"), getParts.getLong("Least"));
                for (List slice : slices) {
                    if (slice == null) continue;
                    for (net.minecraft.server.v1_15_R1.Entity entity : slice) {
                        UUID uuid = entity.getUniqueID();
                        if (!uuid.equals(getUUID)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            @NotNull
            public Iterator<CompoundTag> iterator() {
                Iterable result = Iterables.transform((Iterable)Iterables.concat((Iterable[])slices), (Function)new Function<net.minecraft.server.v1_15_R1.Entity, CompoundTag>(){

                    @Nullable
                    public CompoundTag apply(@Nullable net.minecraft.server.v1_15_R1.Entity input) {
                        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
                        NBTTagCompound tag = new NBTTagCompound();
                        return (CompoundTag)adapter.toNative(input.save(tag));
                    }
                });
                return result.iterator();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGet(BukkitGetBlocks_1_15_2 get, Chunk nmsChunk, ChunkSection[] sections, ChunkSection section, char[] arr, int layer) {
        BukkitGetBlocks_1_15_2 bukkitGetBlocks_1_15_2 = get;
        synchronized (bukkitGetBlocks_1_15_2) {
            if (this.getChunk() != nmsChunk) {
                this.nmsChunk = nmsChunk;
                this.sections = (ChunkSection[])sections.clone();
                this.reset();
            }
            if (this.sections == null) {
                this.sections = (ChunkSection[])sections.clone();
            }
            if (this.sections[layer] != section) {
                this.sections[layer] = ((ChunkSection[])new ChunkSection[]{section}.clone())[0];
            }
            this.blocks[layer] = arr;
        }
    }

    private void removeEntity(net.minecraft.server.v1_15_R1.Entity entity) {
        entity.die();
    }

    public Chunk ensureLoaded(World nmsWorld, int chunkX, int chunkZ) {
        return BukkitAdapter_1_15_2.ensureLoaded(nmsWorld, chunkX, chunkZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <T extends Future<T>> T call(IChunkSet set, Runnable finalizer) {
        this.forceLoadSections = false;
        this.copy = this.createCopy ? new BukkitGetBlocks_1_15_2_Copy(this.world) : null;
        try {
            Object tile;
            WorldServer nmsWorld = this.world;
            Chunk nmsChunk = this.ensureLoaded((World)nmsWorld, this.chunkX, this.chunkZ);
            boolean fastmode = set.isFastMode() && Settings.IMP.QUEUE.NO_TICK_FASTMODE;
            HashMap tiles = new HashMap(nmsChunk.getTileEntities());
            if (!tiles.isEmpty()) {
                for (Map.Entry entry : tiles.entrySet()) {
                    int ordinal;
                    BlockPosition pos = (BlockPosition)entry.getKey();
                    int lx = pos.getX() & 0xF;
                    int ly = pos.getY();
                    int lz = pos.getZ() & 0xF;
                    int layer = ly >> 4;
                    if (!set.hasSection(layer) || (ordinal = set.getBlock(lx, ly, lz).getOrdinal()) == 0) continue;
                    tile = (TileEntity)entry.getValue();
                    nmsChunk.removeTileEntity(tile.getPosition());
                    if (!this.createCopy) continue;
                    this.copy.storeTile((TileEntity)tile);
                }
            }
            int bitMask = 0;
            Chunk chunk = nmsChunk;
            synchronized (chunk) {
                Runnable callback;
                block48: {
                    Map<BlockVector3, CompoundTag> tiles2;
                    Set<CompoundTag> entities;
                    ChunkSection[] chunkSectionArray = nmsChunk.getSections();
                    for (int layer = 0; layer < 16; ++layer) {
                        ChunkSection newSection;
                        ChunkSection existingSection;
                        if (!set.hasSection(layer)) continue;
                        bitMask |= 1 << layer;
                        char[] setArr = (char[])set.load(layer).clone();
                        if (this.createCopy) {
                            this.copy.storeSection(layer, (char[])this.loadPrivately(layer).clone());
                        }
                        if ((existingSection = chunkSectionArray[layer]) == null) {
                            newSection = BukkitAdapter_1_15_2.newChunkSection(layer, setArr, fastmode);
                            if (BukkitAdapter_1_15_2.setSectionAtomic(chunkSectionArray, null, newSection, layer)) {
                                this.updateGet(this, nmsChunk, chunkSectionArray, newSection, setArr, layer);
                                continue;
                            }
                            existingSection = chunkSectionArray[layer];
                            if (existingSection == null) {
                                log.error("Skipping invalid null section. chunk:" + this.chunkX + "," + this.chunkZ + " layer: " + layer);
                                continue;
                            }
                        }
                        BukkitAdapter_1_15_2.fieldTickingBlockCount.set(existingSection, (short)0);
                        DelegateLock lock = BukkitAdapter_1_15_2.applyLock(existingSection);
                        BukkitGetBlocks_1_15_2 ordinal = this;
                        synchronized (ordinal) {
                            tile = lock;
                            synchronized (tile) {
                                lock.untilFree();
                                if (this.getChunk() != nmsChunk) {
                                    this.nmsChunk = nmsChunk;
                                    this.sections = null;
                                    this.reset();
                                } else if (existingSection != this.getSections(false)[layer]) {
                                    this.sections[layer] = existingSection;
                                    this.reset();
                                } else if (!Arrays.equals(this.update(layer, new char[4096]), this.loadPrivately(layer))) {
                                    this.reset(layer);
                                } else if (lock.isModified()) {
                                    this.reset(layer);
                                }
                                newSection = BukkitAdapter_1_15_2.newChunkSection(layer, this::loadPrivately, setArr, fastmode);
                                if (!BukkitAdapter_1_15_2.setSectionAtomic(chunkSectionArray, existingSection, newSection, layer)) {
                                    log.error("Failed to set chunk section:" + this.chunkX + "," + this.chunkZ + " layer: " + layer);
                                } else {
                                    this.updateGet(this, nmsChunk, chunkSectionArray, newSection, setArr, layer);
                                }
                            }
                        }
                    }
                    BiomeType[] biomes = set.getBiomes();
                    if (biomes != null) {
                        BiomeStorage currentBiomes = nmsChunk.getBiomeIndex();
                        if (this.createCopy) {
                            this.copy.storeBiomes(currentBiomes);
                        }
                        int i = 0;
                        for (int y = 0; y < 64; ++y) {
                            for (int z = 0; z < 4; ++z) {
                                int x = 0;
                                while (x < 4) {
                                    BiomeType biome = biomes[i];
                                    if (biome != null) {
                                        Biome craftBiome = BukkitAdapter.adapt(biome);
                                        BiomeBase nmsBiome = CraftBlock.biomeToBiomeBase((Biome)craftBiome);
                                        currentBiomes.setBiome(x, y, z, nmsBiome);
                                    }
                                    ++x;
                                    ++i;
                                }
                            }
                        }
                    }
                    Map<HeightMapType, int[]> heightMaps = set.getHeightMaps();
                    for (Map.Entry<HeightMapType, int[]> entry : heightMaps.entrySet()) {
                        this.setHeightmapToGet(entry.getKey(), entry.getValue());
                    }
                    this.setLightingToGet(set.getLight());
                    this.setSkyLightingToGet(set.getSkyLight());
                    Runnable[] syncTasks = null;
                    int bx = this.chunkX << 4;
                    int bz = this.chunkZ << 4;
                    Set<UUID> entityRemoves = set.getEntityRemoves();
                    if (entityRemoves != null && !entityRemoves.isEmpty()) {
                        syncTasks = new Runnable[3];
                        syncTasks[2] = () -> {
                            List[] entities;
                            for (List ents : entities = nmsChunk.getEntitySlices()) {
                                if (ents.isEmpty()) continue;
                                Iterator iter = ents.iterator();
                                while (iter.hasNext()) {
                                    net.minecraft.server.v1_15_R1.Entity entity = (net.minecraft.server.v1_15_R1.Entity)iter.next();
                                    if (!entityRemoves.contains(entity.getUniqueID())) continue;
                                    if (this.createCopy) {
                                        this.copy.storeEntity(entity);
                                    }
                                    iter.remove();
                                    this.removeEntity(entity);
                                }
                            }
                        };
                    }
                    if ((entities = set.getEntities()) != null && !entities.isEmpty()) {
                        if (syncTasks == null) {
                            syncTasks = new Runnable[2];
                        }
                        syncTasks[1] = () -> {
                            for (CompoundTag nativeTag : entities) {
                                net.minecraft.server.v1_15_R1.Entity entity;
                                Object entityTagMap = nativeTag.getValue();
                                StringTag idTag = (StringTag)entityTagMap.get("Id");
                                ListTag posTag = (ListTag)entityTagMap.get("Pos");
                                ListTag rotTag = (ListTag)entityTagMap.get("Rotation");
                                if (idTag == null || posTag == null || rotTag == null) {
                                    LoggerFactory.getLogger(BukkitGetBlocks_1_15_2.class).debug("Unknown entity tag: " + nativeTag);
                                    continue;
                                }
                                double x = posTag.getDouble(0);
                                double y = posTag.getDouble(1);
                                double z = posTag.getDouble(2);
                                float yaw = rotTag.getFloat(0);
                                float pitch = rotTag.getFloat(1);
                                String id = idTag.getValue();
                                EntityTypes type = EntityTypes.a((String)id).orElse(null);
                                if (type == null || (entity = type.a((World)nmsWorld)) == null) continue;
                                BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
                                NBTTagCompound tag = (NBTTagCompound)adapter.fromNative(nativeTag);
                                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                                    tag.remove(name);
                                }
                                entity.f(tag);
                                entity.setLocation(x, y, z, yaw, pitch);
                                nmsWorld.addEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
                            }
                        };
                    }
                    if ((tiles2 = set.getTiles()) != null && !tiles2.isEmpty() && syncTasks == null) {
                        syncTasks = new Runnable[]{() -> {
                            for (Map.Entry entry : tiles2.entrySet()) {
                                CompoundTag nativeTag = (CompoundTag)entry.getValue();
                                BlockVector3 blockHash = (BlockVector3)entry.getKey();
                                int x = blockHash.getX() + bx;
                                int y = blockHash.getY();
                                int z = blockHash.getZ() + bz;
                                BlockPosition pos = new BlockPosition(x, y, z);
                                WorldServer worldServer = nmsWorld;
                                synchronized (worldServer) {
                                    TileEntity tileEntity = nmsWorld.getTileEntity(pos);
                                    if (tileEntity == null || tileEntity.isRemoved()) {
                                        nmsWorld.removeTileEntity(pos);
                                        tileEntity = nmsWorld.getTileEntity(pos);
                                    }
                                    if (tileEntity != null) {
                                        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
                                        NBTTagCompound tag = (NBTTagCompound)adapter.fromNative(nativeTag);
                                        tag.set("x", (NBTBase)NBTTagInt.a((int)x));
                                        tag.set("y", (NBTBase)NBTTagInt.a((int)y));
                                        tag.set("z", (NBTBase)NBTTagInt.a((int)z));
                                        tileEntity.load(tag);
                                    }
                                }
                            }
                        }};
                    }
                    if (bitMask == 0 && biomes == null && !this.lightUpdate) {
                        callback = null;
                    } else {
                        int finalMask = bitMask != 0 ? bitMask : (this.lightUpdate ? set.getBitMask() : 0);
                        boolean finalLightUpdate = this.lightUpdate;
                        callback = () -> {
                            nmsChunk.d(true);
                            nmsChunk.mustNotSave = false;
                            nmsChunk.markDirty();
                            if (Settings.IMP.LIGHTING.MODE == 0 || !Settings.IMP.LIGHTING.DELAY_PACKET_SENDING) {
                                this.send(finalMask, finalLightUpdate);
                            }
                            if (finalizer != null) {
                                finalizer.run();
                            }
                        };
                    }
                    if (syncTasks == null) break block48;
                    QueueHandler queueHandler = Fawe.get().getQueueHandler();
                    Runnable[] finalSyncTasks = syncTasks;
                    Callable<Future> chain = () -> {
                        try {
                            for (Runnable task : finalSyncTasks) {
                                if (task == null) continue;
                                task.run();
                            }
                            if (callback == null) {
                                if (finalizer != null) {
                                    finalizer.run();
                                }
                                return null;
                            }
                            return queueHandler.async(callback, null);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            throw e;
                        }
                    };
                    Future<Future> future = queueHandler.sync(chain);
                    return (T)future;
                }
                if (callback == null) {
                    if (finalizer != null) {
                        finalizer.run();
                    }
                } else {
                    callback.run();
                }
            }
            chunk = null;
            return (T)chunk;
        }
        catch (Throwable e) {
            e.printStackTrace();
            T t = null;
            return t;
        }
        finally {
            this.forceLoadSections = true;
        }
    }

    private char[] loadPrivately(int layer) {
        if (((CharGetBlocks)this).sections[layer].isFull()) {
            return this.blocks[layer];
        }
        return this.update(layer, null);
    }

    @Override
    public synchronized void send(int mask, boolean lighting) {
        BukkitAdapter_1_15_2.sendChunk(this.world, this.chunkX, this.chunkZ, mask, lighting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized char[] update(int layer, char[] data) {
        DelegateLock lock;
        ChunkSection section = this.getSections(true)[layer];
        if (section == null) {
            data = new char[4096];
            Arrays.fill(data, '\u0001');
            return data;
        }
        if (data == null || data == FaweCache.IMP.EMPTY_CHAR_4096) {
            data = new char[4096];
            Arrays.fill(data, '\u0001');
        }
        DelegateLock delegateLock = lock = BukkitAdapter_1_15_2.applyLock(section);
        synchronized (delegateLock) {
            lock.untilFree();
            lock.setModified(false);
            try {
                int i;
                int num_palette;
                block24: {
                    DataPalette palette;
                    FAWE_Spigot_v1_15_R2 adapter;
                    block26: {
                        int paletteVal;
                        int i2;
                        block27: {
                            block25: {
                                adapter = (FAWE_Spigot_v1_15_R2)WorldEditPlugin.getInstance().getBukkitImplAdapter();
                                DataPaletteBlock blocks = section.getBlocks();
                                DataBits bits = (DataBits)BukkitAdapter_1_15_2.fieldBits.get(blocks);
                                palette = (DataPalette)BukkitAdapter_1_15_2.fieldPalette.get(blocks);
                                int bitsPerEntry = bits.c();
                                long[] blockStates = bits.a();
                                new BitArray(bitsPerEntry, 4096, blockStates).toRaw(data);
                                if (!(palette instanceof DataPaletteLinear)) break block25;
                                num_palette = ((DataPaletteLinear)palette).b();
                                break block26;
                            }
                            if (!(palette instanceof DataPaletteHash)) break block27;
                            num_palette = ((DataPaletteHash)palette).b();
                            break block26;
                        }
                        int num_palette2 = 0;
                        int[] paletteToBlockInts = (int[])FaweCache.IMP.PALETTE_TO_BLOCK.get();
                        char[] paletteToBlockChars = (char[])FaweCache.IMP.PALETTE_TO_BLOCK_CHAR.get();
                        try {
                            for (i2 = 0; i2 < 4096; ++i2) {
                                paletteVal = data[i2];
                                char ordinal = paletteToBlockChars[paletteVal];
                                if (ordinal == '\uffff') {
                                    paletteToBlockInts[num_palette2++] = paletteVal;
                                    IBlockData ibd = (IBlockData)palette.a((int)data[i2]);
                                    ordinal = ibd == null ? BlockTypes.AIR.getDefaultState().getOrdinalChar() : adapter.adaptToChar(ibd);
                                    paletteToBlockChars[paletteVal] = ordinal;
                                }
                                if (ordinal == '\u0000') {
                                    ordinal = '\u0001';
                                }
                                data[i2] = ordinal;
                            }
                        }
                        catch (Throwable throwable) {
                            for (int i3 = 0; i3 < num_palette2; ++i3) {
                                int paletteVal2 = paletteToBlockInts[i3];
                                paletteToBlockChars[paletteVal2] = 65535;
                            }
                            throw throwable;
                        }
                        for (i2 = 0; i2 < num_palette2; ++i2) {
                            paletteVal = paletteToBlockInts[i2];
                            paletteToBlockChars[paletteVal] = 65535;
                        }
                        return data;
                    }
                    char[] paletteToOrdinal = (char[])FaweCache.IMP.PALETTE_TO_BLOCK_CHAR.get();
                    try {
                        if (num_palette != 1) {
                            for (i = 0; i < num_palette; ++i) {
                                char ordinal;
                                paletteToOrdinal[i] = ordinal = this.ordinal((IBlockData)palette.a(i), adapter);
                            }
                            for (i = 0; i < 4096; ++i) {
                                char paletteVal = data[i];
                                char val = paletteToOrdinal[paletteVal];
                                if (val == '\uffff') {
                                    paletteToOrdinal[i] = val = this.ordinal((IBlockData)palette.a(i), adapter);
                                }
                                if (val == '\u0000') {
                                    val = '\u0001';
                                }
                                data[i] = val;
                            }
                            break block24;
                        }
                        char ordinal = this.ordinal((IBlockData)palette.a(0), adapter);
                        if (ordinal == '\u0000') {
                            ordinal = '\u0001';
                        }
                        Arrays.fill(data, ordinal);
                    }
                    catch (Throwable throwable) {
                        for (int i4 = 0; i4 < num_palette; ++i4) {
                            paletteToOrdinal[i4] = 65535;
                        }
                        throw throwable;
                    }
                }
                for (i = 0; i < num_palette; ++i) {
                    paletteToOrdinal[i] = 65535;
                }
                return data;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private final char ordinal(IBlockData ibd, FAWE_Spigot_v1_15_R2 adapter) {
        if (ibd == null) {
            return BlockTypes.AIR.getDefaultState().getOrdinalChar();
        }
        return adapter.adaptToChar(ibd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkSection[] getSections(boolean force) {
        if (force && this.forceLoadSections) {
            this.sections = (ChunkSection[])this.getChunk().getSections().clone();
            return this.sections;
        }
        ChunkSection[] tmp = this.sections;
        if (tmp == null) {
            BukkitGetBlocks_1_15_2 bukkitGetBlocks_1_15_2 = this;
            synchronized (bukkitGetBlocks_1_15_2) {
                tmp = this.sections;
                if (tmp == null) {
                    Chunk chunk = this.getChunk();
                    this.sections = tmp = (ChunkSection[])chunk.getSections().clone();
                }
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk getChunk() {
        Chunk tmp = this.nmsChunk;
        if (tmp == null) {
            BukkitGetBlocks_1_15_2 bukkitGetBlocks_1_15_2 = this;
            synchronized (bukkitGetBlocks_1_15_2) {
                tmp = this.nmsChunk;
                if (tmp == null) {
                    this.nmsChunk = tmp = this.ensureLoaded((World)this.world, this.chunkX, this.chunkZ);
                }
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillLightNibble(char[][] light, EnumSkyBlock skyBlock) {
        for (int Y = 0; Y < 16; ++Y) {
            if (light[Y] == null) continue;
            SectionPosition sectionPosition = SectionPosition.a((ChunkCoordIntPair)this.nmsChunk.getPos(), (int)Y);
            NibbleArray nibble = this.world.getChunkProvider().getLightEngine().a(skyBlock).a(sectionPosition);
            if (nibble == null) {
                byte[] a = new byte[2048];
                Arrays.fill(a, skyBlock == EnumSkyBlock.SKY ? (byte)15 : 0);
                nibble = new NibbleArray(a);
                this.world.getChunkProvider().getLightEngine().a(skyBlock, sectionPosition, nibble);
            }
            NibbleArray nibbleArray = nibble;
            synchronized (nibbleArray) {
                for (int i = 0; i < 4096; ++i) {
                    if (light[Y][i] >= '\u0010') continue;
                    nibble.a(i, (int)light[Y][i]);
                }
                continue;
            }
        }
    }

    @Override
    public boolean hasSection(int layer) {
        return this.getSections(false)[layer] != null;
    }

    @Override
    public boolean trim(boolean aggressive) {
        this.skyLight = new NibbleArray[16];
        this.blockLight = new NibbleArray[16];
        if (aggressive) {
            this.sections = null;
            this.nmsChunk = null;
            return super.trim(true);
        }
        for (int i = 0; i < 16; ++i) {
            if (!this.hasSection(i) || !((CharGetBlocks)this).sections[i].isFull()) continue;
            ChunkSection existing = this.getSections(true)[i];
            try {
                int paletteSize;
                DataPaletteBlock blocksExisting = existing.getBlocks();
                DataPalette palette = (DataPalette)BukkitAdapter_1_15_2.fieldPalette.get(blocksExisting);
                if (palette instanceof DataPaletteLinear) {
                    paletteSize = ((DataPaletteLinear)palette).b();
                } else if (palette instanceof DataPaletteHash) {
                    paletteSize = ((DataPaletteHash)palette).b();
                } else {
                    super.trim(false, i);
                    continue;
                }
                if (paletteSize == 1) continue;
                super.trim(false, i);
                continue;
            }
            catch (IllegalAccessException ignored) {
                super.trim(false, i);
            }
        }
        return true;
    }
}

