/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.adapter.mc1_16_2;

import com.sk89q.util.ReflectionUtil;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import net.minecraft.server.v1_16_R2.Block;
import net.minecraft.server.v1_16_R2.BlockAccessAir;
import net.minecraft.server.v1_16_R2.BlockBase;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.EnumPistonReaction;
import net.minecraft.server.v1_16_R2.IBlockAccess;
import net.minecraft.server.v1_16_R2.IBlockData;
import net.minecraft.server.v1_16_R2.ITileEntity;
import net.minecraft.server.v1_16_R2.Material;
import org.bukkit.craftbukkit.v1_16_R2.block.data.CraftBlockData;

public class BlockMaterial_1_16_2
implements BlockMaterial {
    private final Block block;
    private final IBlockData defaultState;
    private final Material material;
    private final boolean isTranslucent;
    private final CraftBlockData craftBlockData;
    private final org.bukkit.Material craftMaterial;
    private final int opacity;

    public BlockMaterial_1_16_2(Block block) {
        this(block, block.getBlockData());
    }

    public BlockMaterial_1_16_2(Block block, IBlockData defaultState) {
        this.block = block;
        this.defaultState = defaultState;
        this.material = defaultState.getMaterial();
        this.craftBlockData = CraftBlockData.fromData((IBlockData)defaultState);
        this.craftMaterial = this.craftBlockData.getMaterial();
        BlockBase.Info blockInfo = (BlockBase.Info)ReflectionUtil.getField(Block.class, block, "aB");
        this.isTranslucent = (Boolean)ReflectionUtil.getField(BlockBase.Info.class, blockInfo, "n") == false;
        this.opacity = defaultState.b((IBlockAccess)BlockAccessAir.INSTANCE, BlockPosition.ZERO);
    }

    public Block getBlock() {
        return this.block;
    }

    public IBlockData getState() {
        return this.defaultState;
    }

    public CraftBlockData getCraftBlockData() {
        return this.craftBlockData;
    }

    public Material getMaterial() {
        return this.material;
    }

    @Override
    public boolean isAir() {
        return this.defaultState.isAir();
    }

    @Override
    public boolean isFullCube() {
        return this.craftMaterial.isOccluding();
    }

    @Override
    public boolean isOpaque() {
        return this.material.f();
    }

    @Override
    public boolean isPowerSource() {
        return this.defaultState.isPowerSource();
    }

    @Override
    public boolean isLiquid() {
        return this.material.isLiquid();
    }

    @Override
    public boolean isSolid() {
        return this.material.isBuildable();
    }

    @Override
    public float getHardness() {
        return this.craftBlockData.getState().strength;
    }

    @Override
    public float getResistance() {
        return this.block.getDurability();
    }

    @Override
    public float getSlipperiness() {
        return this.block.getFrictionFactor();
    }

    @Override
    public int getLightValue() {
        return this.defaultState.f();
    }

    @Override
    public int getLightOpacity() {
        return this.opacity;
    }

    @Override
    public boolean isFragileWhenPushed() {
        return this.material.getPushReaction() == EnumPistonReaction.DESTROY;
    }

    @Override
    public boolean isUnpushable() {
        return this.material.getPushReaction() == EnumPistonReaction.BLOCK;
    }

    @Override
    public boolean isTicksRandomly() {
        return this.block.isTicking(this.defaultState);
    }

    @Override
    public boolean isMovementBlocker() {
        return this.material.isSolid();
    }

    @Override
    public boolean isBurnable() {
        return this.material.isBurnable();
    }

    @Override
    public boolean isToolRequired() {
        return true;
    }

    @Override
    public boolean isReplacedDuringPlacement() {
        return this.material.isReplaceable();
    }

    @Override
    public boolean isTranslucent() {
        return this.isTranslucent;
    }

    @Override
    public boolean hasContainer() {
        return this.block instanceof ITileEntity;
    }

    @Override
    public int getMapColor() {
        return this.material.h().rgb;
    }
}

