/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.adapter.mc1_16_4;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.bukkit.adapter.mc1_16_4.BukkitAdapter_1_16_4;
import com.boydti.fawe.object.IntPair;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.util.TaskManager;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.FAWE_Spigot_v1_16_R3;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.block.BlockState;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.Chunk;
import net.minecraft.server.v1_16_R3.ChunkProviderServer;
import net.minecraft.server.v1_16_R3.EnumDirection;
import net.minecraft.server.v1_16_R3.GeneratorAccess;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.MinecraftServer;
import net.minecraft.server.v1_16_R3.NBTBase;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.PlayerChunk;
import net.minecraft.server.v1_16_R3.TileEntity;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;

public class FAWEWorldNativeAccess_1_16_R3
implements WorldNativeAccess<Chunk, IBlockData, BlockPosition> {
    private static final int UPDATE = 1;
    private static final int NOTIFY = 2;
    private final FAWE_Spigot_v1_16_R3 adapter;
    private final WeakReference<World> world;
    private SideEffectSet sideEffectSet;
    private final AtomicInteger lastTick;
    private final Set<CachedChange> cachedChanges = new HashSet<CachedChange>();
    private final Set<IntPair> cachedChunksToSend = new HashSet<IntPair>();
    private static final EnumDirection[] NEIGHBOUR_ORDER = new EnumDirection[]{EnumDirection.WEST, EnumDirection.EAST, EnumDirection.DOWN, EnumDirection.UP, EnumDirection.NORTH, EnumDirection.SOUTH};

    public FAWEWorldNativeAccess_1_16_R3(FAWE_Spigot_v1_16_R3 adapter, WeakReference<World> world) {
        this.adapter = adapter;
        this.world = world;
        this.lastTick = new AtomicInteger(MinecraftServer.currentTick);
    }

    private World getWorld() {
        return (World)Objects.requireNonNull(this.world.get(), "The reference to the world was lost");
    }

    @Override
    public void setCurrentSideEffectSet(SideEffectSet sideEffectSet) {
        this.sideEffectSet = sideEffectSet;
    }

    @Override
    public Chunk getChunk(int x, int z) {
        return this.getWorld().getChunkAt(x, z);
    }

    @Override
    public IBlockData toNative(BlockState state) {
        int stateId = this.adapter.ordinalToIbdID(state.getOrdinalChar());
        return BlockStateIdAccess.isValidInternalId(stateId) ? Block.getByCombinedId((int)stateId) : ((CraftBlockData)BukkitAdapter.adapt(state)).getState();
    }

    @Override
    public IBlockData getBlockState(Chunk chunk, BlockPosition position) {
        return chunk.getType(position);
    }

    @Override
    @Nullable
    public synchronized IBlockData setBlockState(Chunk chunk, BlockPosition position, IBlockData state) {
        boolean nextTick;
        int currentTick = MinecraftServer.currentTick;
        if (Fawe.isMainThread()) {
            return chunk.setType(position, state, this.sideEffectSet != null && this.sideEffectSet.shouldApply(SideEffect.UPDATE));
        }
        this.cachedChanges.add(new CachedChange(chunk, position, state));
        this.cachedChunksToSend.add(new IntPair(chunk.bukkitChunk.getX(), chunk.bukkitChunk.getZ()));
        boolean bl = nextTick = this.lastTick.get() > currentTick;
        if (nextTick || this.cachedChanges.size() >= 1024) {
            if (nextTick) {
                this.lastTick.set(currentTick);
            }
            this.flushAsync(nextTick);
        }
        return state;
    }

    @Override
    public IBlockData getValidBlockForPosition(IBlockData block, BlockPosition position) {
        return Block.b((IBlockData)block, (GeneratorAccess)this.getWorld(), (BlockPosition)position);
    }

    @Override
    public BlockPosition getPosition(int x, int y, int z) {
        return new BlockPosition(x, y, z);
    }

    @Override
    public void updateLightingForBlock(BlockPosition position) {
        this.getWorld().getChunkProvider().getLightEngine().a(position);
    }

    @Override
    public boolean updateTileEntity(BlockPosition position, CompoundTag tag) {
        TileEntity tileEntity = this.getWorld().getTileEntity(position);
        if (tileEntity == null) {
            return false;
        }
        NBTBase nativeTag = this.adapter.fromNative(tag);
        tileEntity.load(tileEntity.getBlock(), (NBTTagCompound)nativeTag);
        return true;
    }

    @Override
    public void notifyBlockUpdate(BlockPosition position, IBlockData oldState, IBlockData newState) {
        this.getWorld().notify(position, oldState, newState, 3);
    }

    @Override
    public boolean isChunkTicking(Chunk chunk) {
        return chunk.getState().isAtLeast(PlayerChunk.State.TICKING);
    }

    @Override
    public void markBlockChanged(BlockPosition position) {
        ((ChunkProviderServer)this.getWorld().getChunkProvider()).flagDirty(position);
    }

    @Override
    public void notifyNeighbors(BlockPosition pos, IBlockData oldState, IBlockData newState) {
        World world = this.getWorld();
        if (this.sideEffectSet.shouldApply(SideEffect.EVENTS)) {
            world.update(pos, oldState.getBlock());
        } else {
            for (EnumDirection direction : NEIGHBOUR_ORDER) {
                BlockPosition shifted = pos.shift(direction);
                world.getType(shifted).doPhysics(world, shifted, oldState.getBlock(), pos, false);
            }
        }
        if (newState.isComplexRedstone()) {
            world.updateAdjacentComparators(pos, newState.getBlock());
        }
    }

    @Override
    public void updateNeighbors(BlockPosition pos, IBlockData oldState, IBlockData newState, int recursionLimit) {
        CraftWorld craftWorld;
        World world = this.getWorld();
        oldState.b((GeneratorAccess)world, pos, 2, recursionLimit);
        if (this.sideEffectSet.shouldApply(SideEffect.EVENTS) && (craftWorld = world.getWorld()) != null) {
            BlockPhysicsEvent event = new BlockPhysicsEvent(craftWorld.getBlockAt(pos.getX(), pos.getY(), pos.getZ()), (BlockData)CraftBlockData.fromData((IBlockData)newState));
            world.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        newState.a(world, pos, 2, recursionLimit);
        newState.b((GeneratorAccess)world, pos, 2, recursionLimit);
    }

    @Override
    public void onBlockStateChange(BlockPosition pos, IBlockData oldState, IBlockData newState) {
        this.getWorld().a(pos, oldState, newState);
    }

    private synchronized void flushAsync(final boolean sendChunks) {
        Set<Object> toSend;
        final Set<CachedChange> changes = Collections.unmodifiableSet(this.cachedChanges);
        this.cachedChanges.clear();
        if (sendChunks) {
            toSend = Collections.unmodifiableSet(this.cachedChunksToSend);
            this.cachedChunksToSend.clear();
        } else {
            toSend = Collections.emptySet();
        }
        RunnableVal<Object> r = new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                changes.forEach(cc -> ((CachedChange)cc).chunk.setType(((CachedChange)cc).position, ((CachedChange)cc).blockData, FAWEWorldNativeAccess_1_16_R3.this.sideEffectSet != null && FAWEWorldNativeAccess_1_16_R3.this.sideEffectSet.shouldApply(SideEffect.UPDATE)));
                if (!sendChunks) {
                    return;
                }
                for (IntPair chunk : toSend) {
                    BukkitAdapter_1_16_4.sendChunk(FAWEWorldNativeAccess_1_16_R3.this.getWorld().getWorld().getHandle(), chunk.x, chunk.z, 0, false);
                }
            }
        };
        TaskManager.IMP.async(() -> TaskManager.IMP.sync(r));
    }

    @Override
    public synchronized void flush() {
        RunnableVal<Object> r = new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                FAWEWorldNativeAccess_1_16_R3.this.cachedChanges.forEach(cc -> ((CachedChange)cc).chunk.setType(((CachedChange)cc).position, ((CachedChange)cc).blockData, FAWEWorldNativeAccess_1_16_R3.this.sideEffectSet != null && FAWEWorldNativeAccess_1_16_R3.this.sideEffectSet.shouldApply(SideEffect.UPDATE)));
                for (IntPair chunk : FAWEWorldNativeAccess_1_16_R3.this.cachedChunksToSend) {
                    BukkitAdapter_1_16_4.sendChunk(FAWEWorldNativeAccess_1_16_R3.this.getWorld().getWorld().getHandle(), chunk.x, chunk.z, 0, false);
                }
            }
        };
        if (Fawe.isMainThread()) {
            r.run();
        } else {
            TaskManager.IMP.sync(r);
        }
        this.cachedChanges.clear();
        this.cachedChunksToSend.clear();
    }

    private static final class CachedChange {
        private final Chunk chunk;
        private final BlockPosition position;
        private final IBlockData blockData;

        private CachedChange(Chunk chunk, BlockPosition position, IBlockData blockData) {
            this.chunk = chunk;
            this.position = position;
            this.blockData = blockData;
        }
    }
}

