/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.filter;

import com.boydti.fawe.regions.general.CuboidRegionFilter;
import com.boydti.fawe.util.TaskManager;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.math.BlockVector2;
import java.util.ArrayDeque;
import java.util.Collection;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.World;

public class GriefPreventionFilter
extends CuboidRegionFilter {
    private final Collection<Claim> claims;
    private final World world;

    public GriefPreventionFilter(World world) {
        Preconditions.checkNotNull((Object)world);
        this.claims = TaskManager.IMP.sync(() -> new ArrayDeque(GriefPrevention.instance.dataStore.getClaims()));
        this.world = world;
    }

    @Override
    public void calculateRegions() {
        for (Claim claim : this.claims) {
            Location bot = claim.getGreaterBoundaryCorner();
            if (!this.world.equals(bot.getWorld())) continue;
            Location top = claim.getGreaterBoundaryCorner();
            BlockVector2 pos1 = BlockVector2.at(bot.getBlockX(), bot.getBlockZ());
            BlockVector2 pos2 = BlockVector2.at(top.getBlockX(), top.getBlockZ());
            this.add(pos1, pos2);
        }
    }
}

