/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.listener;

import com.boydti.fawe.object.brush.MovableTool;
import com.boydti.fawe.object.brush.ResettableTool;
import com.boydti.fawe.object.brush.scroll.ScrollTool;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.command.tool.Tool;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class BrushListener
implements Listener {
    public BrushListener(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerItemHoldEvent(PlayerItemHeldEvent event) {
        int oldSlot;
        int slot;
        int ri;
        ScrollTool scrollable;
        Player bukkitPlayer = event.getPlayer();
        if (bukkitPlayer.isSneaking()) {
            return;
        }
        BukkitPlayer player = BukkitAdapter.adapt(bukkitPlayer);
        LocalSession session = player.getSession();
        Tool tool = session.getTool(player);
        if (tool instanceof ScrollTool && (scrollable = (ScrollTool)((Object)tool)).increment(player, ri = (slot = event.getNewSlot()) - (oldSlot = event.getPreviousSlot()) <= 4 && slot - oldSlot > 0 || slot - oldSlot < -4 ? 1 : -1)) {
            bukkitPlayer.getInventory().setHeldItemSlot(oldSlot);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player bukkitPlayer;
        BukkitPlayer player;
        LocalSession session;
        Tool tool;
        Location from = event.getFrom();
        Location to = event.getTo();
        if ((from.getYaw() != to.getYaw() && from.getPitch() != to.getPitch() || from.getBlockX() != to.getBlockX() || from.getBlockZ() != to.getBlockZ() || from.getBlockY() != to.getBlockY()) && (tool = (session = (player = BukkitAdapter.adapt(bukkitPlayer = event.getPlayer())).getSession()).getTool(player)) != null && tool instanceof MovableTool) {
            ((MovableTool)((Object)tool)).move(player);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player bukkitPlayer = event.getPlayer();
        if (bukkitPlayer.isSneaking()) {
            if (event.getAction() == Action.PHYSICAL) {
                return;
            }
            BukkitPlayer player = BukkitAdapter.adapt(bukkitPlayer);
            LocalSession session = player.getSession();
            Tool tool = session.getTool(player);
            if (tool instanceof ResettableTool && ((ResettableTool)((Object)tool)).reset()) {
                event.setCancelled(true);
            }
        }
    }
}

