/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.listener;

import com.boydti.fawe.bukkit.util.image.BukkitImageViewer;
import com.boydti.fawe.object.brush.visualization.cfi.HeightMapMCAGenerator;
import com.boydti.fawe.util.image.ImageViewer;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class BukkitImageListener
implements Listener {
    private Location mutable = new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0);

    public BukkitImageListener(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onHangingBreakByEntity(HangingBreakByEntityEvent event) {
        if (!(event.getRemover() instanceof Player)) {
            return;
        }
        this.handleInteract((Event)event, (Player)event.getRemover(), (Entity)event.getEntity(), false);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        this.handleInteract((Event)event, (Player)event.getDamager(), event.getEntity(), false);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        Player player = event.getPlayer();
        BukkitPlayer bukkitPlayer = BukkitAdapter.adapt(player);
        if (bukkitPlayer.getMeta("CFISettings") == null) {
            return;
        }
        try {
            if (event.getHand() == EquipmentSlot.OFF_HAND) {
                return;
            }
        }
        catch (NoSuchFieldError | NoSuchMethodError incompatibleClassChangeError) {
            // empty catch block
        }
        List target = player.getLastTwoTargetBlocks(null, 100);
        if (target.isEmpty()) {
            return;
        }
        Block targetBlock = (Block)target.get(0);
        World world = player.getWorld();
        this.mutable.setWorld(world);
        this.mutable.setX((double)targetBlock.getX() + 0.5);
        this.mutable.setY((double)targetBlock.getY() + 0.5);
        this.mutable.setZ((double)targetBlock.getZ() + 0.5);
        Collection entities = world.getNearbyEntities(this.mutable, 0.46875, 0.0, 0.46875);
        if (!entities.isEmpty()) {
            Action action = event.getAction();
            boolean primary = action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK;
            double minDist = 2.147483647E9;
            ItemFrame minItemFrame = null;
            for (Entity entity : entities) {
                double dz;
                double dy;
                ItemFrame itemFrame;
                Location loc;
                double dx;
                double dist;
                if (!(entity instanceof ItemFrame) || !((dist = (dx = (loc = (itemFrame = (ItemFrame)entity).getLocation()).getX() - this.mutable.getX()) * dx + (dy = loc.getY() - this.mutable.getY()) * dy + (dz = loc.getZ() - this.mutable.getZ()) * dz) < minDist)) continue;
                minItemFrame = itemFrame;
                minDist = dist;
            }
            if (minItemFrame != null) {
                this.handleInteract((PlayerEvent)event, (Entity)minItemFrame, primary);
                if (event.isCancelled()) {
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        this.handleInteract((PlayerEvent)event, event.getRightClicked(), true);
    }

    private BukkitImageViewer get(HeightMapMCAGenerator generator) {
        if (generator == null) {
            return null;
        }
        ImageViewer viewer = generator.getImageViewer();
        if (!(viewer instanceof BukkitImageViewer)) {
            return null;
        }
        return (BukkitImageViewer)viewer;
    }

    private void handleInteract(PlayerEvent event, Entity entity, boolean primary) {
        this.handleInteract((Event)event, event.getPlayer(), entity, primary);
    }

    private void handleInteract(Event event, Player player, Entity entity, boolean primary) {
    }
}

