/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.listener;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.object.RunnableVal3;
import com.boydti.fawe.object.brush.visualization.VirtualWorld;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.ChunkCoordIntPair;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.event.platform.BlockInteractEvent;
import com.sk89q.worldedit.event.platform.Interaction;
import com.sk89q.worldedit.extension.platform.PlatformManager;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class CFIPacketListener
implements Listener {
    private final Plugin plugin;
    private final ProtocolManager protocolmanager;

    public CFIPacketListener(Plugin plugin) {
        this.plugin = plugin;
        this.protocolmanager = ProtocolLibrary.getProtocolManager();
        this.registerBlockEvent(PacketType.Play.Client.BLOCK_DIG, false, new RunnableVal3<PacketEvent, VirtualWorld, BlockVector3>(){

            @Override
            public void run(PacketEvent event, VirtualWorld gen, BlockVector3 pt) {
                try {
                    Player plr = event.getPlayer();
                    BlockVector3 realPos = pt.add(gen.getOrigin().toBlockPoint());
                    if (!CFIPacketListener.this.sendBlockChange(plr, gen, pt, Interaction.HIT)) {
                        gen.setBlock(pt, BlockTypes.AIR.getDefaultState());
                    }
                }
                catch (WorldEditException e) {
                    e.printStackTrace();
                }
            }
        });
        RunnableVal3<PacketEvent, VirtualWorld, BlockVector3> placeTask = new RunnableVal3<PacketEvent, VirtualWorld, BlockVector3>(){

            @Override
            public void run(PacketEvent event, VirtualWorld gen, BlockVector3 pt) {
                try {
                    ItemStack hand;
                    Player plr = event.getPlayer();
                    List hands = event.getPacket().getHands().getValues();
                    EnumWrappers.Hand enumHand = hands.isEmpty() ? EnumWrappers.Hand.MAIN_HAND : (EnumWrappers.Hand)hands.get(0);
                    PlayerInventory inv = plr.getInventory();
                    ItemStack itemStack = hand = enumHand == EnumWrappers.Hand.MAIN_HAND ? inv.getItemInMainHand() : inv.getItemInOffHand();
                    if (hand.getType().isBlock()) {
                        Material type = hand.getType();
                        switch (type) {
                            case AIR: 
                            case CAVE_AIR: 
                            case VOID_AIR: {
                                break;
                            }
                            default: {
                                BlockState block = BukkitAdapter.asBlockState(hand);
                                if (block == null) break;
                                gen.setBlock(pt, block);
                                return;
                            }
                        }
                    }
                    pt = CFIPacketListener.this.getRelPos(event, gen);
                    CFIPacketListener.this.sendBlockChange(plr, gen, pt, Interaction.OPEN);
                }
                catch (WorldEditException e) {
                    e.printStackTrace();
                }
            }
        };
        this.registerBlockEvent(PacketType.Play.Client.BLOCK_PLACE, true, placeTask);
        this.registerBlockEvent(PacketType.Play.Client.USE_ITEM, true, placeTask);
        this.registerBlockEvent(PacketType.Play.Server.BLOCK_CHANGE, false, new RunnableVal3<PacketEvent, VirtualWorld, BlockVector3>(){

            @Override
            public void run(PacketEvent event, VirtualWorld gen, BlockVector3 pt) {
            }
        });
        this.protocolmanager.addPacketListener((PacketListener)new PacketAdapter(plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.MAP_CHUNK}){

            public void onPacketSending(PacketEvent event) {
                if (!event.isServerPacket() || ((AtomicBoolean)FaweCache.IMP.CHUNK_FLAG.get()).get()) {
                    return;
                }
                VirtualWorld gen = CFIPacketListener.this.getGenerator(event);
                if (gen != null) {
                    int ocz;
                    BlockVector3 origin = gen.getOrigin().toBlockPoint();
                    PacketContainer packet = event.getPacket();
                    StructureModifier ints = packet.getIntegers();
                    int cx = (Integer)ints.read(0);
                    int cz = (Integer)ints.read(1);
                    int ocx = origin.getBlockX() >> 4;
                    if (gen.contains(BlockVector3.at(cx - ocx << 4, 0, cz - (ocz = origin.getBlockZ() >> 4) << 4))) {
                        event.setCancelled(true);
                        gen.refreshChunk(cx - ocx, cz - ocz);
                    }
                }
            }
        });
        this.protocolmanager.addPacketListener((PacketListener)new PacketAdapter(plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.ENTITY_VELOCITY}){

            public void onPacketSending(PacketEvent event) {
                if (!event.isServerPacket()) {
                    return;
                }
                Player player = event.getPlayer();
                Location pos = player.getLocation();
                VirtualWorld gen = CFIPacketListener.this.getGenerator(event);
                if (gen != null) {
                    BlockVector3 origin = gen.getOrigin().toBlockPoint();
                    BlockVector3 pt = BlockVector3.at(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ());
                    StructureModifier ints = event.getPacket().getIntegers();
                    int id = (Integer)ints.read(0);
                    int mx = (Integer)ints.read(1);
                    int my = (Integer)ints.read(2);
                    int mz = (Integer)ints.read(3);
                    if (gen.contains(pt.subtract(origin)) && mx == 0 && my == 0 && mz == 0) {
                        event.setCancelled(true);
                    }
                }
            }
        });
        this.protocolmanager.addPacketListener((PacketListener)new PacketAdapter(plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.POSITION}){

            public void onPacketSending(PacketEvent event) {
                if (!event.isServerPacket()) {
                    return;
                }
                Player player = event.getPlayer();
                Location pos = player.getLocation();
                VirtualWorld gen = CFIPacketListener.this.getGenerator(event);
                if (gen != null) {
                    BlockVector3 origin = gen.getOrigin().toBlockPoint();
                    BlockVector3 from = BlockVector3.at(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ());
                    PacketContainer packet = event.getPacket();
                    StructureModifier doubles = packet.getDoubles();
                    BlockVector3 to = BlockVector3.at((Double)doubles.read(0), (Double)doubles.read(1), (Double)doubles.read(2));
                    if (gen.contains(to.subtract(origin)) && from.distanceSq(to) < 8) {
                        int id = (Integer)packet.getIntegers().read(0);
                        PacketContainer reply = new PacketContainer(PacketType.Play.Client.TELEPORT_ACCEPT);
                        reply.getIntegers().write(0, (Object)id);
                        try {
                            CFIPacketListener.this.protocolmanager.recieveClientPacket(player, reply);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        event.setCancelled(true);
                    }
                }
            }
        });
        this.protocolmanager.addPacketListener((PacketListener)new PacketAdapter(plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.MULTI_BLOCK_CHANGE}){

            public void onPacketSending(PacketEvent event) {
                if (!event.isServerPacket()) {
                    return;
                }
                VirtualWorld gen = CFIPacketListener.this.getGenerator(event);
                if (gen != null) {
                    int cz;
                    PacketContainer packet = event.getPacket();
                    ChunkCoordIntPair chunk = (ChunkCoordIntPair)packet.getChunkCoordIntPairs().read(0);
                    BlockVector3 origin = gen.getOrigin().toBlockPoint();
                    int cx = chunk.getChunkX() - (origin.getBlockX() >> 4);
                    if (gen.contains(BlockVector3.at(cx << 4, 0, (cz = chunk.getChunkZ() - (origin.getBlockX() >> 4)) << 4))) {
                        event.setCancelled(true);
                    }
                }
            }
        });
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        VirtualWorld gen = this.getGenerator(player);
        if (gen != null) {
            Location from = event.getFrom();
            Location to = event.getTo();
            if (to.getWorld().equals(from.getWorld()) && to.distanceSquared(from) < 8.0) {
                event.setTo(player.getLocation());
                event.setCancelled(true);
                player.setVelocity(player.getVelocity());
            }
        }
    }

    private boolean sendBlockChange(Player plr, VirtualWorld gen, BlockVector3 pt, Interaction action) {
        PlatformManager platform = WorldEdit.getInstance().getPlatformManager();
        BukkitPlayer actor = BukkitAdapter.adapt(plr);
        com.sk89q.worldedit.util.Location location = new com.sk89q.worldedit.util.Location(actor.getWorld(), pt.toVector3());
        BlockInteractEvent toCall = new BlockInteractEvent(actor, location, action);
        platform.handleBlockInteract(toCall);
        if (toCall.isCancelled() || action == Interaction.OPEN) {
            BlockVector3 realPos = pt.add(gen.getOrigin().toBlockPoint());
            BlockState block = gen.getBlock(pt);
            this.sendBlockChange(plr, realPos, block);
            return true;
        }
        return false;
    }

    private void sendBlockChange(Player plr, BlockVector3 pt, BlockState block) {
        plr.sendBlockChange(new Location(plr.getWorld(), (double)pt.getBlockX(), (double)pt.getBlockY(), (double)pt.getBlockZ()), BukkitAdapter.adapt(block));
    }

    private VirtualWorld getGenerator(PacketEvent event) {
        return this.getGenerator(event.getPlayer());
    }

    private VirtualWorld getGenerator(Player player) {
        BukkitPlayer bukkitPlayer = BukkitAdapter.adapt(player);
        VirtualWorld vw = bukkitPlayer.getSession().getVirtualWorld();
        if (vw != null) {
            return vw;
        }
        return null;
    }

    private BlockVector3 getRelPos(PacketEvent event, VirtualWorld generator) {
        PacketContainer packet = event.getPacket();
        StructureModifier position = packet.getBlockPositionModifier();
        BlockPosition loc = (BlockPosition)position.readSafely(0);
        if (loc == null) {
            return null;
        }
        BlockVector3 origin = generator.getOrigin().toBlockPoint();
        return BlockVector3.at(loc.getX() - origin.getBlockX(), loc.getY() - origin.getBlockY(), loc.getZ() - origin.getBlockZ());
    }

    private void handleBlockEvent(PacketEvent event, boolean relative, RunnableVal3<PacketEvent, VirtualWorld, BlockVector3> task) {
        BlockVector3 pt;
        VirtualWorld gen = this.getGenerator(event);
        if (gen != null && (pt = this.getRelPos(event, gen)) != null) {
            if (relative) {
                pt = this.getRelative(event, pt);
            }
            if (gen.contains(pt)) {
                event.setCancelled(true);
                task.run(event, gen, pt);
            }
        }
    }

    private void registerBlockEvent(final PacketType type, final boolean relative, final RunnableVal3<PacketEvent, VirtualWorld, BlockVector3> task) {
        this.protocolmanager.addPacketListener((PacketListener)new PacketAdapter(this.plugin, ListenerPriority.NORMAL, new PacketType[]{type}){

            public void onPacketReceiving(PacketEvent event) {
                if (type.isClient() || event.isServerPacket()) {
                    CFIPacketListener.this.handleBlockEvent(event, relative, task);
                }
            }

            public void onPacketSending(PacketEvent event) {
                this.onPacketReceiving(event);
            }
        });
    }

    private BlockVector3 getRelative(PacketEvent container, BlockVector3 pt) {
        PacketContainer packet = container.getPacket();
        StructureModifier dirs = packet.getDirections();
        EnumWrappers.Direction dir = (EnumWrappers.Direction)dirs.readSafely(0);
        if (dir == null) {
            return pt;
        }
        switch (dir.ordinal()) {
            case 0: {
                return pt.add(0, -1, 0);
            }
            case 1: {
                return pt.add(0, 1, 0);
            }
            case 2: {
                return pt.add(0, 0, -1);
            }
            case 3: {
                return pt.add(0, 0, 1);
            }
            case 4: {
                return pt.add(-1, 0, 0);
            }
            case 5: {
                return pt.add(1, 0, 0);
            }
        }
        return pt;
    }
}

