/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.preloader;

import com.boydti.fawe.Fawe;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginBase;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginPreloader
extends PluginBase {
    private org.bukkit.World world;
    private Set<BlockVector2> loaded;
    private int index;
    private AtomicBoolean invalidator = new AtomicBoolean();
    private final Object invalidatorLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicBoolean invalidate() {
        Object object = this.invalidatorLock;
        synchronized (object) {
            this.invalidator.set(false);
            this.invalidator = new AtomicBoolean(true);
            return this.invalidator;
        }
    }

    private synchronized void unload() {
        org.bukkit.World oldWorld = this.world;
        if (oldWorld != null) {
            Set<BlockVector2> toUnload = this.loaded;
            if (this.loaded != null && this.index > 0) {
                Iterator<BlockVector2> iter = toUnload.iterator();
                Fawe.get().getQueueHandler().sync(() -> {
                    for (int i = 0; i < this.index && iter.hasNext(); ++i) {
                        BlockVector2 chunk = (BlockVector2)iter.next();
                        this.world.removePluginChunkTicket(chunk.getX(), chunk.getZ(), (Plugin)this);
                    }
                });
            }
        }
        this.world = null;
        this.loaded = null;
        this.index = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Region region) {
        AtomicBoolean invalidator = this.invalidate();
        PluginPreloader pluginPreloader = this;
        synchronized (pluginPreloader) {
            World weWorld = region.getWorld();
            if (weWorld == null) {
                return;
            }
            this.unload();
            this.index = 0;
            this.world = BukkitAdapter.adapt(weWorld);
            this.loaded = region.getChunks();
            Iterator<BlockVector2> iter = this.loaded.iterator();
            if (!invalidator.get()) {
                return;
            }
            Fawe.get().getQueueHandler().syncWhenFree(() -> {
                while (iter.hasNext() && invalidator.get()) {
                    BlockVector2 chunk = (BlockVector2)iter.next();
                    if (!this.world.isChunkLoaded(chunk.getX(), chunk.getZ())) {
                        this.world.addPluginChunkTicket(chunk.getX(), chunk.getZ(), (Plugin)this);
                    }
                    ++this.index;
                }
            });
        }
    }

    public void clear() {
        this.invalidate();
        this.unload();
    }

    @NotNull
    public File getDataFolder() {
        return null;
    }

    @NotNull
    public PluginDescriptionFile getDescription() {
        return null;
    }

    @NotNull
    public FileConfiguration getConfig() {
        return null;
    }

    @Nullable
    public InputStream getResource(@NotNull String filename) {
        return null;
    }

    public void saveConfig() {
    }

    public void saveDefaultConfig() {
    }

    public void saveResource(@NotNull String resourcePath, boolean replace) {
    }

    public void reloadConfig() {
    }

    @NotNull
    public PluginLoader getPluginLoader() {
        return null;
    }

    @NotNull
    public Server getServer() {
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public void onDisable() {
    }

    public void onLoad() {
    }

    public void onEnable() {
    }

    public boolean isNaggable() {
        return false;
    }

    public void setNaggable(boolean canNag) {
    }

    @Nullable
    public ChunkGenerator getDefaultWorldGenerator(@NotNull String worldName, @Nullable String id) {
        return null;
    }

    @NotNull
    public Logger getLogger() {
        return null;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        return null;
    }
}

