/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions;

import com.boydti.fawe.bukkit.regions.BukkitMaskManager;
import com.boydti.fawe.bukkit.wrapper.AsyncBlock;
import com.boydti.fawe.bukkit.wrapper.AsyncWorld;
import com.boydti.fawe.regions.FaweMask;
import com.boydti.fawe.regions.FaweMaskManager;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import java.util.ArrayList;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredListener;

public class FreeBuildRegion
extends BukkitMaskManager {
    private final ArrayList<RegisteredListener> listeners = new ArrayList();

    public FreeBuildRegion() {
        super("freebuild");
        RegisteredListener[] listeners;
        for (RegisteredListener listener : listeners = BlockBreakEvent.getHandlerList().getRegisteredListeners()) {
            if (listener.getPriority() == EventPriority.MONITOR || !listener.isIgnoringCancelled()) continue;
            this.listeners.add(listener);
        }
    }

    @Override
    public boolean isExclusive() {
        return true;
    }

    @Override
    public FaweMask getMask(Player player, FaweMaskManager.MaskType type) {
        if (type != FaweMaskManager.MaskType.MEMBER) {
            return null;
        }
        ArrayList<RegisteredListener> currRegList = new ArrayList<RegisteredListener>();
        for (RegisteredListener listener : this.listeners) {
            String name = listener.getPlugin().getName();
            if (!player.hasPermission("fawe.freebuild." + name.toLowerCase(Locale.ROOT))) continue;
            currRegList.add(listener);
        }
        if (currRegList.isEmpty()) {
            return null;
        }
        final RegisteredListener[] listeners = currRegList.toArray(new RegisteredListener[0]);
        final World bukkitWorld = BukkitAdapter.adapt(player.getWorld());
        AsyncWorld asyncWorld = AsyncWorld.wrap(bukkitWorld);
        BlockVector3 pos1 = BlockVector3.ZERO;
        BlockVector3 pos2 = BlockVector3.ZERO;
        final AsyncBlock block = new AsyncBlock(asyncWorld, 0, 0, 0);
        final BlockBreakEvent event = new BlockBreakEvent((Block)block, ((BukkitPlayer)player).getPlayer());
        return new FaweMask(new CuboidRegion(pos1, pos2)){

            @Override
            public boolean isValid(Player player, FaweMaskManager.MaskType type) {
                return bukkitWorld == BukkitAdapter.adapt(player.getWorld()) && type == FaweMaskManager.MaskType.MEMBER;
            }

            @Override
            public Region getRegion() {
                return new CuboidRegion(BlockVector3.ZERO, BlockVector3.ZERO){
                    private int lastX;
                    private int lastZ;
                    private boolean lastResult;
                    {
                        this.lastX = Integer.MIN_VALUE;
                        this.lastZ = Integer.MIN_VALUE;
                    }

                    @Override
                    public boolean contains(int x, int z) {
                        return this.contains(x, 127, z);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean contains(int x, int y, int z) {
                        if (x == this.lastX && z == this.lastZ) {
                            return this.lastResult;
                        }
                        this.lastX = x;
                        this.lastZ = z;
                        event.setCancelled(false);
                        block.setPosition(x, y, z);
                        try {
                            PluginManager pluginManager = Bukkit.getPluginManager();
                            synchronized (pluginManager) {
                                for (RegisteredListener listener : listeners) {
                                    listener.callEvent((Event)event);
                                }
                            }
                        }
                        catch (EventException e) {
                            throw new RuntimeException(e);
                        }
                        this.lastResult = !event.isCancelled();
                        return this.lastResult;
                    }
                };
            }
        };
    }
}

