/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions;

import com.boydti.fawe.bukkit.filter.GriefPreventionFilter;
import com.boydti.fawe.bukkit.regions.BukkitMaskManager;
import com.boydti.fawe.regions.FaweMask;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.regions.general.RegionFilter;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class GriefPreventionFeature
extends BukkitMaskManager
implements Listener {
    public GriefPreventionFeature(Plugin griefpreventionPlugin) {
        super(griefpreventionPlugin.getName());
        LoggerFactory.getLogger(GriefPreventionFeature.class).debug("Plugin 'GriefPrevention' found. Using it now.");
    }

    public boolean isAllowed(org.bukkit.entity.Player player, Claim claim, FaweMaskManager.MaskType type) {
        return claim != null && (claim.getOwnerName().equalsIgnoreCase(player.getName()) || claim.getOwnerName().equals(player.getUniqueId()) || type == FaweMaskManager.MaskType.MEMBER && claim.allowBuild(player, Material.AIR) == null);
    }

    @Override
    public FaweMask getMask(Player wePlayer, FaweMaskManager.MaskType type) {
        final org.bukkit.entity.Player player = BukkitAdapter.adapt(wePlayer);
        final Claim claim = GriefPrevention.instance.dataStore.getClaimAt(player.getLocation(), true, null);
        if (claim != null && this.isAllowed(player, claim, type)) {
            claim.getGreaterBoundaryCorner().getBlockX();
            BlockVector3 pos1 = BlockVector3.at(claim.getLesserBoundaryCorner().getBlockX(), 0, claim.getLesserBoundaryCorner().getBlockZ());
            BlockVector3 pos2 = BlockVector3.at(claim.getGreaterBoundaryCorner().getBlockX(), 256, claim.getGreaterBoundaryCorner().getBlockZ());
            return new FaweMask(new CuboidRegion(pos1, pos2)){

                @Override
                public boolean isValid(Player wePlayer, FaweMaskManager.MaskType type) {
                    return GriefPreventionFeature.this.isAllowed(player, claim, type);
                }
            };
        }
        return null;
    }

    @Override
    public RegionFilter getFilter(String world) {
        return new GriefPreventionFilter(Bukkit.getWorld((String)world));
    }
}

