/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.boydti.fawe.bukkit.FaweBukkit;
import com.boydti.fawe.bukkit.regions.BukkitMaskManager;
import com.boydti.fawe.regions.FaweMask;
import com.boydti.fawe.regions.FaweMaskManager;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ResidenceFeature
extends BukkitMaskManager
implements Listener {
    private FaweBukkit plugin;
    private Plugin residence;

    public ResidenceFeature(Plugin residencePlugin, FaweBukkit p3) {
        super(residencePlugin.getName());
        this.residence = residencePlugin;
        this.plugin = p3;
        LoggerFactory.getLogger(ResidenceFeature.class).debug("Plugin 'Residence' found. Using it now.");
    }

    public boolean isAllowed(org.bukkit.entity.Player player, ClaimedResidence residence, FaweMaskManager.MaskType type) {
        return residence != null && (residence.getOwner().equals(player.getName()) || residence.getOwner().equals(player.getUniqueId().toString()) || type == FaweMaskManager.MaskType.MEMBER && residence.getPermissions().playerHas(player, "build", false));
    }

    @Override
    public FaweMask getMask(Player wePlayer, FaweMaskManager.MaskType type) {
        org.bukkit.entity.Player player = BukkitAdapter.adapt(wePlayer);
        Location location = player.getLocation();
        ClaimedResidence residence = Residence.getInstance().getResidenceManager().getByLoc(location);
        if (residence != null) {
            boolean isAllowed;
            while (!(isAllowed = this.isAllowed(player, residence, type)) && residence != null) {
                residence = residence.getSubzoneByLoc(location);
            }
            if (isAllowed) {
                CuboidArea area = residence.getAreaArray()[0];
                Location pos1 = area.getLowLoc();
                Location pos2 = area.getHighLoc();
                final ClaimedResidence finalResidence = residence;
                return new FaweMask(new CuboidRegion(BukkitAdapter.asBlockVector(pos1), BukkitAdapter.asBlockVector(pos2))){

                    @Override
                    public boolean isValid(Player player, FaweMaskManager.MaskType type) {
                        return ResidenceFeature.this.isAllowed(BukkitAdapter.adapt(player), finalResidence, type);
                    }
                };
            }
        }
        return null;
    }
}

