/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions;

import com.boydti.fawe.bukkit.regions.BukkitMaskManager;
import com.boydti.fawe.regions.FaweMask;
import com.boydti.fawe.regions.FaweMaskManager;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TownyFeature
extends BukkitMaskManager
implements Listener {
    private final Plugin towny;

    public TownyFeature(Plugin townyPlugin) {
        super(townyPlugin.getName());
        this.towny = townyPlugin;
        LoggerFactory.getLogger(TownyFeature.class).debug("Plugin 'Towny' found. Using it now.");
    }

    public boolean isAllowed(org.bukkit.entity.Player player, TownBlock block) {
        if (block == null) {
            return false;
        }
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            try {
                if (block.getResident().equals(resident)) {
                    return true;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            Town town = block.getTown();
            if (town.isMayor(resident)) {
                return true;
            }
            if (!town.hasResident(resident)) {
                return false;
            }
            if (player.hasPermission("fawe.towny.*")) {
                return true;
            }
            for (String rank : resident.getTownRanks()) {
                if (!player.hasPermission("fawe.towny." + rank)) continue;
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public FaweMask getMask(Player wePlayer, FaweMaskManager.MaskType type) {
        org.bukkit.entity.Player player = BukkitAdapter.adapt(wePlayer);
        Location location = player.getLocation();
        try {
            PlayerCache cache = ((Towny)this.towny).getCache(player);
            WorldCoord mycoord = cache.getLastTownBlock();
            if (mycoord == null) {
                return null;
            }
            final TownBlock myplot = mycoord.getTownBlock();
            if (myplot == null) {
                return null;
            }
            boolean isMember = this.isAllowed(player, myplot);
            if (isMember) {
                Chunk chunk = location.getChunk();
                BlockVector3 pos1 = BlockVector3.at(chunk.getX() * 16, 0, chunk.getZ() * 16);
                BlockVector3 pos2 = BlockVector3.at(chunk.getX() * 16 + 15, 156, chunk.getZ() * 16 + 15);
                return new FaweMask(new CuboidRegion(pos1, pos2)){

                    @Override
                    public boolean isValid(Player player, FaweMaskManager.MaskType type) {
                        return TownyFeature.this.isAllowed(BukkitAdapter.adapt(player), myplot);
                    }
                };
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

