/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions;

import com.boydti.fawe.bukkit.filter.WorldGuardFilter;
import com.boydti.fawe.bukkit.regions.BukkitMaskManager;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.regions.FaweMask;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.regions.general.RegionFilter;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.GlobalProtectedRegion;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class Worldguard
extends BukkitMaskManager
implements Listener {
    private final WorldGuardPlugin worldguard = this.getWorldGuard();
    private static final Logger logger = LoggerFactory.getLogger(Worldguard.class);

    private WorldGuardPlugin getWorldGuard() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("WorldGuard");
        if (!(plugin instanceof WorldGuardPlugin)) {
            return null;
        }
        return (WorldGuardPlugin)plugin;
    }

    public Worldguard(Plugin p2) {
        super(p2.getName());
        logger.debug("Plugin 'WorldGuard' found. Using it now.");
    }

    public ProtectedRegion getRegion(LocalPlayer player, Location location) {
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        if (container == null) {
            logger.info("Region capability is not enabled for WorldGuard.");
            return null;
        }
        RegionManager manager = container.get(BukkitAdapter.adapt(location.getWorld()));
        if (manager == null) {
            logger.info("Region capability is not enabled for that world.");
            return null;
        }
        ProtectedRegion global = manager.getRegion("__global__");
        if (global != null && this.isAllowed(player, global)) {
            return global;
        }
        ApplicableRegionSet regions = manager.getApplicableRegions(BlockVector3.at(location.getX(), location.getY(), location.getZ()));
        if (player.hasPermission("fawe.worldguardflag") && !regions.testState((RegionAssociable)player, new StateFlag[]{Flags.BUILD, Flags.BLOCK_PLACE, Flags.BLOCK_BREAK})) {
            return null;
        }
        for (ProtectedRegion region : regions) {
            if (!this.isAllowed(player, region)) continue;
            return region;
        }
        return null;
    }

    public boolean isAllowed(LocalPlayer localplayer, ProtectedRegion region) {
        if (region.isOwner(localplayer) || region.isOwner(localplayer.getName())) {
            return true;
        }
        if (region.getId().toLowerCase(Locale.ROOT).equals(localplayer.getName().toLowerCase(Locale.ROOT))) {
            return true;
        }
        if (region.getId().toLowerCase(Locale.ROOT).contains(localplayer.getName().toLowerCase(Locale.ROOT) + "//")) {
            return true;
        }
        if (region.isOwner("*")) {
            return true;
        }
        if (localplayer.hasPermission("fawe.worldguard.member")) {
            if (region.isMember(localplayer) || region.isMember(localplayer.getName())) {
                return true;
            }
            return region.isMember("*");
        }
        return false;
    }

    @Override
    public FaweMask getMask(Player wePlayer, FaweMaskManager.MaskType type) {
        Location location;
        org.bukkit.entity.Player player = BukkitAdapter.adapt(wePlayer);
        LocalPlayer localplayer = this.worldguard.wrapPlayer(player);
        final ProtectedRegion myregion = this.getRegion(localplayer, location = player.getLocation());
        if (myregion != null) {
            BlockVector3 pos2;
            BlockVector3 pos1;
            if (myregion.getId().equals("__global__")) {
                pos1 = BlockVector3.at(Integer.MIN_VALUE, 0, Integer.MIN_VALUE);
                pos2 = BlockVector3.at(Integer.MAX_VALUE, 255, Integer.MAX_VALUE);
            } else if (myregion instanceof ProtectedCuboidRegion) {
                pos1 = BlockVector3.at(myregion.getMinimumPoint().getBlockX(), myregion.getMinimumPoint().getBlockY(), myregion.getMinimumPoint().getBlockZ());
                pos2 = BlockVector3.at(myregion.getMaximumPoint().getBlockX(), myregion.getMaximumPoint().getBlockY(), myregion.getMaximumPoint().getBlockZ());
            } else {
                return new FaweMask(Worldguard.adapt(myregion)){

                    @Override
                    public boolean isValid(Player player, FaweMaskManager.MaskType type) {
                        return Worldguard.this.isAllowed(Worldguard.this.worldguard.wrapPlayer(BukkitAdapter.adapt(player)), myregion);
                    }
                };
            }
            return new FaweMask(new CuboidRegion(pos1, pos2)){

                @Override
                public boolean isValid(Player player, FaweMaskManager.MaskType type) {
                    return Worldguard.this.isAllowed(Worldguard.this.worldguard.wrapPlayer(BukkitAdapter.adapt(player)), myregion);
                }
            };
        }
        return null;
    }

    @Override
    public RegionFilter getFilter(String world) {
        return new WorldGuardFilter(Bukkit.getWorld((String)world));
    }

    private static Region adapt(ProtectedRegion region) {
        if (region instanceof ProtectedCuboidRegion) {
            return new CuboidRegion(region.getMinimumPoint(), region.getMaximumPoint());
        }
        if (region instanceof GlobalProtectedRegion) {
            return RegionWrapper.GLOBAL();
        }
        if (region instanceof ProtectedPolygonalRegion) {
            ProtectedPolygonalRegion casted = (ProtectedPolygonalRegion)region;
            BlockVector3 max = region.getMaximumPoint();
            BlockVector3 min = region.getMinimumPoint();
            return new Polygonal2DRegion(null, casted.getPoints(), min.getBlockY(), max.getBlockY());
        }
        return new AdaptedRegion(region);
    }

    private static class AdaptedRegion
    extends AbstractRegion {
        private final ProtectedRegion region;

        public AdaptedRegion(ProtectedRegion region) {
            super(null);
            this.region = region;
        }

        @Override
        public BlockVector3 getMinimumPoint() {
            return this.region.getMinimumPoint();
        }

        @Override
        public BlockVector3 getMaximumPoint() {
            return this.region.getMaximumPoint();
        }

        @Override
        public void expand(BlockVector3 ... changes) {
            throw new UnsupportedOperationException("Region is immutable");
        }

        @Override
        public void contract(BlockVector3 ... changes) {
            throw new UnsupportedOperationException("Region is immutable");
        }

        @Override
        public boolean contains(BlockVector3 position) {
            return this.region.contains(position);
        }
    }
}

