/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions.plotsquared;

import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.RelightMode;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.TaskManager;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.generator.HybridPlotManager;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.util.RegionManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.function.biome.BiomeReplace;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.FlatRegionVisitor;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Set;
import org.bukkit.Bukkit;

public class FaweRegionManager
extends RegionManager {
    private final RegionManager parent;

    public FaweRegionManager(RegionManager parent) {
        this.parent = parent;
    }

    public int[] countEntities(Plot plot) {
        return this.parent.countEntities(plot);
    }

    public void clearAllEntities(Location pos1, Location pos2) {
        this.parent.clearAllEntities(pos1, pos2);
    }

    public boolean setCuboids(PlotArea area, Set<CuboidRegion> regions, Pattern blocks, int minY, int maxY) {
        if (!Settings.IMP.PLOTSQUARED_INTEGRATION.CUBOIDS) {
            return this.parent.setCuboids(area, regions, blocks, minY, maxY);
        }
        TaskManager.IMP.async(() -> {
            Class<FaweRegionManager> clazz = FaweRegionManager.class;
            synchronized (FaweRegionManager.class) {
                World world = BukkitAdapter.adapt(Bukkit.getWorld((String)area.getWorldName()));
                EditSession session = new EditSessionBuilder(world).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();
                for (CuboidRegion region : regions) {
                    region.setPos1(region.getPos1().withY(minY));
                    region.setPos2(region.getPos2().withY(maxY));
                    session.setBlocks((Region)region, blocks);
                }
                try {
                    session.flushQueue();
                    for (CuboidRegion region : regions) {
                        FaweAPI.fixLighting(world, region, null, RelightMode.valueOf(Settings.IMP.LIGHTING.MODE));
                    }
                }
                catch (MaxChangedBlocksException e) {
                    e.printStackTrace();
                }
                return;
            }
        });
        return true;
    }

    public boolean notifyClear(PlotManager manager) {
        if (!Settings.IMP.PLOTSQUARED_INTEGRATION.CLEAR || !(manager instanceof HybridPlotManager)) {
            return false;
        }
        HybridPlotWorld hpw = ((HybridPlotManager)manager).getHybridPlotWorld();
        return hpw.getType() != PlotAreaType.AUGMENTED || hpw.getTerrain() == PlotAreaTerrainType.NONE;
    }

    public boolean handleClear(Plot plot, Runnable whenDone, PlotManager manager) {
        if (!Settings.IMP.PLOTSQUARED_INTEGRATION.CLEAR || !(manager instanceof HybridPlotManager)) {
            return false;
        }
        TaskManager.IMP.async(() -> {
            Class<FaweRegionManager> clazz = FaweRegionManager.class;
            synchronized (FaweRegionManager.class) {
                HybridPlotWorld hybridPlotWorld = ((HybridPlotManager)manager).getHybridPlotWorld();
                World world = BukkitAdapter.adapt(Bukkit.getWorld((String)hybridPlotWorld.getWorldName()));
                EditSession editSession = new EditSessionBuilder(world).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();
                if (!hybridPlotWorld.PLOT_SCHEMATIC || !Settings.Schematics.PASTE_ON_TOP) {
                    BlockType air = BlockTypes.AIR;
                    BlockType bedrock = hybridPlotWorld.PLOT_BEDROCK ? BlockTypes.BEDROCK : air;
                    Pattern filling = hybridPlotWorld.MAIN_BLOCK.toPattern();
                    Pattern plotfloor = hybridPlotWorld.TOP_BLOCK.toPattern();
                    BiomeType biome = hybridPlotWorld.getPlotBiome();
                    BlockVector3 pos1 = BlockVector3.ZERO;
                    BlockVector3 pos2 = BlockVector3.at(hybridPlotWorld.PLOT_WIDTH - 1, 255, hybridPlotWorld.PLOT_WIDTH - 1);
                    CuboidRegion bedrockRegion = new CuboidRegion(pos1, pos2.withY(0));
                    CuboidRegion fillingRegion = new CuboidRegion(pos1.withY(1), pos2.withY(hybridPlotWorld.PLOT_HEIGHT - 1));
                    CuboidRegion floorRegion = new CuboidRegion(pos1.withY(hybridPlotWorld.PLOT_HEIGHT), pos2.withY(hybridPlotWorld.PLOT_HEIGHT));
                    CuboidRegion airRegion = new CuboidRegion(pos1.withY(hybridPlotWorld.PLOT_HEIGHT + 1), pos2.withY(manager.getWorldHeight()));
                    BlockArrayClipboard clipboard = new BlockArrayClipboard(new CuboidRegion(pos1, pos2));
                    clipboard.setBlocks((Region)bedrockRegion, (Pattern)bedrock);
                    clipboard.setBlocks((Region)fillingRegion, filling);
                    clipboard.setBlocks((Region)floorRegion, plotfloor);
                    clipboard.setBlocks((Region)airRegion, (Pattern)air);
                    for (int x = pos1.getX(); x <= pos2.getX(); ++x) {
                        for (int z = pos1.getZ(); z <= pos2.getZ(); ++z) {
                            clipboard.setBiome(BlockVector2.at(x, z), biome);
                        }
                    }
                    clipboard.paste(editSession, plot.getBottomAbs().getBlockVector3().withY(0), true, false, true);
                }
                if (hybridPlotWorld.PLOT_SCHEMATIC) {
                    File schematicFile = new File(hybridPlotWorld.getRoot(), "plot.schem");
                    if (!schematicFile.exists()) {
                        schematicFile = new File(hybridPlotWorld.getRoot(), "plot.schematic");
                    }
                    BlockVector3 to = plot.getBottomAbs().getBlockVector3().withY(Settings.Schematics.PASTE_ON_TOP ? hybridPlotWorld.SCHEM_Y : 1);
                    try {
                        Clipboard clip = ClipboardFormats.findByFile(schematicFile).getReader(new FileInputStream(schematicFile)).read();
                        clip.paste(editSession, to, true, true, true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                editSession.flushQueue();
                FaweAPI.fixLighting(world, new CuboidRegion(plot.getBottomAbs().getBlockVector3(), plot.getTopAbs().getBlockVector3()), null, RelightMode.valueOf(Settings.IMP.LIGHTING.MODE));
                TaskManager.IMP.task(whenDone);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        });
        return true;
    }

    public void swap(Location pos1, Location pos2, Location pos3, Location pos4, Runnable whenDone) {
        if (!Settings.IMP.PLOTSQUARED_INTEGRATION.COPY_AND_SWAP) {
            this.parent.swap(pos1, pos2, pos3, pos4, whenDone);
        }
        TaskManager.IMP.async(() -> {
            Class<FaweRegionManager> clazz = FaweRegionManager.class;
            synchronized (FaweRegionManager.class) {
                World pos1World = BukkitAdapter.adapt(Bukkit.getWorld((String)pos1.getWorld()));
                World pos3World = BukkitAdapter.adapt(Bukkit.getWorld((String)pos3.getWorld()));
                WorldEdit.getInstance().getEditSessionFactory().getEditSession(pos1World, -1);
                EditSession sessionA = new EditSessionBuilder(pos1World).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();
                EditSession sessionB = new EditSessionBuilder(pos3World).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();
                CuboidRegion regionA = new CuboidRegion(BlockVector3.at(pos1.getX(), pos1.getY(), pos1.getZ()), BlockVector3.at(pos2.getX(), pos2.getY(), pos2.getZ()));
                CuboidRegion regionB = new CuboidRegion(BlockVector3.at(pos3.getX(), pos3.getY(), pos3.getZ()), BlockVector3.at(pos4.getX(), pos4.getY(), pos4.getZ()));
                ForwardExtentCopy copyA = new ForwardExtentCopy(sessionA, regionA, sessionB, regionB.getMinimumPoint());
                ForwardExtentCopy copyB = new ForwardExtentCopy(sessionB, regionB, sessionA, regionA.getMinimumPoint());
                try {
                    Operations.completeLegacy(copyA);
                    Operations.completeLegacy(copyB);
                    sessionA.flushQueue();
                    sessionB.flushQueue();
                }
                catch (MaxChangedBlocksException e) {
                    e.printStackTrace();
                }
                FaweAPI.fixLighting(pos1World, new CuboidRegion(pos1.getBlockVector3(), pos2.getBlockVector3()), null, RelightMode.valueOf(Settings.IMP.LIGHTING.MODE));
                FaweAPI.fixLighting(pos1World, new CuboidRegion(pos3.getBlockVector3(), pos4.getBlockVector3()), null, RelightMode.valueOf(Settings.IMP.LIGHTING.MODE));
                TaskManager.IMP.task(whenDone);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        });
    }

    public void setBiome(CuboidRegion region, int extendBiome, BiomeType biome, String world, Runnable whenDone) {
        if (!Settings.IMP.PLOTSQUARED_INTEGRATION.SET_BIOME) {
            this.parent.setBiome(region, extendBiome, biome, world, whenDone);
        }
        region.expand(BlockVector3.at(extendBiome, 0, extendBiome));
        region.expand(BlockVector3.at(-extendBiome, 0, -extendBiome));
        TaskManager.IMP.async(() -> {
            Class<FaweRegionManager> clazz = FaweRegionManager.class;
            synchronized (FaweRegionManager.class) {
                EditSession editSession = new EditSessionBuilder(BukkitAdapter.adapt(Bukkit.getWorld((String)world))).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();
                BiomeReplace replace = new BiomeReplace((Extent)editSession, biome);
                FlatRegionVisitor visitor = new FlatRegionVisitor(region, replace);
                try {
                    Operations.completeLegacy(visitor);
                    editSession.flushQueue();
                }
                catch (MaxChangedBlocksException e) {
                    e.printStackTrace();
                }
                TaskManager.IMP.task(whenDone);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        });
    }

    public boolean copyRegion(Location pos1, Location pos2, Location pos3, Runnable whenDone) {
        if (!Settings.IMP.PLOTSQUARED_INTEGRATION.COPY_AND_SWAP) {
            return this.parent.copyRegion(pos1, pos2, pos3, whenDone);
        }
        TaskManager.IMP.async(() -> {
            Class<FaweRegionManager> clazz = FaweRegionManager.class;
            synchronized (FaweRegionManager.class) {
                World pos1World = BukkitAdapter.adapt(Bukkit.getWorld((String)pos1.getWorld()));
                World pos3World = BukkitAdapter.adapt(Bukkit.getWorld((String)pos3.getWorld()));
                EditSession from = new EditSessionBuilder(pos1World).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();
                EditSession to = new EditSessionBuilder(pos3World).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();
                CuboidRegion region = new CuboidRegion(BlockVector3.at(pos1.getX(), pos1.getY(), pos1.getZ()), BlockVector3.at(pos2.getX(), pos2.getY(), pos2.getZ()));
                ForwardExtentCopy copy = new ForwardExtentCopy(from, region, to, BlockVector3.at(pos3.getX(), pos3.getY(), pos3.getZ()));
                try {
                    Operations.completeLegacy(copy);
                    to.flushQueue();
                    FaweAPI.fixLighting(pos1World, new CuboidRegion(pos3.getBlockVector3(), pos3.getBlockVector3().add(pos2.getBlockVector3().subtract(pos1.getBlockVector3()))), null, RelightMode.valueOf(Settings.IMP.LIGHTING.MODE));
                }
                catch (MaxChangedBlocksException e) {
                    e.printStackTrace();
                }
                TaskManager.IMP.task(whenDone);
                return;
            }
        });
        return true;
    }

    public boolean regenerateRegion(Location pos1, Location pos2, boolean ignore, Runnable whenDone) {
        TaskManager.IMP.async(() -> {
            Class<FaweRegionManager> clazz = FaweRegionManager.class;
            synchronized (FaweRegionManager.class) {
                World pos1World = BukkitAdapter.adapt(Bukkit.getWorld((String)pos1.getWorld()));
                try (EditSession editSession = new EditSessionBuilder(pos1World).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();){
                    CuboidRegion region = new CuboidRegion(BlockVector3.at(pos1.getX(), pos1.getY(), pos1.getZ()), BlockVector3.at(pos2.getX(), pos2.getY(), pos2.getZ()));
                    editSession.regenerate(region);
                    editSession.flushQueue();
                }
                TaskManager.IMP.task(whenDone);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        });
        return true;
    }
}

