/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions.plotsquared;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.bukkit.regions.plotsquared.FaweLocalBlockQueue;
import com.boydti.fawe.object.clipboard.ReadOnlyClipboard;
import com.boydti.fawe.object.io.PGZIPOutputStream;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.IOUtil;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.queue.LocalBlockQueue;
import com.plotsquared.core.util.MainUtil;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.CompressedCompoundTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.fawe.CompressedSchematicTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.FastSchematicReader;
import com.sk89q.worldedit.extent.clipboard.io.FastSchematicWriter;
import com.sk89q.worldedit.extent.clipboard.io.MCEditSchematicReader;
import com.sk89q.worldedit.extent.clipboard.io.SpongeSchematicReader;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class FaweSchematicHandler
extends SchematicHandler {
    public boolean restoreTile(LocalBlockQueue queue, CompoundTag compoundTag, int x, int y, int z) {
        if (queue instanceof FaweLocalBlockQueue) {
            queue.setTile(x, y, z, compoundTag);
            return true;
        }
        return false;
    }

    public void getCompoundTag(String world, Set<CuboidRegion> regions, RunnableVal<CompoundTag> whenDone) {
        com.boydti.fawe.util.TaskManager.IMP.async(() -> {
            Location[] corners = MainUtil.getCorners((String)world, (Collection)regions);
            Location pos1 = corners[0];
            Location pos2 = corners[1];
            World adaptedWorld = BukkitAdapter.adapt(Bukkit.getWorld((String)world));
            CuboidRegion region = new CuboidRegion(BlockVector3.at(pos1.getX(), pos1.getY(), pos1.getZ()), BlockVector3.at(pos2.getX(), pos2.getY(), pos2.getZ()));
            EditSession editSession = new EditSessionBuilder(adaptedWorld).checkMemory(false).fastmode(true).limitUnlimited().changeSetNull().autoQueue(false).build();
            ReadOnlyClipboard clipboard = ReadOnlyClipboard.of(editSession, (Region)region, false, true);
            BlockArrayClipboard holder = new BlockArrayClipboard((Region)region, clipboard);
            CompressedSchematicTag tag = new CompressedSchematicTag(holder);
            whenDone.run((Object)tag);
        });
    }

    public boolean save(CompoundTag tag, String path) {
        block78: {
            if (tag == null) {
                PlotSquared.debug((Object)"&cCannot save empty tag");
                return false;
            }
            try {
                File tmp = MainUtil.getFile((File)PlotSquared.get().IMP.getDirectory(), (String)path);
                tmp.getParentFile().mkdirs();
                if (tag instanceof CompressedCompoundTag) {
                    CompressedCompoundTag cTag = (CompressedCompoundTag)tag;
                    if (cTag instanceof CompressedSchematicTag) {
                        Clipboard clipboard = (Clipboard)cTag.getSource();
                        try (FileOutputStream stream = new FileOutputStream(tmp);
                             NBTOutputStream output = new NBTOutputStream(new BufferedOutputStream(new PGZIPOutputStream(stream)));){
                            new FastSchematicWriter(output).write(clipboard);
                            break block78;
                        }
                    }
                    try (FileOutputStream stream = new FileOutputStream(tmp);
                         BufferedOutputStream output = new BufferedOutputStream(new PGZIPOutputStream(stream));){
                        LZ4BlockInputStream is = cTag.adapt(cTag.getSource());
                        IOUtil.copy((InputStream)is, stream);
                        break block78;
                    }
                }
                try (FileOutputStream stream = new FileOutputStream(tmp);
                     NBTOutputStream output = new NBTOutputStream(new PGZIPOutputStream(stream));){
                    Object map = tag.getValue();
                    output.writeNamedTag("Schematic", map.getOrDefault("Schematic", tag));
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void upload(CompoundTag tag, UUID uuid, String file, RunnableVal<URL> whenDone) {
        if (tag == null) {
            PlotSquared.debug((Object)"&cCannot save empty tag");
            TaskManager.runTask(whenDone);
            return;
        }
        final CompoundTag weTag = (CompoundTag)FaweCache.IMP.asTag((Object)tag);
        MainUtil.upload((UUID)uuid, (String)file, (String)"schem", (RunnableVal)new RunnableVal<OutputStream>(){

            public void run(OutputStream output) {
                if (weTag instanceof CompressedSchematicTag) {
                    Clipboard clipboard = (Clipboard)((CompressedSchematicTag)weTag).getSource();
                    BuiltInClipboardFormat.SPONGE_SCHEMATIC.write(output, clipboard);
                }
                try (PGZIPOutputStream gzip = new PGZIPOutputStream(output);
                     NBTOutputStream nos = new NBTOutputStream(gzip);){
                    Object map = weTag.getValue();
                    nos.writeNamedTag("Schematic", map.getOrDefault("Schematic", weTag));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, whenDone);
    }

    public Schematic getSchematic(@NotNull InputStream is) {
        try {
            FastSchematicReader schematicReader = new FastSchematicReader(new NBTInputStream(new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(is)))));
            Clipboard clip = schematicReader.read();
            return new Schematic(clip);
        }
        catch (IOException e) {
            if (e instanceof EOFException) {
                e.printStackTrace();
                return null;
            }
            try {
                SpongeSchematicReader schematicReader = new SpongeSchematicReader(new NBTInputStream(new GZIPInputStream(is)));
                Clipboard clip = schematicReader.read();
                return new Schematic(clip);
            }
            catch (IOException e2) {
                if (e2 instanceof EOFException) {
                    e.printStackTrace();
                    return null;
                }
                try {
                    MCEditSchematicReader schematicReader = new MCEditSchematicReader(new NBTInputStream(new GZIPInputStream(is)));
                    Clipboard clip = schematicReader.read();
                    return new Schematic(clip);
                }
                catch (IOException e3) {
                    e.printStackTrace();
                    PlotSquared.debug((Object)(is.toString() + " | " + is.getClass().getCanonicalName() + " is not in GZIP format : " + e.getMessage()));
                    return null;
                }
            }
        }
    }
}

