/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions.plotsquared;

import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.TaskManager;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Captions;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.MainUtil;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.biome.Biomes;
import com.sk89q.worldedit.world.registry.BiomeRegistry;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;

@CommandDeclaration(command="generatebiome", permission="plots.generatebiome", category=CommandCategory.APPEARANCE, requiredType=RequiredType.NONE, description="Generate a biome in your plot", aliases={"bg", "gb"}, usage="/plots generatebiome <biome>")
public class PlotSetBiome
extends Command {
    public PlotSetBiome() {
        super((Command)MainCommand.getInstance(), true);
    }

    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) throws Command.CommandException {
        Plot plot = (Plot)this.check(player.getCurrentPlot(), Captions.NOT_IN_PLOT, new Object[0]);
        this.checkTrue(plot.isOwner(player.getUUID()) || Permissions.hasPermission(player, (String)"plots.admin.command.generatebiome"), Captions.NO_PLOT_PERMS, new Object[0]);
        if (plot.getRunning() != 0) {
            Captions.WAIT_FOR_TIMER.send(player, new String[0]);
            return null;
        }
        this.checkTrue(args.length == 1, Captions.COMMAND_SYNTAX, new Object[]{this.getUsage()});
        Set regions = plot.getRegions();
        BiomeRegistry biomeRegistry = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getBiomeRegistry();
        Collection<BiomeType> knownBiomes = BiomeTypes.values();
        BiomeType biome = Biomes.findBiomeByName(knownBiomes, args[0], biomeRegistry);
        if (biome == null) {
            String biomes = StringMan.join(BiomeType.REGISTRY.values(), (String)Captions.BLOCK_LIST_SEPARATOR.getTranslated());
            Captions.NEED_BIOME.send(player, new String[0]);
            MainUtil.sendMessage(player, (String)(Captions.SUBCOMMAND_SET_OPTIONS_HEADER.toString() + biomes));
            return CompletableFuture.completedFuture(false);
        }
        confirm.run((Object)this, () -> {
            if (plot.getRunning() != 0) {
                Captions.WAIT_FOR_TIMER.send(player, new String[0]);
                return;
            }
            plot.addRunning();
            TaskManager.IMP.async(() -> {
                EditSession session = new EditSessionBuilder(BukkitAdapter.adapt(Bukkit.getWorld((String)plot.getArea().getWorldName()))).autoQueue(false).checkMemory(false).allowedRegionsEverywhere().player(BukkitAdapter.adapt(Bukkit.getPlayer((UUID)player.getUUID()))).limitUnlimited().build();
                long seed = ThreadLocalRandom.current().nextLong();
                for (CuboidRegion region : regions) {
                    session.regenerate(region, biome, seed);
                }
                session.flushQueue();
                plot.removeRunning();
            });
        }, null);
        return CompletableFuture.completedFuture(true);
    }
}

