/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions.plotsquared;

import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.bukkit.regions.plotsquared.FaweRegionManager;
import com.boydti.fawe.bukkit.regions.plotsquared.FaweSchematicHandler;
import com.boydti.fawe.bukkit.regions.plotsquared.FaweTrim;
import com.boydti.fawe.bukkit.regions.plotsquared.PlotRegionFilter;
import com.boydti.fawe.bukkit.regions.plotsquared.PlotSetBiome;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.regions.FaweMask;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.regions.general.RegionFilter;
import com.github.intellectualsites.plotsquared.plot.util.UUIDHandler;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.NoWorldeditFlag;
import com.plotsquared.core.util.RegionManager;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.WEManager;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionIntersection;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.world.World;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class PlotSquaredFeature
extends FaweMaskManager {
    private static final Logger log = LoggerFactory.getLogger(PlotSquaredFeature.class);

    public PlotSquaredFeature() {
        super("PlotSquared");
        log.debug("Optimizing PlotSquared");
        if (Settings.IMP.ENABLED_COMPONENTS.PLOTSQUARED_HOOK) {
            Settings.Enabled_Components.WORLDEDIT_RESTRICTIONS = false;
            try {
                this.setupBlockQueue();
                this.setupSchematicHandler();
                this.setupRegionManager();
            }
            catch (Throwable ignored) {
                log.debug("Please update PlotSquared: https://www.spigotmc.org/resources/plotsquared-v5.77506/");
            }
            if (com.plotsquared.core.configuration.Settings.PLATFORM.toLowerCase(Locale.ROOT).startsWith("bukkit")) {
                new FaweTrim();
            }
            if (MainCommand.getInstance().getCommand("generatebiome") == null) {
                new PlotSetBiome();
            }
        }
    }

    public static String getName(UUID uuid) {
        return UUIDHandler.getName((UUID)uuid);
    }

    private void setupBlockQueue() throws RuntimeException {
    }

    private void setupRegionManager() throws RuntimeException {
        RegionManager.manager = new FaweRegionManager(RegionManager.manager);
        log.debug(" - RegionManager: " + RegionManager.manager);
    }

    private void setupSchematicHandler() throws RuntimeException {
        SchematicHandler.manager = new FaweSchematicHandler();
        log.debug(" - SchematicHandler: " + SchematicHandler.manager);
    }

    public boolean isAllowed(Player player, Plot plot, FaweMaskManager.MaskType type) {
        if (plot == null) {
            return false;
        }
        UUID uid = player.getUniqueId();
        return (Boolean)plot.getFlag(NoWorldeditFlag.class) == false && (plot.isOwner(uid) || type == FaweMaskManager.MaskType.MEMBER && (plot.getTrusted().contains(uid) || plot.getTrusted().contains(DBFunc.EVERYONE) || (plot.getMembers().contains(uid) || plot.getMembers().contains(DBFunc.EVERYONE)) && player.hasPermission("fawe.plotsquared.member")) || player.hasPermission("fawe.plotsquared.admin"));
    }

    @Override
    public FaweMask getMask(Player player, FaweMaskManager.MaskType type) {
        AbstractRegion maskedRegion;
        Set regions;
        PlotPlayer pp = PlotPlayer.wrap((Object)player.getUniqueId());
        if (pp == null) {
            return null;
        }
        Plot plot = pp.getCurrentPlot();
        if (this.isAllowed(player, plot, type)) {
            regions = plot.getRegions();
        } else {
            CuboidRegion region;
            plot = null;
            regions = WEManager.getMask((PlotPlayer)pp);
            if (regions.size() == 1 && (region = (CuboidRegion)regions.iterator().next()).getMinimumPoint().getX() == Integer.MIN_VALUE && region.getMaximumPoint().getX() == Integer.MAX_VALUE) {
                regions.clear();
            }
        }
        if (regions.isEmpty()) {
            return null;
        }
        PlotArea area = pp.getApplicablePlotArea();
        final Plot finalPlot = plot;
        if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)finalPlot) || regions.isEmpty()) {
            return null;
        }
        if (regions.size() == 1) {
            int min = area != null ? area.getMinBuildHeight() : 0;
            int max = area != null ? Math.min(255, area.getMaxBuildHeight()) : 255;
            CuboidRegion region = (CuboidRegion)regions.iterator().next();
            BlockVector3 pos1 = BlockVector3.at(region.getMinimumX(), min, region.getMinimumZ());
            BlockVector3 pos2 = BlockVector3.at(region.getMaximumX(), max, region.getMaximumZ());
            maskedRegion = new CuboidRegion(pos1, pos2);
        } else {
            World world = FaweAPI.getWorld(area.getWorldName());
            List<Region> weRegions = regions.stream().map(r -> new CuboidRegion(world, BlockVector3.at(r.getMinimumX(), r.getMinimumY(), r.getMinimumZ()), BlockVector3.at(r.getMaximumX(), r.getMaximumY(), r.getMaximumZ()))).collect(Collectors.toList());
            maskedRegion = new RegionIntersection(world, weRegions);
        }
        return new FaweMask(maskedRegion){

            @Override
            public boolean isValid(Player player, FaweMaskManager.MaskType type) {
                if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone((Plot)finalPlot)) {
                    return false;
                }
                return PlotSquaredFeature.this.isAllowed(player, finalPlot, type);
            }
        };
    }

    @Override
    public RegionFilter getFilter(String world) {
        PlotArea area = PlotSquared.get().getPlotArea(world, null);
        if (area != null) {
            return new PlotRegionFilter(area);
        }
        return null;
    }
}

